/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.minecraft.item.ItemStack;

public interface ILinkedAction {

    public static final class OwnerChanged
    implements ILinkedAction {
        public final Owner newOwner;

        public OwnerChanged(Owner newOwner) {
            this.newOwner = newOwner;
        }
    }

    public static final class ModuleRemoved
    implements ILinkedAction {
        public final EnumModuleType moduleType;
        public final boolean wasModuleToggled;

        public ModuleRemoved(EnumModuleType moduleType, boolean wasModuleToggled) {
            this.moduleType = moduleType;
            this.wasModuleToggled = wasModuleToggled;
        }
    }

    public static final class ModuleInserted
    implements ILinkedAction {
        public final ItemStack stack;
        public final ItemModule module;
        public final boolean wasModuleToggled;

        public ModuleInserted(ItemStack stack, ItemModule module, boolean wasModuleToggled) {
            this.stack = stack;
            this.module = module;
            this.wasModuleToggled = wasModuleToggled;
        }
    }

    public static final class OptionChanged<T>
    implements ILinkedAction {
        public final Option<T> option;

        public OptionChanged(Option<T> option) {
            this.option = option;
        }
    }
}

