/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Predicate;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.TileEntityLinkable;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public interface IModuleInventory
extends IItemHandlerModifiable {
    public NonNullList<ItemStack> getInventory();

    public EnumModuleType[] acceptedModules();

    public boolean isModuleEnabled(EnumModuleType var1);

    public void toggleModuleState(EnumModuleType var1, boolean var2);

    default public TileEntity getTileEntity() {
        return (TileEntity)this;
    }

    default public int getMaxNumberOfModules() {
        return this.acceptedModules().length;
    }

    default public void onModuleInserted(ItemStack stack, EnumModuleType module, boolean toggled) {
        TileEntity te = this.getTileEntity();
        if (!te.func_145831_w().field_72995_K) {
            IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
            if (!toggled) {
                this.toggleModuleState(module, true);
            }
            te.func_70296_d();
            te.func_145831_w().func_184138_a(te.func_174877_v(), state, state, 3);
            te.func_145831_w().func_175685_c(te.func_174877_v(), te.func_145838_q(), false);
            FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148540_a((Packet)this.getTileEntity().func_189518_D_());
        }
    }

    default public void onModuleRemoved(ItemStack stack, EnumModuleType module, boolean toggled) {
        TileEntity te = this.getTileEntity();
        if (!te.func_145831_w().field_72995_K) {
            IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
            if (!toggled) {
                this.toggleModuleState(module, false);
            }
            te.func_70296_d();
            te.func_145831_w().func_184138_a(te.func_174877_v(), state, state, 3);
            te.func_145831_w().func_175685_c(te.func_174877_v(), te.func_145838_q(), false);
            FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148540_a((Packet)this.getTileEntity().func_189518_D_());
        }
    }

    default public boolean enableHack() {
        return false;
    }

    default public int fixSlotId(int id) {
        return id >= 100 ? id - 100 : id;
    }

    default public void dropAllModules() {
        TileEntity te = this.getTileEntity();
        World level = te.func_145831_w();
        BlockPos pos = te.func_174877_v();
        TileEntityLinkable linkable = te instanceof TileEntityLinkable ? (TileEntityLinkable)te : null;
        for (ItemStack module : this.getInventory()) {
            if (!(module.func_77973_b() instanceof ItemModule)) continue;
            if (linkable != null) {
                linkable.createLinkedBlockAction((ILinkedAction)new ILinkedAction.ModuleRemoved(((ItemModule)module.func_77973_b()).getModuleType(), false), linkable);
            }
            Block.func_180635_a((World)level, (BlockPos)pos, (ItemStack)module);
        }
        this.getInventory().clear();
    }

    default public int getSlots() {
        return this.acceptedModules().length;
    }

    default public ItemStack getStackInSlot(int slot) {
        return this.getModuleInSlot(slot);
    }

    default public ItemStack getModuleInSlot(int slot) {
        return (slot = this.fixSlotId(slot)) < 0 || slot >= this.getSlots() ? ItemStack.field_190927_a : (ItemStack)this.getInventory().get(slot);
    }

    default public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack = this.getModuleInSlot(slot = this.fixSlotId(slot)).func_77946_l();
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!simulate) {
            TileEntity te = this.getTileEntity();
            if (stack.func_77973_b() instanceof ItemModule) {
                this.onModuleRemoved(stack, ((ItemModule)stack.func_77973_b()).getModuleType(), false);
                if (te instanceof TileEntityLinkable) {
                    TileEntityLinkable linkable = (TileEntityLinkable)te;
                    linkable.createLinkedBlockAction((ILinkedAction)new ILinkedAction.ModuleRemoved(((ItemModule)stack.func_77973_b()).getModuleType(), false), linkable);
                }
            }
            return ((ItemStack)this.getInventory().set(slot, (Object)ItemStack.field_190927_a)).func_77946_l();
        }
        return stack.func_77946_l();
    }

    default public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.getModuleInSlot(slot = this.fixSlotId(slot)).func_190926_b()) {
            return stack;
        }
        int returnSize = 0;
        if (stack.func_190916_E() > 1) {
            returnSize = stack.func_190916_E() - 1;
        }
        if (!simulate) {
            ItemStack copy = stack.func_77946_l();
            TileEntity te = this.getTileEntity();
            copy.func_190920_e(1);
            this.getInventory().set(slot, (Object)copy);
            if (stack.func_77973_b() instanceof ItemModule) {
                this.onModuleInserted(stack, ((ItemModule)stack.func_77973_b()).getModuleType(), false);
                if (te instanceof TileEntityLinkable) {
                    TileEntityLinkable linkable = (TileEntityLinkable)te;
                    linkable.createLinkedBlockAction((ILinkedAction)new ILinkedAction.ModuleInserted(copy, (ItemModule)copy.func_77973_b(), false), linkable);
                }
            }
        }
        if (returnSize != 0) {
            ItemStack toReturn = stack.func_77946_l();
            toReturn.func_190920_e(returnSize);
            return toReturn;
        }
        return ItemStack.field_190927_a;
    }

    default public void setStackInSlot(int slot, ItemStack stack) {
        TileEntityLinkable linkable;
        slot = this.fixSlotId(slot);
        TileEntity te = this.getTileEntity();
        ItemStack previous = this.getModuleInSlot(slot);
        if (!previous.func_190926_b()) {
            this.onModuleRemoved(previous, ((ItemModule)previous.func_77973_b()).getModuleType(), false);
            if (te instanceof TileEntityLinkable) {
                linkable = (TileEntityLinkable)te;
                linkable.createLinkedBlockAction((ILinkedAction)new ILinkedAction.ModuleRemoved(((ItemModule)previous.func_77973_b()).getModuleType(), false), linkable);
            }
        }
        this.getInventory().set(slot, (Object)stack);
        if (stack.func_77973_b() instanceof ItemModule) {
            this.onModuleInserted(stack, ((ItemModule)stack.func_77973_b()).getModuleType(), false);
            if (te instanceof TileEntityLinkable) {
                linkable = (TileEntityLinkable)te;
                linkable.createLinkedBlockAction((ILinkedAction)new ILinkedAction.ModuleInserted(stack, (ItemModule)stack.func_77973_b(), false), linkable);
            }
        }
    }

    default public int getSlotLimit(int slot) {
        return 1;
    }

    default public boolean isItemValid(int slot, ItemStack stack) {
        return this.getModuleInSlot(slot = this.fixSlotId(slot)).func_190926_b() && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemModule && this.acceptsModule(((ItemModule)stack.func_77973_b()).getModuleType()) && !this.hasModule(((ItemModule)stack.func_77973_b()).getModuleType());
    }

    default public boolean acceptsModule(EnumModuleType type) {
        for (EnumModuleType module : this.acceptedModules()) {
            if (module != type) continue;
            return true;
        }
        return false;
    }

    default public ArrayList<EnumModuleType> getInsertedModules() {
        ArrayList<EnumModuleType> modules = new ArrayList<EnumModuleType>();
        for (ItemStack stack : this.getInventory()) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemModule)) continue;
            modules.add(((ItemModule)stack.func_77973_b()).getModuleType());
        }
        return modules;
    }

    default public ItemStack getModule(EnumModuleType module) {
        NonNullList<ItemStack> modules = this.getInventory();
        for (int i = 0; i < modules.size(); ++i) {
            if (((ItemStack)modules.get(i)).func_190926_b() || !(((ItemStack)modules.get(i)).func_77973_b() instanceof ItemModule) || ((ItemModule)((ItemStack)modules.get(i)).func_77973_b()).getModuleType() != module) continue;
            return (ItemStack)modules.get(i);
        }
        return ItemStack.field_190927_a;
    }

    default public void insertModule(ItemStack module, boolean toggled) {
        if (module.func_190926_b() || !(module.func_77973_b() instanceof ItemModule)) {
            return;
        }
        ItemModule moduleItem = (ItemModule)module.func_77973_b();
        NonNullList<ItemStack> modules = this.getInventory();
        if (!toggled) {
            for (int i = 0; i < modules.size(); ++i) {
                if (((ItemStack)modules.get(i)).func_190926_b() || ((ItemStack)modules.get(i)).func_77973_b() != module.func_77973_b()) continue;
                return;
            }
        }
        Predicate<ItemStack> predicate = toggled ? stack -> stack.func_77973_b() == moduleItem : stack -> stack.func_190926_b();
        for (int i = 0; i < modules.size(); ++i) {
            if (!predicate.test((ItemStack)modules.get(i))) continue;
            ItemStack toInsert = module.func_77946_l();
            if (toggled) {
                this.toggleModuleState(moduleItem.getModuleType(), true);
                break;
            }
            modules.set(i, (Object)toInsert);
            this.onModuleInserted(toInsert, moduleItem.getModuleType(), toggled);
            break;
        }
    }

    default public void removeModule(EnumModuleType module, boolean toggled) {
        NonNullList<ItemStack> modules = this.getInventory();
        for (int i = 0; i < modules.size(); ++i) {
            if (((ItemStack)modules.get(i)).func_190926_b() || !(((ItemStack)modules.get(i)).func_77973_b() instanceof ItemModule) || ((ItemModule)((ItemStack)modules.get(i)).func_77973_b()).getModuleType() != module) continue;
            if (toggled) {
                this.toggleModuleState(module, false);
                continue;
            }
            modules.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    default public boolean hasModule(EnumModuleType module) {
        NonNullList<ItemStack> modules = this.getInventory();
        if (module == null) {
            for (int i = 0; i < modules.size(); ++i) {
                if (!((ItemStack)modules.get(i)).func_190926_b()) continue;
                return true;
            }
        } else {
            for (int i = 0; i < modules.size(); ++i) {
                if (((ItemStack)modules.get(i)).func_190926_b() || !(((ItemStack)modules.get(i)).func_77973_b() instanceof ItemModule) || ((ItemModule)((ItemStack)modules.get(i)).func_77973_b()).getModuleType() != module) continue;
                return true;
            }
        }
        return false;
    }

    default public NonNullList<ItemStack> readModuleInventory(NBTTagCompound tag) {
        NBTTagList list = tag.func_150295_c("Modules", 10);
        NonNullList modules = NonNullList.func_191197_a((int)this.getMaxNumberOfModules(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound stackTag = list.func_150305_b(i);
            byte slot = stackTag.func_74771_c("ModuleSlot");
            if (slot < 0 || slot >= modules.size()) continue;
            modules.set((int)slot, (Object)new ItemStack(stackTag));
        }
        return modules;
    }

    default public EnumMap<EnumModuleType, Boolean> readModuleStates(NBTTagCompound tag) {
        EnumMap<EnumModuleType, Boolean> moduleStates = new EnumMap<EnumModuleType, Boolean>(EnumModuleType.class);
        List<EnumModuleType> acceptedModules = Arrays.asList(this.acceptedModules());
        for (EnumModuleType module : EnumModuleType.values()) {
            if (acceptedModules.contains((Object)module)) {
                String key = module.name().toLowerCase() + "Enabled";
                if (tag.func_74764_b(key)) {
                    moduleStates.put(module, tag.func_74767_n(key));
                    continue;
                }
                moduleStates.put(module, this.hasModule(module));
                continue;
            }
            moduleStates.put(module, false);
        }
        return moduleStates;
    }

    default public NBTTagCompound writeModuleInventory(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        NonNullList<ItemStack> modules = this.getInventory();
        for (int i = 0; i < modules.size(); ++i) {
            if (((ItemStack)modules.get(i)).func_190926_b()) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("ModuleSlot", (byte)i);
            ((ItemStack)modules.get(i)).func_77955_b(stackTag);
            list.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a("Modules", (NBTBase)list);
        return tag;
    }

    default public NBTTagCompound writeModuleStates(NBTTagCompound tag) {
        for (EnumModuleType module : this.acceptedModules()) {
            tag.func_74757_a(module.name().toLowerCase() + "Enabled", this.isModuleEnabled(module));
        }
        return tag;
    }
}

