/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.gui.components.GuiSlider;
import net.geforcemods.securitycraft.network.server.UpdateSliderValue;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class Option<T> {
    private String name;
    protected T value;
    private T defaultValue;
    private T increment;
    private T minimum;
    private T maximum;

    public Option(String optionName, T value) {
        this.name = optionName;
        this.value = value;
        this.defaultValue = value;
    }

    public Option(String optionName, T value, T min, T max, T increment) {
        this.name = optionName;
        this.value = value;
        this.defaultValue = value;
        this.increment = increment;
        this.minimum = min;
        this.maximum = max;
    }

    public abstract void toggle();

    public abstract void readFromNBT(NBTTagCompound var1);

    public abstract void writeToNBT(NBTTagCompound var1);

    public void copy(Option<?> option) {
        this.value = option.get();
    }

    public final String getName() {
        return this.name;
    }

    public T get() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getIncrement() {
        return this.increment;
    }

    public T getMin() {
        return this.minimum;
    }

    public T getMax() {
        return this.maximum;
    }

    public boolean isSlider() {
        return false;
    }

    public String getKey(Block block) {
        return "option." + block.func_149739_a().substring(5) + "." + this.getName();
    }

    public String getDescriptionKey(Block block) {
        return this.getKey(block) + ".description";
    }

    public String toString() {
        return this.value + "";
    }

    public static class OptionFloat
    extends Option<Float> {
        public OptionFloat(String optionName, Float value) {
            super(optionName, value);
        }

        public OptionFloat(String optionName, Float value, Float min, Float max, Float increment) {
            super(optionName, value, min, max, increment);
        }

        @Override
        public void toggle() {
            if (((Float)this.get()).floatValue() >= ((Float)this.getMax()).floatValue()) {
                this.setValue(this.getMin());
                return;
            }
            if (((Float)this.get()).floatValue() + ((Float)this.getIncrement()).floatValue() >= ((Float)this.getMax()).floatValue()) {
                this.setValue(this.getMax());
                return;
            }
            this.setValue(Float.valueOf(((Float)this.get()).floatValue() + ((Float)this.getIncrement()).floatValue()));
        }

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            this.value = tag.func_74764_b(this.getName()) ? Float.valueOf(tag.func_74760_g(this.getName())) : this.getDefaultValue();
        }

        @Override
        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74776_a(this.getName(), ((Float)this.value).floatValue());
        }

        @Override
        public String toString() {
            return Float.toString(((Float)this.value).floatValue()).length() > 5 ? Float.toString(((Float)this.value).floatValue()).substring(0, 5) : Float.toString(((Float)this.value).floatValue());
        }
    }

    public static class OptionDouble
    extends Option<Double>
    implements GuiSlider.ISlider {
        private boolean slider;
        private Supplier<BlockPos> pos;

        public OptionDouble(String optionName, Double value) {
            super(optionName, value);
            this.slider = false;
        }

        public OptionDouble(String optionName, Double value, Double min, Double max, Double increment) {
            super(optionName, value, min, max, increment);
            this.slider = false;
        }

        public OptionDouble(Supplier<BlockPos> pos, String optionName, Double value, Double min, Double max, Double increment, boolean s) {
            super(optionName, value, min, max, increment);
            this.slider = s;
            this.pos = pos;
        }

        @Override
        public void toggle() {
            if (this.isSlider()) {
                return;
            }
            if ((Double)this.get() >= (Double)this.getMax()) {
                this.setValue(this.getMin());
                return;
            }
            if ((Double)this.get() + (Double)this.getIncrement() >= (Double)this.getMax()) {
                this.setValue(this.getMax());
                return;
            }
            this.setValue((Double)this.get() + (Double)this.getIncrement());
        }

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            this.value = tag.func_74764_b(this.getName()) ? Double.valueOf(tag.func_74769_h(this.getName())) : this.getDefaultValue();
        }

        @Override
        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74780_a(this.getName(), ((Double)this.value).doubleValue());
        }

        @Override
        public String toString() {
            return Double.toString((Double)this.value).length() > 5 ? Double.toString((Double)this.value).substring(0, 5) : Double.toString((Double)this.value);
        }

        @Override
        public boolean isSlider() {
            return this.slider;
        }

        @Override
        public void onChangeSliderValue(GuiSlider slider, String blockName, int id) {
            if (!this.isSlider()) {
                return;
            }
            this.setValue(slider.getValue());
            slider.field_146126_j = (Utils.localize("option." + blockName + "." + this.getName(), new Object[0]).func_150254_d() + " ").replace("#", this.toString());
        }

        @Override
        public void onMouseRelease(int id) {
            SecurityCraft.network.sendToServer((IMessage)new UpdateSliderValue(this.pos.get(), id, (Double)this.get()));
        }
    }

    public static class OptionInt
    extends Option<Integer>
    implements GuiSlider.ISlider {
        private boolean slider;
        private Supplier<BlockPos> pos;

        public OptionInt(String optionName, Integer value) {
            super(optionName, value);
            this.slider = false;
        }

        public OptionInt(String optionName, Integer value, Integer min, Integer max, Integer increment) {
            super(optionName, value, min, max, increment);
            this.slider = false;
        }

        public OptionInt(Supplier<BlockPos> pos, String optionName, Integer value, Integer min, Integer max, Integer increment, boolean s) {
            super(optionName, value, min, max, increment);
            this.slider = s;
            this.pos = pos;
        }

        @Override
        public void toggle() {
            if (this.isSlider()) {
                return;
            }
            if ((Integer)this.get() >= (Integer)this.getMax()) {
                this.setValue(this.getMin());
                return;
            }
            if ((Integer)this.get() + (Integer)this.getIncrement() >= (Integer)this.getMax()) {
                this.setValue(this.getMax());
                return;
            }
            this.setValue((Integer)this.get() + (Integer)this.getIncrement());
        }

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            this.value = tag.func_74764_b(this.getName()) ? Integer.valueOf(tag.func_74762_e(this.getName())) : this.getDefaultValue();
        }

        @Override
        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a(this.getName(), ((Integer)this.value).intValue());
        }

        @Override
        public boolean isSlider() {
            return this.slider;
        }

        @Override
        public void onChangeSliderValue(GuiSlider slider, String blockName, int id) {
            if (!this.isSlider()) {
                return;
            }
            this.setValue((int)slider.getValue());
            slider.field_146126_j = (Utils.localize("option." + blockName + "." + this.getName(), new Object[0]).func_150254_d() + " ").replace("#", this.toString());
        }

        @Override
        public void onMouseRelease(int id) {
            SecurityCraft.network.sendToServer((IMessage)new UpdateSliderValue(this.pos.get(), id, ((Integer)this.get()).intValue()));
        }
    }

    public static class DisabledOption
    extends OptionBoolean {
        public DisabledOption(Boolean value) {
            super("disabled", value);
        }

        @Override
        public String getKey(Block block) {
            return "option.generic.disabled";
        }
    }

    public static class OptionBoolean
    extends Option<Boolean> {
        public OptionBoolean(String optionName, Boolean value) {
            super(optionName, value);
        }

        @Override
        public void toggle() {
            this.setValue((Boolean)this.get() == false);
        }

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            this.value = tag.func_74764_b(this.getName()) ? Boolean.valueOf(tag.func_74767_n(this.getName())) : this.getDefaultValue();
        }

        @Override
        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74757_a(this.getName(), ((Boolean)this.value).booleanValue());
        }
    }
}

