/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.geforcemods.securitycraft.tileentity.TileEntitySonicSecuritySystem;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSonicSecuritySystem
extends BlockOwnable {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.4, 0.0, 0.4, 0.6, 1.0, 0.6);
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockSonicSecuritySystem(Material material) {
        super(material);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        BlockPos downPos = pos.func_177977_b();
        return world.func_180495_p(downPos).isSideSolid((IBlockAccess)world, downPos, EnumFacing.UP);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntitySonicSecuritySystem) {
            ((TileEntitySonicSecuritySystem)te).transferPositionsFromItem(stack.func_77978_p());
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_184586_b(hand).func_77973_b() != SCContent.portableTunePlayer) {
            TileEntitySonicSecuritySystem te = (TileEntitySonicSecuritySystem)world.func_175625_s(pos);
            if (!world.field_72995_K && (te.getOwner().isOwner(player) || ModuleUtils.isAllowed((IModuleInventory)te, (Entity)player))) {
                player.openGui((Object)SecurityCraft.instance, 107, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return false;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity te;
        if (player.func_184812_l_() && (te = world.func_175625_s(pos)) instanceof IModuleInventory) {
            ((IModuleInventory)te).getInventory().clear();
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IModuleInventory) {
            ((IModuleInventory)te).dropAllModules();
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149744_f(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED);
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 15 : 0;
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false && side == EnumFacing.UP ? 15 : 0;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED});
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        NBTTagCompound blockTag = world.func_175625_s(pos).func_189517_E_();
        ItemStack stack = new ItemStack(SCContent.sonicSecuritySystem);
        if (!blockTag.func_74764_b("LinkedBlocks")) {
            return stack;
        }
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74782_a("LinkedBlocks", (NBTBase)blockTag.func_150295_c("LinkedBlocks", 10));
        return stack;
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntitySonicSecuritySystem();
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 1 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(meta == 1));
    }
}

