/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.geforcemods.securitycraft.tileentity.TileEntityIMS;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockIMS
extends BlockOwnable {
    public static final PropertyInteger MINES = PropertyInteger.func_177719_a((String)"mines", (int)0, (int)4);

    public BlockIMS(Material material) {
        super(material);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.45f, 1.0);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (world.func_180495_p(pos.func_177977_b()).func_185904_a() != Material.field_151579_a) {
            return;
        }
        world.func_175655_b(pos, true);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity te;
        if (player.func_184812_l_() && (te = world.func_175625_s(pos)) instanceof IModuleInventory) {
            ((IModuleInventory)te).getInventory().clear();
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IModuleInventory) {
            ((IModuleInventory)te).dropAllModules();
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof TileEntityIMS) {
            TileEntityIMS te = (TileEntityIMS)tile;
            if (te.isDisabled()) {
                player.func_146105_b((ITextComponent)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            } else if (te.getOwner().isOwner(player)) {
                ItemStack held = player.func_184586_b(hand);
                int mines = (Integer)state.func_177229_b((IProperty)MINES);
                if (held.func_77973_b() == Item.func_150898_a((Block)SCContent.bouncingBetty) && mines < 4) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        held.func_190918_g(1);
                    }
                    world.func_175656_a(pos, state.func_177226_a((IProperty)MINES, (Comparable)Integer.valueOf(mines + 1)));
                    te.setBombsRemaining(mines + 1);
                } else {
                    player.openGui((Object)SecurityCraft.instance, 11, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
        if (world.func_175625_s(pos) instanceof TileEntityIMS && ((TileEntityIMS)world.func_175625_s(pos)).getBombsRemaining() == 0) {
            double x = (double)((float)pos.func_177958_n() + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            double y = (double)((float)pos.func_177956_o() + 0.4f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            double z = (double)((float)pos.func_177952_p() + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            double magicNumber1 = 0.22f;
            double magicNumber2 = 0.27f;
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x - magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y + magicNumber1, z - magicNumber2, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y + magicNumber1, z + magicNumber2, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, x - magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, x + magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int mines = (Integer)state.func_177229_b((IProperty)MINES);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (mines != 0) {
            drops.add(new ItemStack(SCContent.bouncingBetty, mines));
        }
        return drops;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)MINES, (Comparable)Integer.valueOf(4));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)MINES, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)MINES);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MINES});
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityIMS();
    }
}

