/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.TileEntityReinforcedDoor;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockReinforcedDoor
extends BlockDoor
implements ITileEntityProvider {
    public BlockReinforcedDoor(Material material) {
        super(material);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public float func_149638_a(Entity exploder) {
        return Float.MAX_VALUE;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return Float.MAX_VALUE;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        this.onNeighborChanged((IBlockAccess)world, pos, fromPos);
    }

    public void onNeighborChanged(IBlockAccess access, BlockPos pos, BlockPos neighbor) {
        World world = (World)access;
        IBlockState state = world.func_180495_p(pos);
        Block neighborBlock = world.func_180495_p(neighbor).func_177230_c();
        if (state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
            BlockPos blockBelow = pos.func_177977_b();
            IBlockState stateBelow = world.func_180495_p(blockBelow);
            if (stateBelow.func_177230_c() != this) {
                world.func_175698_g(pos);
            } else if (neighborBlock != this) {
                this.onNeighborChanged((IBlockAccess)world, blockBelow, neighbor);
            }
        } else {
            boolean drop = false;
            BlockPos blockAbove = pos.func_177984_a();
            IBlockState stateAbove = world.func_180495_p(blockAbove);
            if (stateAbove.func_177230_c() != this) {
                world.func_175698_g(pos);
                drop = true;
            }
            if (!world.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
                world.func_175698_g(pos);
                drop = true;
                if (stateAbove.func_177230_c() == this) {
                    world.func_175698_g(blockAbove);
                }
            }
            if (drop) {
                if (!world.field_72995_K) {
                    this.func_176226_b(world, pos, state, 0);
                }
            } else {
                boolean hasActiveSCBlock;
                boolean bl = hasActiveSCBlock = BlockUtils.hasActiveSCBlockNextTo(world, pos) || BlockUtils.hasActiveSCBlockNextTo(world, pos.func_177984_a());
                if (neighborBlock != this && hasActiveSCBlock != (Boolean)stateAbove.func_177229_b((IProperty)field_176522_N)) {
                    world.func_180501_a(blockAbove, stateAbove.func_177226_a((IProperty)field_176522_N, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                    if (hasActiveSCBlock != (Boolean)state.func_177229_b((IProperty)field_176519_b)) {
                        world.func_180501_a(pos, state.func_177226_a((IProperty)field_176519_b, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                        world.func_175704_b(pos, pos);
                        if (state.func_177229_b((IProperty)field_176520_a) == EnumFacing.WEST) {
                            IBlockState secondDoorState = world.func_180495_p(pos.func_177978_c());
                            if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.reinforcedDoor && (Boolean)secondDoorState.func_177229_b((IProperty)field_176519_b) != hasActiveSCBlock) {
                                world.func_180501_a(pos.func_177978_c(), secondDoorState.func_177226_a((IProperty)field_176519_b, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                                world.func_175704_b(pos.func_177978_c(), pos.func_177978_c());
                            } else {
                                secondDoorState = world.func_180495_p(pos.func_177968_d());
                                if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.reinforcedDoor && (Boolean)secondDoorState.func_177229_b((IProperty)field_176519_b) != hasActiveSCBlock) {
                                    world.func_180501_a(pos.func_177968_d(), secondDoorState.func_177226_a((IProperty)field_176519_b, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                                    world.func_175704_b(pos.func_177968_d(), pos.func_177968_d());
                                }
                            }
                        } else if (state.func_177229_b((IProperty)field_176520_a) == EnumFacing.NORTH) {
                            IBlockState secondDoorState = world.func_180495_p(pos.func_177974_f());
                            if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.reinforcedDoor && (Boolean)secondDoorState.func_177229_b((IProperty)field_176519_b) != hasActiveSCBlock) {
                                world.func_180501_a(pos.func_177974_f(), secondDoorState.func_177226_a((IProperty)field_176519_b, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                                world.func_175704_b(pos.func_177974_f(), pos.func_177974_f());
                            } else {
                                secondDoorState = world.func_180495_p(pos.func_177976_e());
                                if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.reinforcedDoor && (Boolean)secondDoorState.func_177229_b((IProperty)field_176519_b) != hasActiveSCBlock) {
                                    world.func_180501_a(pos.func_177976_e(), secondDoorState.func_177226_a((IProperty)field_176519_b, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                                    world.func_175704_b(pos.func_177976_e(), pos.func_177976_e());
                                }
                            }
                        } else if (state.func_177229_b((IProperty)field_176520_a) == EnumFacing.EAST) {
                            IBlockState secondDoorState = world.func_180495_p(pos.func_177968_d());
                            if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.reinforcedDoor && (Boolean)secondDoorState.func_177229_b((IProperty)field_176519_b) != hasActiveSCBlock) {
                                world.func_180501_a(pos.func_177968_d(), secondDoorState.func_177226_a((IProperty)field_176519_b, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                                world.func_175704_b(pos.func_177968_d(), pos.func_177968_d());
                            } else {
                                secondDoorState = world.func_180495_p(pos.func_177978_c());
                                if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.reinforcedDoor && (Boolean)secondDoorState.func_177229_b((IProperty)field_176519_b) != hasActiveSCBlock) {
                                    world.func_180501_a(pos.func_177978_c(), secondDoorState.func_177226_a((IProperty)field_176519_b, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                                    world.func_175704_b(pos.func_177978_c(), pos.func_177978_c());
                                }
                            }
                        } else if (state.func_177229_b((IProperty)field_176520_a) == EnumFacing.SOUTH) {
                            IBlockState secondDoorState = world.func_180495_p(pos.func_177976_e());
                            if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.reinforcedDoor && (Boolean)secondDoorState.func_177229_b((IProperty)field_176519_b) != hasActiveSCBlock) {
                                world.func_180501_a(pos.func_177976_e(), secondDoorState.func_177226_a((IProperty)field_176519_b, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                                world.func_175704_b(pos.func_177976_e(), pos.func_177976_e());
                            } else {
                                secondDoorState = world.func_180495_p(pos.func_177974_f());
                                if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.reinforcedDoor && (Boolean)secondDoorState.func_177229_b((IProperty)field_176519_b) != hasActiveSCBlock) {
                                    world.func_180501_a(pos.func_177974_f(), secondDoorState.func_177226_a((IProperty)field_176519_b, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                                    world.func_175704_b(pos.func_177974_f(), pos.func_177974_f());
                                }
                            }
                        }
                        world.func_180498_a((EntityPlayer)null, hasActiveSCBlock ? 1005 : 1011, pos, 0);
                    }
                }
            }
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity te;
        if (player.func_184812_l_() && (te = world.func_175625_s(pos)) instanceof IModuleInventory) {
            ((IModuleInventory)te).getInventory().clear();
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IModuleInventory) {
            ((IModuleInventory)te).dropAllModules();
        }
        world.func_175713_t(pos);
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        super.func_189539_a(state, world, pos, id, param);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(SCContent.reinforcedDoorItem);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER ? null : SCContent.reinforcedDoorItem;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityReinforcedDoor();
    }
}

