/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.gui;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.containers.ContainerCustomizeBlock;
import net.geforcemods.securitycraft.gui.components.ClickButton;
import net.geforcemods.securitycraft.gui.components.GuiPictureButton;
import net.geforcemods.securitycraft.gui.components.GuiSlider;
import net.geforcemods.securitycraft.gui.components.HoverChecker;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.network.server.ToggleModule;
import net.geforcemods.securitycraft.network.server.ToggleOption;
import net.geforcemods.securitycraft.util.IHasExtraAreas;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiCustomizeBlock
extends GuiContainer
implements IContainerListener,
IHasExtraAreas {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("securitycraft:textures/gui/container/customize0.png"), new ResourceLocation("securitycraft:textures/gui/container/customize1.png"), new ResourceLocation("securitycraft:textures/gui/container/customize2.png"), new ResourceLocation("securitycraft:textures/gui/container/customize3.png"), new ResourceLocation("securitycraft:textures/gui/container/customize4.png"), new ResourceLocation("securitycraft:textures/gui/container/customize5.png")};
    private static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");
    private final List<Rectangle> extraAreas = new ArrayList<Rectangle>();
    private IModuleInventory moduleInv;
    private GuiPictureButton[] descriptionButtons = new GuiPictureButton[5];
    private GuiButton[] optionButtons = new GuiButton[5];
    private HoverChecker[] hoverCheckers = new HoverChecker[10];
    private final Block block;
    private final String blockName;
    private final String title;
    private EnumMap<EnumModuleType, Boolean> indicators = new EnumMap(EnumModuleType.class);

    public GuiCustomizeBlock(InventoryPlayer inventory, IModuleInventory te) {
        super((Container)new ContainerCustomizeBlock(inventory, te));
        this.moduleInv = te;
        this.block = te.getTileEntity().func_145838_q();
        this.blockName = this.block.func_149739_a().substring(5);
        this.title = Utils.localize(this.block, new Object[0]).func_150254_d();
        this.field_147002_h.func_75132_a((IContainerListener)this);
        for (EnumModuleType type : EnumModuleType.values()) {
            if (this.moduleInv.hasModule(type)) {
                this.indicators.put(type, this.moduleInv.isModuleEnabled(type));
                continue;
            }
            this.indicators.put(type, true);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int numberOfColumns = 2;
        for (int i = 0; i < this.moduleInv.getMaxNumberOfModules(); ++i) {
            int column = i % 2;
            this.descriptionButtons[i] = new ModuleButton(i, this.field_147003_i + 127 + column * 22, this.field_147009_r + 16 + Math.floorDiv(i, 2) * 22, 20, 20, this.field_146296_j, this.moduleInv.acceptedModules()[i].getItem(), this::moduleButtonClicked);
            this.field_146292_n.add(this.descriptionButtons[i]);
            this.hoverCheckers[i] = new HoverChecker((GuiButton)this.descriptionButtons[i]);
            this.descriptionButtons[i].field_146124_l = this.moduleInv.hasModule(this.moduleInv.acceptedModules()[i]);
        }
        TileEntity te = this.moduleInv.getTileEntity();
        if (te instanceof ICustomizable && ((ICustomizable)te).customOptions() != null) {
            ICustomizable customizableTe = (ICustomizable)te;
            for (int i = 0; i < customizableTe.customOptions().length; ++i) {
                Option<?> option = customizableTe.customOptions()[i];
                if (option instanceof GuiSlider.ISlider && option.isSlider()) {
                    if (option instanceof Option.OptionDouble) {
                        this.optionButtons[i] = new GuiSlider((Utils.localize(option.getKey(this.block), new Object[0]).func_150254_d() + " ").replace("#", option.toString()), this.blockName, i, this.field_147003_i + 178, this.field_147009_r + 10 + i * 25, 120, 20, "", (Double)((Option.OptionDouble)option).getMin(), (Double)((Option.OptionDouble)option).getMax(), (Double)((Option.OptionDouble)option).get(), true, true, (GuiSlider.ISlider)((Object)option));
                    } else if (option instanceof Option.OptionInt) {
                        this.optionButtons[i] = new GuiSlider((Utils.localize(option.getKey(this.block), new Object[0]).func_150254_d() + " ").replace("#", option.toString()), this.blockName, i, this.field_147003_i + 178, this.field_147009_r + 10 + i * 25, 120, 20, "", (Integer)((Option.OptionInt)option).getMin(), (Integer)((Option.OptionInt)option).getMax(), (Integer)((Option.OptionInt)option).get(), true, true, (GuiSlider.ISlider)((Object)option));
                    }
                    this.optionButtons[i].packedFGColour = 0xE0E0E0;
                } else {
                    this.optionButtons[i] = new GuiButton(i, this.field_147003_i + 178, this.field_147009_r + 10 + i * 25, 120, 20, this.getOptionButtonTitle(option));
                    this.optionButtons[i].packedFGColour = option.toString().equals(option.getDefaultValue().toString()) ? 0xFFFFA0 : 0xE0E0E0;
                }
                this.field_146292_n.add(this.optionButtons[i]);
                this.hoverCheckers[i + this.moduleInv.getMaxNumberOfModules()] = new HoverChecker(this.optionButtons[i]);
            }
        }
        for (GuiButton button : this.optionButtons) {
            if (button == null) continue;
            this.extraAreas.add(new Rectangle(button.field_146128_h, button.field_146129_i, button.field_146120_f, button.field_146121_g));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int i;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        this.field_146297_k.func_110434_K().func_110577_a(BEACON_GUI);
        for (i = 36; i < ((ContainerCustomizeBlock)this.field_147002_h).maxSlots; ++i) {
            EnumModuleType type;
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i);
            if (slot.func_75211_c().func_190926_b() || !this.indicators.containsKey((Object)(type = ((ItemModule)slot.func_75211_c().func_77973_b()).getModuleType()))) continue;
            GuiCustomizeBlock.func_152125_a((int)(this.field_147003_i + slot.field_75223_e - 2), (int)(this.field_147009_r + slot.field_75221_f + 16), (float)(this.indicators.get((Object)type) != false ? 88.0f : 110.0f), (float)219.0f, (int)21, (int)22, (int)20, (int)20, (float)256.0f, (float)256.0f);
        }
        if (this.getSlotUnderMouse() != null && !this.getSlotUnderMouse().func_75211_c().func_190926_b()) {
            this.func_146285_a(this.getSlotUnderMouse().func_75211_c(), mouseX, mouseY);
        }
        for (i = 0; i < this.hoverCheckers.length; ++i) {
            if (this.hoverCheckers[i] == null || !this.hoverCheckers[i].checkHover(mouseX, mouseY)) continue;
            if (i < this.moduleInv.getMaxNumberOfModules()) {
                this.drawHoveringText(this.field_146297_k.field_71466_p.func_78271_c(this.getModuleDescription(i), 150), mouseX, mouseY, this.field_146297_k.field_71466_p);
                continue;
            }
            this.drawHoveringText(this.field_146297_k.field_71466_p.func_78271_c(this.getOptionDescription(i), 150), mouseX, mouseY, this.field_146297_k.field_71466_p);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.title, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.title) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(Utils.localize("container.inventory", new Object[0]).func_150254_d(), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURES[this.moduleInv.getMaxNumberOfModules()]);
        this.func_73729_b(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_71111_a(Container menu, int slotIndex, ItemStack stack) {
        if (slotIndex < 36) {
            return;
        }
        for (int i = 0; i < this.moduleInv.getMaxNumberOfModules(); ++i) {
            EnumModuleType type = this.moduleInv.acceptedModules()[i];
            if (this.descriptionButtons[i] == null) continue;
            this.descriptionButtons[i].field_146124_l = this.moduleInv.hasModule(type);
            if (!this.descriptionButtons[i].field_146124_l) {
                this.indicators.remove((Object)type);
                continue;
            }
            if (this.indicators.containsKey((Object)type)) continue;
            this.indicators.put(type, true);
        }
    }

    private void moduleButtonClicked(ClickButton button) {
        EnumModuleType moduleType = ((ModuleButton)button).getModule().getModuleType();
        if (this.moduleInv.isModuleEnabled(moduleType)) {
            this.indicators.put(moduleType, false);
            this.moduleInv.removeModule(moduleType, true);
        } else {
            this.indicators.put(moduleType, true);
            this.moduleInv.insertModule(this.moduleInv.getModule(moduleType), true);
        }
        SecurityCraft.network.sendToServer((IMessage)new ToggleModule(this.moduleInv.getTileEntity().func_174877_v(), moduleType));
    }

    protected void func_146284_a(GuiButton button) {
        if (!(button instanceof GuiPictureButton)) {
            Option<?> tempOption = ((ICustomizable)this.moduleInv.getTileEntity()).customOptions()[button.field_146127_k];
            tempOption.toggle();
            button.packedFGColour = tempOption.toString().equals(tempOption.getDefaultValue().toString()) ? 0xFFFFA0 : 0xE0E0E0;
            button.field_146126_j = this.getOptionButtonTitle(tempOption);
            SecurityCraft.network.sendToServer((IMessage)new ToggleOption(this.moduleInv.getTileEntity().func_174877_v().func_177958_n(), this.moduleInv.getTileEntity().func_174877_v().func_177956_o(), this.moduleInv.getTileEntity().func_174877_v().func_177952_p(), button.field_146127_k));
        } else {
            ((GuiPictureButton)button).onClick();
        }
    }

    private String getModuleDescription(int buttonID) {
        String moduleDescription = "module." + this.blockName + "." + this.descriptionButtons[buttonID].getItemStack().func_77658_a().substring(5).replace("securitycraft:", "") + ".description";
        return Utils.localize(this.descriptionButtons[buttonID].getItemStack().func_77658_a() + ".name", new Object[0]).func_150254_d() + ":" + TextFormatting.RESET + "\n\n" + Utils.localize(moduleDescription, new Object[0]).func_150254_d();
    }

    private String getOptionDescription(int buttonID) {
        Option<?> option = ((ICustomizable)this.moduleInv.getTileEntity()).customOptions()[buttonID - this.moduleInv.getSlots()];
        return Utils.localize("gui.securitycraft:customize.tooltip", new TextComponentTranslation(option.getDescriptionKey(this.block), new Object[0]), new TextComponentTranslation("gui.securitycraft:customize.currentSetting", new Object[]{this.getValueText(option)})).func_150254_d();
    }

    private String getOptionButtonTitle(Option<?> option) {
        return (Utils.localize(option.getKey(this.block), new Object[0]).func_150254_d() + " ").replace("#", this.getValueText(option));
    }

    private String getValueText(Option<?> option) {
        if (option instanceof Option.OptionBoolean) {
            return new TextComponentTranslation((Boolean)((Option.OptionBoolean)option).get() != false ? "gui.securitycraft:invScan.yes" : "gui.securitycraft:invScan.no", new Object[0]).func_150254_d();
        }
        return option.toString();
    }

    @Override
    public List<Rectangle> getGuiExtraAreas() {
        return this.extraAreas;
    }

    public void func_71110_a(Container container, NonNullList<ItemStack> stacks) {
    }

    public void func_71112_a(Container container, int varToUpdate, int newValue) {
    }

    public void func_175173_a(Container container, IInventory inventory) {
    }

    private class ModuleButton
    extends GuiPictureButton {
        private final ItemModule module;

        public ModuleButton(int id, int xPos, int yPos, int width, int height, RenderItem renderItem, ItemModule itemToRender, Consumer<ClickButton> onClick) {
            super(id, xPos, yPos, width, height, renderItem, new ItemStack((Item)itemToRender), onClick);
            this.module = itemToRender;
        }

        public ItemModule getModule() {
            return this.module;
        }
    }
}

