/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.gui;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.containers.ContainerGeneric;
import net.geforcemods.securitycraft.gui.components.CallbackCheckbox;
import net.geforcemods.securitycraft.gui.components.ColorableScrollPanel;
import net.geforcemods.securitycraft.gui.components.ToggleComponentButton;
import net.geforcemods.securitycraft.network.server.SetListModuleData;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiEditModule
extends GuiContainer
implements GuiPageButtonList.GuiResponder {
    private static NBTTagCompound savedModule;
    private static final ResourceLocation TEXTURE;
    private static final ResourceLocation BEACON_GUI;
    private final String editModule = Utils.localize("gui.securitycraft:editModule", new Object[0]).func_150254_d();
    private final ItemStack module;
    private final List<ScorePlayerTeam> availableTeams;
    private final Map<ScorePlayerTeam, Boolean> teamsListedStatus = new HashMap<ScorePlayerTeam, Boolean>();
    private GuiTextField inputField;
    private GuiButton addPlayerButton;
    private GuiButton editTeamsButton;
    private GuiButton removePlayerButton;
    private GuiButton copyButton;
    private GuiButton pasteButton;
    private GuiButton clearButton;
    private CallbackCheckbox affectEveryPlayerCheckbox;
    private PlayerList playerList;
    private TeamList teamList;

    public GuiEditModule(InventoryPlayer inventory, ItemStack item, TileEntity te) {
        super((Container)new ContainerGeneric(inventory, te));
        this.availableTeams = new ArrayList<ScorePlayerTeam>(Minecraft.func_71410_x().field_71439_g.func_96123_co().func_96525_g());
        this.module = item;
        this.field_146999_f = 247;
        this.field_147000_g = 211;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int controlsStartX = (int)((float)this.field_147003_i + (float)this.field_146999_f * 0.75f) - 57;
        int controlsWidth = 107;
        String checkboxText = Utils.localize("gui.securitycraft:editModule.affectEveryone", new Object[0]).func_150254_d();
        int length = this.field_146289_q.func_78256_a(checkboxText) + 24;
        Keyboard.enableRepeatEvents((boolean)true);
        this.inputField = new GuiTextField(5, this.field_146289_q, controlsStartX, this.field_146295_m / 2 - 88, controlsWidth, 15);
        this.addPlayerButton = new GuiButton(0, controlsStartX, this.field_146295_m / 2 - 68, controlsWidth, 20, Utils.localize("gui.securitycraft:editModule.add_player", new Object[0]).func_150254_d());
        this.field_146292_n.add(this.addPlayerButton);
        this.removePlayerButton = new GuiButton(1, controlsStartX, this.field_146295_m / 2 - 43, controlsWidth, 20, Utils.localize("gui.securitycraft:editModule.remove_player", new Object[0]).func_150254_d());
        this.field_146292_n.add(this.removePlayerButton);
        this.editTeamsButton = new ToggleComponentButton(2, controlsStartX, this.field_146295_m / 2 - 18, controlsWidth, 20, i -> Utils.localize("gui.securitycraft:editModule.edit_teams", new Object[0]).func_150254_d(), 0, 2, b -> {});
        this.field_146292_n.add(this.editTeamsButton);
        this.copyButton = new GuiButton(3, controlsStartX, this.field_146295_m / 2 + 7, controlsWidth, 20, Utils.localize("gui.securitycraft:editModule.copy", new Object[0]).func_150254_d());
        this.field_146292_n.add(this.copyButton);
        this.pasteButton = new GuiButton(4, controlsStartX, this.field_146295_m / 2 + 32, controlsWidth, 20, Utils.localize("gui.securitycraft:editModule.paste", new Object[0]).func_150254_d());
        this.field_146292_n.add(this.pasteButton);
        this.clearButton = new GuiButton(5, controlsStartX, this.field_146295_m / 2 + 57, controlsWidth, 20, Utils.localize("gui.securitycraft:editModule.clear", new Object[0]).func_150254_d());
        this.field_146292_n.add(this.clearButton);
        this.affectEveryPlayerCheckbox = new CallbackCheckbox(6, this.field_147003_i + this.field_146999_f / 2 - length / 2, this.field_147009_r + this.field_147000_g - 25, 20, 20, checkboxText, this.module.func_77942_o() && this.module.func_77978_p().func_74767_n("affectEveryone"), newState -> {
            if (!this.module.func_77942_o()) {
                this.module.func_77982_d(new NBTTagCompound());
            }
            this.module.func_77978_p().func_74757_a("affectEveryone", newState.booleanValue());
        }, 0x404040);
        this.field_146292_n.add(this.affectEveryPlayerCheckbox);
        this.playerList = new PlayerList(this.field_146297_k, 110, 165, this.field_146295_m / 2 - 88, this.field_147003_i + 10, this.field_146294_l, this.field_146295_m);
        this.teamList = new TeamList(this.field_146297_k, this.editTeamsButton.func_146117_b(), 75, this.editTeamsButton.field_146129_i + this.editTeamsButton.field_146121_g, this.editTeamsButton.field_146128_h);
        this.teamList.active = false;
        this.editTeamsButton.field_146124_l = !this.availableTeams.isEmpty();
        this.refreshFromNbt();
        this.updateButtonStates();
        this.inputField.func_175207_a((GuiPageButtonList.GuiResponder)this);
        this.inputField.func_146203_f(16);
        this.inputField.func_146195_b(true);
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (!this.module.func_77942_o()) {
            this.module.func_77982_d(new NBTTagCompound());
        }
        SecurityCraft.network.sendToServer((IMessage)new SetListModuleData(this.module.func_77978_p()));
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179140_f();
        this.inputField.func_146194_f();
        if (this.playerList != null) {
            this.playerList.drawScreen(mouseX, mouseY, partialTicks);
        }
        if (this.teamList != null) {
            this.teamList.drawScreen(mouseX, mouseY, partialTicks);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78279_b(this.editModule, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.editModule) / 2, 6, this.field_146999_f, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode != 1 && this.inputField.func_146206_l()) {
            if (keyCode == 57) {
                return;
            }
            this.inputField.func_146201_a(typedChar, keyCode);
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.inputField.func_146192_a(mouseX, mouseY, mouseButton);
        if (this.teamList != null && this.teamList.mouseClicked(mouseX, mouseY, mouseButton)) {
            return;
        }
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                if (this.inputField.func_146179_b().isEmpty()) {
                    return;
                }
                if (this.module.func_77978_p() == null) {
                    this.module.func_77982_d(new NBTTagCompound());
                }
                for (int i = 1; i <= 50; ++i) {
                    if (!this.module.func_77978_p().func_74764_b("Player" + i) || !this.module.func_77978_p().func_74779_i("Player" + i).equals(this.inputField.func_146179_b())) continue;
                    if (i == 9) {
                        this.addPlayerButton.field_146124_l = false;
                    }
                    return;
                }
                this.module.func_77978_p().func_74778_a("Player" + this.getNextSlot(this.module.func_77978_p()), this.inputField.func_146179_b());
                if (this.module.func_77978_p() != null && this.module.func_77978_p().func_74764_b("Player50")) {
                    this.addPlayerButton.field_146124_l = false;
                }
                this.inputField.func_146180_a("");
                this.updateButtonStates();
                break;
            }
            case 1: {
                if (this.inputField.func_146179_b().isEmpty()) {
                    return;
                }
                if (this.module.func_77978_p() == null) {
                    this.module.func_77982_d(new NBTTagCompound());
                }
                for (int i = 1; i <= 50; ++i) {
                    if (!this.module.func_77978_p().func_74764_b("Player" + i) || !this.module.func_77978_p().func_74779_i("Player" + i).equals(this.inputField.func_146179_b())) continue;
                    this.module.func_77978_p().func_82580_o("Player" + i);
                }
                this.inputField.func_146180_a("");
                this.defragmentTag(this.module.func_77978_p());
                this.updateButtonStates();
                break;
            }
            case 2: {
                boolean buttonState;
                ToggleComponentButton tcb = (ToggleComponentButton)button;
                tcb.cycleIndex(1);
                this.pasteButton.field_146125_m = this.clearButton.field_146125_m = (buttonState = tcb.getCurrentIndex() == 0);
                this.copyButton.field_146125_m = this.clearButton.field_146125_m;
                this.teamList.active = !buttonState;
                break;
            }
            case 3: {
                savedModule = this.module.func_77978_p().func_74737_b();
                this.copyButton.field_146124_l = false;
                this.updateButtonStates();
                return;
            }
            case 4: {
                this.module.func_77982_d(savedModule.func_74737_b());
                this.updateButtonStates();
                this.refreshFromNbt();
                break;
            }
            case 5: {
                this.module.func_77982_d(new NBTTagCompound());
                this.inputField.func_146180_a("");
                this.updateButtonStates(true);
                this.refreshFromNbt();
                break;
            }
            case 6: {
                ((CallbackCheckbox)button).onClick();
                break;
            }
            default: {
                return;
            }
        }
    }

    private void updateButtonStates() {
        this.updateButtonStates(false);
    }

    private void updateButtonStates(boolean cleared) {
        NBTTagCompound tag;
        boolean tagIsConsideredEmpty;
        if (!this.module.func_77942_o()) {
            this.module.func_77982_d(new NBTTagCompound());
        }
        boolean bl = tagIsConsideredEmpty = (tag = this.module.func_77978_p()).func_82582_d() || tag.func_186856_d() == 1 && tag.func_74764_b("affectEveryone");
        if (!cleared && tagIsConsideredEmpty) {
            this.addPlayerButton.field_146124_l = false;
            this.removePlayerButton.field_146124_l = false;
        } else {
            this.addPlayerButton.field_146124_l = !tag.func_74764_b("Player50") && !this.inputField.func_146179_b().isEmpty();
            this.removePlayerButton.field_146124_l = !this.inputField.func_146179_b().isEmpty();
        }
        this.copyButton.field_146124_l = !tagIsConsideredEmpty && !tag.equals((Object)savedModule);
        this.pasteButton.field_146124_l = savedModule != null && !savedModule.func_82582_d() && !tag.equals((Object)savedModule);
        this.clearButton.field_146124_l = !tagIsConsideredEmpty;
    }

    private void refreshFromNbt() {
        if (!this.module.func_77942_o()) {
            this.availableTeams.forEach(team -> this.teamsListedStatus.put((ScorePlayerTeam)team, false));
            this.affectEveryPlayerCheckbox.setSelected(false);
        } else {
            NBTTagCompound tag = this.module.func_77978_p();
            List teamNames = StreamSupport.stream(tag.func_150295_c("ListedTeams", 8).spliterator(), false).filter(e -> e instanceof NBTTagString).map(e -> ((NBTTagString)e).func_150285_a_()).collect(Collectors.toList());
            this.availableTeams.forEach(team -> this.teamsListedStatus.put((ScorePlayerTeam)team, teamNames.contains(team.func_96661_b())));
            this.affectEveryPlayerCheckbox.setSelected(tag.func_74767_n("affectEveryone"));
        }
    }

    private int getNextSlot(NBTTagCompound tag) {
        for (int i = 1; i <= 50; ++i) {
            if (tag.func_74764_b("Player" + i) && !tag.func_74779_i("Player" + i).isEmpty()) continue;
            return i;
        }
        return 0;
    }

    private void toggleTeam(ScorePlayerTeam teamToAdd) {
        NBTTagList listedTeams = new NBTTagList();
        if (!this.module.func_77942_o()) {
            this.module.func_77982_d(new NBTTagCompound());
        }
        this.teamsListedStatus.put(teamToAdd, this.teamsListedStatus.get(teamToAdd) == false);
        this.teamsListedStatus.forEach((team, listed) -> {
            if (listed.booleanValue()) {
                listedTeams.func_74742_a((NBTBase)new NBTTagString(team.func_96661_b()));
            }
        });
        this.module.func_77978_p().func_74782_a("ListedTeams", (NBTBase)listedTeams);
        this.updateButtonStates();
    }

    private void defragmentTag(NBTTagCompound tag) {
        ArrayDeque<Integer> freeIndices = new ArrayDeque<Integer>();
        for (int i = 1; i <= 50; ++i) {
            if (!tag.func_74764_b("Player" + i) || tag.func_74779_i("Player" + i).isEmpty()) {
                freeIndices.add(i);
                continue;
            }
            if (freeIndices.isEmpty()) continue;
            String player = tag.func_74779_i("Player" + i);
            int nextFreeIndex = (Integer)freeIndices.poll();
            tag.func_74778_a("Player" + nextFreeIndex, player);
            tag.func_82580_o("Player" + i);
            freeIndices.add(i);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.playerList.handleMouseInput(mouseX, mouseY);
        this.teamList.handleMouseInput(mouseX, mouseY);
        this.func_175319_a(this.inputField.func_175206_d(), this.inputField.func_146179_b());
    }

    public void func_175319_a(int id, String text) {
        if (text.isEmpty()) {
            this.addPlayerButton.field_146124_l = false;
        } else {
            if (this.module.func_77942_o()) {
                for (int i = 1; i <= 50; ++i) {
                    if (!text.equals(this.module.func_77978_p().func_74779_i("Player" + i))) continue;
                    this.addPlayerButton.field_146124_l = false;
                    this.removePlayerButton.field_146124_l = true;
                    this.playerList.setSelectedIndex(i - 1);
                    return;
                }
            }
            this.addPlayerButton.field_146124_l = true;
        }
        this.removePlayerButton.field_146124_l = false;
        this.playerList.setSelectedIndex(-1);
    }

    public void func_175321_a(int id, boolean value) {
    }

    public void func_175320_a(int id, float value) {
    }

    private void renderBox(Tessellator tessellator, int min, int max, int slotTop, int slotBuffer, int borderColor) {
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferBuilder.func_181662_b((double)min, (double)(slotTop + slotBuffer + 3), 0.0).func_187315_a(0.0, 1.0).func_181669_b(borderColor, borderColor, borderColor, 255).func_181675_d();
        bufferBuilder.func_181662_b((double)max, (double)(slotTop + slotBuffer + 3), 0.0).func_187315_a(1.0, 1.0).func_181669_b(borderColor, borderColor, borderColor, 255).func_181675_d();
        bufferBuilder.func_181662_b((double)max, (double)(slotTop - 2), 0.0).func_187315_a(1.0, 0.0).func_181669_b(borderColor, borderColor, borderColor, 255).func_181675_d();
        bufferBuilder.func_181662_b((double)min, (double)(slotTop - 2), 0.0).func_187315_a(0.0, 0.0).func_181669_b(borderColor, borderColor, borderColor, 255).func_181675_d();
        bufferBuilder.func_181662_b((double)(min + 1), (double)(slotTop + slotBuffer + 2), 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        bufferBuilder.func_181662_b((double)(max - 1), (double)(slotTop + slotBuffer + 2), 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        bufferBuilder.func_181662_b((double)(max - 1), (double)(slotTop - 1), 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        bufferBuilder.func_181662_b((double)(min + 1), (double)(slotTop - 1), 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
    }

    static {
        TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/edit_module.png");
        BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");
    }

    class TeamList
    extends ColorableScrollPanel {
        private final int listLength;
        private final FontRenderer font;
        private int selectedIndex;
        public boolean active;

        public TeamList(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
            this.selectedIndex = -1;
            this.active = true;
            this.listLength = GuiEditModule.this.availableTeams.size();
            this.font = GuiEditModule.this.field_146297_k.field_71466_p;
        }

        @Override
        public int getSize() {
            return this.listHeight;
        }

        @Override
        public int getContentHeight() {
            int height = this.getSize() * (this.font.field_78288_b + 3);
            if (height < this.bottom - this.top - 8) {
                height = this.bottom - this.top - 8;
            }
            return height;
        }

        public boolean mouseClicked(int mouseX, int mouseY, int button) {
            int mouseListY;
            int slotIndex;
            if (this.active && (slotIndex = (mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - 4.0f)) / this.slotHeight) >= 0 && slotIndex < this.listLength && mouseY >= 0 && mouseX < this.scrollBarLeft) {
                GuiEditModule.this.toggleTeam((ScorePlayerTeam)GuiEditModule.this.availableTeams.get(slotIndex));
                GuiEditModule.this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                return true;
            }
            return false;
        }

        @Override
        public void drawScreen(int mouseX, int mouseY, float partialTicks) {
            if (this.active) {
                super.drawScreen(mouseX, mouseY, partialTicks);
                int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - 2.0f);
                int slotIndex = mouseListY / this.slotHeight;
                if (mouseX >= this.left && mouseX < this.right - 6 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.listLength && mouseY >= this.top && mouseY <= this.bottom) {
                    String name = ((ScorePlayerTeam)GuiEditModule.this.availableTeams.get(slotIndex)).func_96669_c();
                    int length = this.font.func_78256_a(name);
                    int baseY = this.top + 4 - (int)this.scrollDistance;
                    if (length >= GuiEditModule.this.field_146294_l - 6) {
                        GuiEditModule.this.func_146279_a(name, this.left + 3, baseY + (this.slotHeight * slotIndex + this.slotHeight));
                    }
                }
            }
        }

        @Override
        public void drawPanel(int entryRight, int relativeY, Tessellator tessellator, int mouseX, int mouseY) {
            int baseY = this.top + 4 - (int)this.scrollDistance;
            int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - 2.0f);
            int slotIndex = mouseListY / this.slotHeight;
            if (slotIndex != this.selectedIndex && mouseX >= this.left && mouseX < this.right - 6 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.listLength && mouseY >= this.top && mouseY <= this.bottom) {
                GuiEditModule.this.renderBox(tessellator, this.left, entryRight - 6, baseY + slotIndex * this.slotHeight, this.slotHeight - 4, 128);
            }
            for (int i = 0; i < this.listLength; ++i) {
                int yStart = relativeY + this.slotHeight * i;
                ScorePlayerTeam team = (ScorePlayerTeam)GuiEditModule.this.availableTeams.get(i);
                this.font.func_78276_b(team.func_96669_c(), this.left + 15, yStart, 0xC6C6C6);
                GuiEditModule.this.field_146297_k.func_110434_K().func_110577_a(BEACON_GUI);
                Gui.func_152125_a((int)this.left, (int)(yStart - 3), (float)((Boolean)GuiEditModule.this.teamsListedStatus.get(team) != false ? 88.0f : 110.0f), (float)219.0f, (int)21, (int)22, (int)14, (int)14, (float)256.0f, (float)256.0f);
            }
        }
    }

    class PlayerList
    extends GuiScrollingList {
        public PlayerList(Minecraft client, int width, int height, int top, int left, int screenWidth, int screenHeight) {
            super(client, width, height, top, top + height, left, 12, screenWidth, screenHeight);
        }

        protected int getSize() {
            return 50;
        }

        protected void elementClicked(int index, boolean doubleClick) {
            if (GuiEditModule.this.module.func_77942_o() && GuiEditModule.this.module.func_77978_p().func_74764_b("Player" + (index + 1))) {
                GuiEditModule.this.inputField.func_146180_a(GuiEditModule.this.module.func_77978_p().func_74779_i("Player" + (index + 1)));
            }
        }

        protected boolean isSelected(int index) {
            return index == this.selectedIndex && GuiEditModule.this.module.func_77942_o() && GuiEditModule.this.module.func_77978_p().func_74764_b("Player" + (index + 1)) && !GuiEditModule.this.module.func_77978_p().func_74779_i("Player" + (index + 1)).isEmpty();
        }

        protected void drawBackground() {
        }

        protected void drawSlot(int slotIndex, int entryRight, int slotTop, int slotBuffer, Tessellator tessellator) {
            if (GuiEditModule.this.module.func_77942_o()) {
                String name;
                NBTTagCompound tag = GuiEditModule.this.module.func_77978_p();
                --slotBuffer;
                if (this.isSelected(slotIndex)) {
                    GuiEditModule.this.renderBox(tessellator, this.left, entryRight + 1, slotTop, slotBuffer, 255);
                } else if (this.mouseX >= this.left && this.mouseX <= entryRight && slotIndex >= 0 && slotIndex < this.getSize() && this.mouseY >= slotTop - 1 && this.mouseY <= slotTop + slotBuffer + 2 && tag.func_74764_b("Player" + (slotIndex + 1)) && !tag.func_74779_i("Player" + (slotIndex + 1)).isEmpty()) {
                    GuiEditModule.this.renderBox(tessellator, this.left, entryRight + 1, slotTop, slotBuffer, 128);
                }
                if (tag.func_74764_b("Player" + (slotIndex + 1)) && !(name = tag.func_74779_i("Player" + (slotIndex + 1))).isEmpty()) {
                    GuiEditModule.this.field_146289_q.func_78276_b(name, GuiEditModule.this.field_146294_l / 2 - 110 + this.listWidth / 2 - GuiEditModule.this.field_146289_q.func_78256_a(name) / 2 - 4, slotTop, 0xC6C6C6);
                }
            }
        }

        public void setSelectedIndex(int selectedIndex) {
            this.selectedIndex = selectedIndex;
        }
    }
}

