/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.TileEntityLinkable;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemModule
extends Item {
    public static final int MAX_PLAYERS = 50;
    private final EnumModuleType module;
    private final boolean containsCustomData;
    private boolean canBeCustomized;
    private int guiToOpen;

    public ItemModule(EnumModuleType module, boolean containsCustomData) {
        this(module, containsCustomData, false, -1);
    }

    public ItemModule(EnumModuleType module, boolean containsCustomData, boolean canBeCustomized, int guiToOpen) {
        this.module = module;
        this.containsCustomData = containsCustomData;
        this.canBeCustomized = canBeCustomized;
        this.guiToOpen = guiToOpen;
        this.func_77625_d(1);
        this.func_77637_a(SecurityCraft.tabSCTechnical);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IModuleInventory) {
            IModuleInventory inv = (IModuleInventory)te;
            ItemStack stack = player.func_184586_b(hand);
            EnumModuleType type = ((ItemModule)stack.func_77973_b()).getModuleType();
            if (te instanceof IOwnable && !((IOwnable)te).getOwner().isOwner(player)) {
                return EnumActionResult.PASS;
            }
            if (inv.acceptsModule(type) && !inv.hasModule(type)) {
                if (!world.field_72995_K) {
                    inv.insertModule(stack, false);
                    if (inv instanceof TileEntityLinkable) {
                        TileEntityLinkable linkable = (TileEntityLinkable)inv;
                        linkable.createLinkedBlockAction((ILinkedAction)new ILinkedAction.ModuleInserted(stack, (ItemModule)stack.func_77973_b(), false), linkable);
                    }
                    if (!player.func_184812_l_()) {
                        stack.func_190918_g(1);
                    }
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (this.canBeCustomized()) {
                player.openGui((Object)SecurityCraft.instance, this.guiToOpen, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flag) {
        Block addon;
        if (this.containsCustomData || this.canBeCustomized()) {
            list.add(Utils.localize("tooltip.securitycraft:module.modifiable", new Object[0]).func_150254_d());
        } else {
            list.add(Utils.localize("tooltip.securitycraft:module.notModifiable", new Object[0]).func_150254_d());
        }
        if (this.canBeCustomized() && (addon = this.getBlockAddon(stack.func_77978_p())) != null) {
            list.add(Utils.localize("tooltip.securitycraft:module.itemAddons.added", TextFormatting.GRAY + Utils.localize(addon, new Object[0]).func_150254_d()).func_150254_d());
        }
        if (this.containsCustomData) {
            NBTTagCompound tag;
            boolean affectsEveryone = false;
            int playerCount = 0;
            int teamCount = 0;
            if (stack.func_77942_o() && !(affectsEveryone = (tag = stack.func_77978_p()).func_74767_n("affectEveryone"))) {
                playerCount = ModuleUtils.getPlayersFromModule(stack).size();
                teamCount = tag.func_150295_c("ListedTeams", 8).func_74745_c();
            }
            if (affectsEveryone) {
                list.add(Utils.localize("tooltip.securitycraft:module.affects_everyone", new Object[0]).func_150254_d());
            } else {
                list.add(Utils.localize("tooltip.securitycraft:module.added_players", "" + TextFormatting.GRAY + playerCount).func_150254_d());
                list.add(Utils.localize("tooltip.securitycraft:module.added_teams", "" + TextFormatting.GRAY + teamCount).func_150254_d());
            }
        }
    }

    public EnumModuleType getModuleType() {
        return this.module;
    }

    public Block getBlockAddon(NBTTagCompound tag) {
        ItemStack stack = this.getAddonAsStack(tag);
        if (stack.func_77973_b() instanceof ItemBlock) {
            return ((ItemBlock)stack.func_77973_b()).func_179223_d();
        }
        return null;
    }

    public ItemStack getAddonAsStack(NBTTagCompound tag) {
        if (tag == null) {
            return ItemStack.field_190927_a;
        }
        NBTTagList items = tag.func_150295_c("ItemInventory", 10);
        if (items != null && !items.func_82582_d()) {
            return new ItemStack(items.func_150305_b(0));
        }
        return ItemStack.field_190927_a;
    }

    public boolean canBeCustomized() {
        return this.canBeCustomized;
    }
}

