/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blocks.BlockRetinalScanner;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.tileentity.TileEntityRetinalScanner;
import net.geforcemods.securitycraft.util.TileEntityRenderDelegate;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class TileEntityRetinalScannerRenderer
extends TileEntitySpecialRenderer<TileEntityRetinalScanner> {
    private static final float CORRECT_FACTOR = 0.0018181818f;

    public void render(TileEntityRetinalScanner te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (TileEntityRenderDelegate.DISGUISED_BLOCK.tryRenderDelegate(te, x, y, z, partialTicks, destroyStage, alpha)) {
            return;
        }
        IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
        if (state.func_177230_c() == SCContent.retinalScanner) {
            EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)BlockRetinalScanner.FACING);
            if (!te.isModuleEnabled(EnumModuleType.DISGUISE)) {
                this.render((float)x, (float)y, (float)z, direction, te.getPlayerProfile(), destroyStage);
            }
        }
    }

    public void render(float x, float y, float z, @Nullable EnumFacing facing, @Nullable GameProfile playerProfile, int destroyStage) {
        if (facing != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getSkinTexture(playerProfile));
            GlStateManager.func_179094_E();
            switch (facing) {
                case NORTH: {
                    GlStateManager.func_179109_b((float)(x + 0.25f), (float)(y + 0.0625f), (float)z);
                    break;
                }
                case SOUTH: {
                    GlStateManager.func_179109_b((float)(x + 0.75f), (float)(y + 0.0625f), (float)(z + 1.0f));
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case WEST: {
                    GlStateManager.func_179109_b((float)x, (float)(y + 0.0625f), (float)(z + 0.75f));
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case EAST: {
                    GlStateManager.func_179109_b((float)(x + 1.0f), (float)(y + 0.0625f), (float)(z + 0.25f));
                    GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
            }
            GlStateManager.func_179091_B();
            GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
            GlStateManager.func_179141_d();
            RenderHelper.func_74518_a();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)1, (int)0);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_181662_b(0.001818181830458343, 0.0027272727456875145, 0.0).func_187315_a(0.125, 0.25).func_181675_d();
            bufferbuilder.func_181662_b(0.001818181830458343, -0.5009090909152292, 0.0).func_187315_a(0.125, 0.125).func_181675_d();
            bufferbuilder.func_181662_b(-0.5018181818304583, -0.5009090909152292, 0.0).func_187315_a(0.25, 0.125).func_181675_d();
            bufferbuilder.func_181662_b(-0.5018181818304583, 0.0027272727456875145, 0.0).func_187315_a(0.25, 0.25).func_181675_d();
            tessellator.func_78381_a();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_181662_b(0.001818181830458343, 0.0027272727456875145, 0.0).func_187315_a(0.625, 0.25).func_181675_d();
            bufferbuilder.func_181662_b(0.001818181830458343, -0.5009090909152292, 0.0).func_187315_a(0.625, 0.125).func_181675_d();
            bufferbuilder.func_181662_b(-0.5018181818304583, -0.5009090909152292, 0.0).func_187315_a(0.75, 0.125).func_181675_d();
            bufferbuilder.func_181662_b(-0.5018181818304583, 0.0027272727456875145, 0.0).func_187315_a(0.75, 0.25).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    private ResourceLocation getSkinTexture(@Nullable GameProfile profile) {
        ResourceLocation resourcelocation = DefaultPlayerSkin.func_177335_a();
        if (ConfigHandler.retinalScannerFace && profile != null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            Map map = minecraft.func_152342_ad().func_152788_a(profile);
            resourcelocation = map.containsKey(MinecraftProfileTexture.Type.SKIN) ? minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN) : DefaultPlayerSkin.func_177334_a((UUID)EntityPlayer.func_146094_a((GameProfile)profile));
        }
        return resourcelocation;
    }
}

