/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.entity.EntityBullet;
import net.geforcemods.securitycraft.entity.EntityIMSBomb;
import net.geforcemods.securitycraft.entity.EntitySentry;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.network.client.SetTrophySystemTarget;
import net.geforcemods.securitycraft.network.server.SyncTrophySystem;
import net.geforcemods.securitycraft.tileentity.TileEntityDisguisable;
import net.geforcemods.securitycraft.util.IToggleableEntries;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityExpBottle;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TileEntityTrophySystem
extends TileEntityDisguisable
implements ITickable,
ILockable,
IToggleableEntries<EntityEntry> {
    public static final int RANGE = 10;
    public static final int RENDER_DISTANCE = 50;
    public static final EntityEntry MODDED_PROJECTILES = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("minecraft:pig"));
    private final Map<EntityEntry, Boolean> projectileFilter = new LinkedHashMap<EntityEntry, Boolean>();
    public Entity entityBeingTargeted = null;
    public int cooldown = this.getCooldownTime();
    private final Random random = new Random();
    private Option.DisabledOption disabled = new Option.DisabledOption(false);

    public TileEntityTrophySystem() {
        this.projectileFilter.put((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("securitycraft", "bullet")), true);
        this.projectileFilter.put((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("minecraft:spectral_arrow")), true);
        this.projectileFilter.put((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("minecraft:arrow")), true);
        this.projectileFilter.put((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("minecraft:small_fireball")), true);
        this.projectileFilter.put((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("securitycraft", "imsbomb")), true);
        this.projectileFilter.put((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("minecraft:fireball")), true);
        this.projectileFilter.put((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("minecraft:dragon_fireball")), true);
        this.projectileFilter.put((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("minecraft:wither_skull")), true);
        this.projectileFilter.put((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("minecraft:shulker_bullet")), true);
        this.projectileFilter.put((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("minecraft:llama_spit")), true);
        this.projectileFilter.put((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("minecraft:egg")), true);
        this.projectileFilter.put((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("minecraft:ender_pearl")), true);
        this.projectileFilter.put((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("minecraft:snowball")), true);
        this.projectileFilter.put((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("minecraft:fireworks_rocket")), true);
        this.projectileFilter.put(MODDED_PROJECTILES, false);
    }

    public void func_73660_a() {
        Entity target;
        if (this.isDisabled()) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.entityBeingTargeted == null && (target = this.getPotentialTarget()) != null) {
            EntityLivingBase shooter = this.getShooter(target);
            if (shooter == null) {
                this.setTarget(target);
            } else {
                String name;
                UUID uuid = shooter instanceof EntitySentry ? UUID.fromString(((EntitySentry)shooter).getOwner().getUUID()) : shooter.func_110124_au();
                String string = name = shooter instanceof EntitySentry ? ((EntitySentry)shooter).getOwner().getName() : shooter.func_70005_c_();
                if (!(ConfigHandler.enableTeamOwnership && PlayerUtils.areOnSameTeam(shooter.func_70005_c_(), this.getOwner().getName()) || uuid != null && uuid.toString().equals(this.getOwner().getUUID()) || ModuleUtils.isAllowed((IModuleInventory)this, name))) {
                    this.setTarget(target);
                }
            }
        }
        if (this.entityBeingTargeted == null) {
            return;
        }
        if (!this.entityBeingTargeted.func_70089_S()) {
            this.resetTarget();
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        this.destroyTarget();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v()).func_186662_g(50.0);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagCompound projectilesNBT = new NBTTagCompound();
        int i = 0;
        for (boolean b : this.projectileFilter.values()) {
            projectilesNBT.func_74757_a("projectile" + i, b);
            ++i;
        }
        tag.func_74782_a("projectiles", (NBTBase)projectilesNBT);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_150297_b("projectiles", 10)) {
            NBTTagCompound projectilesNBT = tag.func_74775_l("projectiles");
            int i = 0;
            for (EntityEntry projectileType : this.projectileFilter.keySet()) {
                this.projectileFilter.put(projectileType, projectilesNBT.func_74767_n("projectile" + i));
                ++i;
            }
        }
    }

    public void setTarget(Entity target) {
        this.entityBeingTargeted = target;
        if (!this.field_145850_b.field_72995_K) {
            SecurityCraft.network.sendToAllTracking((IMessage)new SetTrophySystemTarget(this.field_174879_c, target.func_145782_y()), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 0.0));
        }
    }

    private void destroyTarget() {
        this.entityBeingTargeted.func_70106_y();
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72876_a(null, this.entityBeingTargeted.field_70165_t, this.entityBeingTargeted.field_70163_u, this.entityBeingTargeted.field_70161_v, 0.1f, false);
        }
        this.resetTarget();
    }

    private void resetTarget() {
        this.cooldown = this.getCooldownTime();
        this.entityBeingTargeted = null;
    }

    private Entity getPotentialTarget() {
        List<Object> potentialTargets = new ArrayList();
        AxisAlignedBB area = new AxisAlignedBB(this.field_174879_c).func_72314_b(10.0, 10.0, 10.0);
        potentialTargets.addAll(this.field_145850_b.func_175647_a(Entity.class, area, this::isAllowedToTarget));
        potentialTargets = potentialTargets.stream().filter(this::filterSCProjectiles).collect(Collectors.toList());
        if (potentialTargets.size() <= 0) {
            return null;
        }
        int target = this.random.nextInt(potentialTargets.size());
        return (Entity)potentialTargets.get(target);
    }

    private boolean isAllowedToTarget(Entity target) {
        if (target instanceof EntityFishHook || target instanceof EntityPotion || target instanceof EntityExpBottle || target instanceof EntityPig) {
            return false;
        }
        EntityEntry targetEntry = EntityRegistry.getEntry(target.getClass());
        if (this.projectileFilter.containsKey(targetEntry) || target instanceof IProjectile) {
            return this.projectileFilter.getOrDefault(targetEntry, this.projectileFilter.get(MODDED_PROJECTILES));
        }
        return false;
    }

    private boolean filterSCProjectiles(Entity projectile) {
        Owner owner = null;
        if (projectile instanceof EntityBullet) {
            owner = ((EntityBullet)projectile).getOwner();
        } else if (projectile instanceof EntityIMSBomb) {
            owner = ((EntityIMSBomb)projectile).getOwner();
        }
        return owner == null || !owner.owns(this) && !ModuleUtils.isAllowed((IModuleInventory)this, owner.getName());
    }

    public EntityLivingBase getShooter(Entity projectile) {
        EntityLivingBase shooter = null;
        if (projectile instanceof EntityArrow) {
            shooter = (EntityLivingBase)((EntityArrow)projectile).field_70250_c;
        } else if (projectile instanceof EntityFireball) {
            shooter = ((EntityFireball)projectile).field_70235_a;
        } else if (projectile instanceof EntityFireworkRocket) {
            shooter = ((EntityFireworkRocket)projectile).field_191513_e;
        } else if (projectile instanceof EntityThrowable) {
            shooter = ((EntityThrowable)projectile).func_85052_h();
        }
        return shooter;
    }

    @Override
    public void setFilter(EntityEntry projectileType, boolean allowed) {
        if (this.projectileFilter.containsKey(projectileType)) {
            this.projectileFilter.put(projectileType, allowed);
            if (this.field_145850_b.field_72995_K) {
                SecurityCraft.network.sendToServer((IMessage)new SyncTrophySystem(this.field_174879_c, projectileType, allowed));
            }
        }
    }

    @Override
    public boolean getFilter(EntityEntry projectileType) {
        return this.projectileFilter.get(projectileType);
    }

    @Override
    public Map<EntityEntry, Boolean> getFilters() {
        return this.projectileFilter;
    }

    @Override
    public String getTypeName(EntityEntry type) {
        return type.getName();
    }

    @Override
    public EntityEntry getDefaultType() {
        return MODDED_PROJECTILES;
    }

    @Override
    public String getDefaultTypeName() {
        return "gui.securitycraft:trophy_system.moddedProjectiles";
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    @Override
    public void onModuleRemoved(ItemStack stack, EnumModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == EnumModuleType.SMART) {
            for (EntityEntry projectileType : this.projectileFilter.keySet()) {
                this.projectileFilter.put(projectileType, projectileType != MODDED_PROJECTILES);
            }
        }
    }

    @Override
    public EnumModuleType[] acceptedModules() {
        return new EnumModuleType[]{EnumModuleType.SMART, EnumModuleType.SPEED, EnumModuleType.ALLOWLIST, EnumModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.disabled};
    }

    public int getCooldownTime() {
        return this.isModuleEnabled(EnumModuleType.SPEED) ? 4 : 8;
    }
}

