/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCardIC2
extends ItemCardBase {
    public ItemCardIC2() {
        super(4, "card_ic2");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        NBTTagCompound tag = CrossModLoader.getCrossMod("ic2").getCardData(world, target);
        if (tag == null) {
            return CardState.NO_TARGET;
        }
        reader.reset();
        reader.copyFrom(tag);
        return CardState.OK;
    }

    @Override
    public List<PanelString> getStringData(int settings, ICardReader reader, boolean isServer, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        if (reader.hasField("heat") && (settings & 1) > 0) {
            this.addHeat(result, "msg.ec.InfoPanelTemp", reader.getInt("heat"), reader.getInt("maxHeat"), showLabels);
        }
        if (reader.hasField("maxHeat") && (settings & 1) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelMaxHeat", reader.getInt("maxHeat").intValue(), showLabels));
        }
        if (reader.hasField("maxHeat") && (settings & 1) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelMelting", reader.getInt("maxHeat") * 85 / 100, showLabels));
        }
        if (reader.hasField("heatD") && (settings & 1) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelTemp", reader.getDouble("heatD"), "\u00b0C", showLabels));
        }
        if (reader.hasField("heatChange") && (settings & 1) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelHeatChange", reader.getInt("heatChange").intValue(), showLabels));
        }
        if (reader.hasField("energy") && (settings & 2) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelEnergy", reader.getLong("energy").longValue(), "EU", showLabels));
        }
        if (reader.hasField("energyHU") && (settings & 2) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelEnergy", reader.getLong("energyHU").longValue(), "HU", showLabels));
        }
        if (reader.hasField("energyKU") && (settings & 2) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelEnergy", reader.getLong("energyKU").longValue(), "KU", showLabels));
        }
        if (reader.hasField("capacity") && (settings & 2) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelCapacity", reader.getLong("capacity").longValue(), "EU", showLabels));
        }
        if (reader.hasField("capacityHU") && (settings & 2) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelCapacity", reader.getLong("capacityHU").longValue(), "HU", showLabels));
        }
        if (reader.hasField("capacityKU") && (settings & 2) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelCapacity", reader.getLong("capacityKU").longValue(), "KU", showLabels));
        }
        if (reader.hasField("diff") && (settings & 2) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelDifference", reader.getDouble("diff"), "EU/t", showLabels));
        }
        if (reader.hasField("consumption") && (settings & 4) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelConsumption", reader.getDouble("consumption"), "mB/t", showLabels));
        }
        if (reader.hasField("consumptionEU") && (settings & 4) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelConsumption", reader.getDouble("consumptionEU"), "EU/t", showLabels));
        }
        if (reader.hasField("output") && (settings & 4) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelOutput", reader.getDouble("output"), "EU/t", showLabels));
        }
        if (reader.hasField("outputHU") && (settings & 4) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelOutput", reader.getDouble("outputHU"), "HU/t", showLabels));
        }
        if (reader.hasField("outputKU") && (settings & 4) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelOutput", reader.getDouble("outputKU"), "KU/t", showLabels));
        }
        if (reader.hasField("outputmb") && (settings & 4) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelOutput", reader.getDouble("outputmb"), "mB/t", showLabels));
        }
        if (reader.hasField("multiplier") && (settings & 8) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelMultiplier", reader.getDouble("multiplier"), showLabels));
        }
        if (reader.hasField("tank") && (settings & 0x10) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelTank", reader.getString("tank"), showLabels));
        }
        if (reader.hasField("tank2") && (settings & 0x10) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelTank", reader.getString("tank2"), showLabels));
        }
        if (reader.hasField("fuel") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelFuel", reader.getInt("fuel").intValue(), showLabels));
        }
        if (reader.hasField("pellets") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelPellets", reader.getInt("pellets").intValue(), showLabels));
        }
        if (reader.hasField("motors") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelMotors", reader.getInt("motors").intValue(), showLabels));
        }
        if (reader.hasField("coils") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelCoils", reader.getInt("coils").intValue(), showLabels));
        }
        if (reader.hasField("conductors") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelConductors", reader.getInt("conductors").intValue(), showLabels));
        }
        if (reader.hasField("wind") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelWindStrength", reader.getDouble("wind"), showLabels));
        }
        if (reader.hasField("obstructedBlocks") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelObstructedBlocks", reader.getInt("obstructedBlocks").intValue(), showLabels));
        }
        if (reader.hasField("waterFlow") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelWaterFlow", reader.getDouble("waterFlow"), showLabels));
        }
        if (reader.hasField("height") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelHeight", reader.getInt("height").intValue(), showLabels));
        }
        if (reader.hasField("health") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelRotorHealth", reader.getDouble("health"), showLabels));
        }
        if (reader.hasField("progress") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelProgress", reader.getDouble("progress"), showLabels));
        }
        if (reader.hasField("pressure") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelPressure", reader.getInt("pressure").intValue(), "bar", showLabels));
        }
        if (reader.hasField("calcification") && (settings & 0x40) > 0) {
            result.add(new PanelString("ic2.SteamGenerator.gui.calcification", reader.getDouble("calcification"), "%", showLabels));
        }
        if (reader.hasField("timeLeft") && (settings & 0x40) > 0) {
            int timeLeft = reader.getInt("timeLeft");
            int hours = timeLeft / 3600;
            int minutes = timeLeft % 3600 / 60;
            int seconds = timeLeft % 60;
            result.add(new PanelString("msg.ec.InfoPanelTimeRemaining", String.format("%d:%02d:%02d", hours, minutes, seconds), showLabels));
        }
        if (reader.hasField("active") && (settings & 0x20) > 0) {
            this.addOnOff(result, isServer, reader.getBoolean("active"));
        }
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<PanelSetting> getSettingsList() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(7);
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelHeat", (Object[])new Object[0]), 1));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelEnergy", (Object[])new Object[0]), 2));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelOutput", (Object[])new Object[0]), 4));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelMultiplier", (Object[])new Object[0]), 8));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelTank", (Object[])new Object[0]), 16));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelOnOff", (Object[])new Object[0]), 32));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelOther", (Object[])new Object[0]), 64));
        return result;
    }
}

