/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.items;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import zmaster587.libVulpes.interfaces.ILinkableTile;

public class ItemLinker
extends Item {
    protected int linkX;
    protected int linkY;
    protected int linkZ;
    protected int dimId;
    private static final int EMPTYSETTING = 0;

    public ItemLinker() {
        this.field_77777_bU = 1;
        this.func_77637_a(CreativeTabs.field_78029_e);
        this.dimId = 0;
    }

    public void func_77624_a(@Nonnull ItemStack par1ItemStack, World par2EntityPlayer, List<String> par3List, ITooltipFlag par4) {
        int y = ItemLinker.getMasterY(par1ItemStack);
        if (y == 0) {
            par3List.add("Coords unset!");
        } else {
            par3List.add("X: " + ItemLinker.getMasterX(par1ItemStack));
            par3List.add("Y: " + ItemLinker.getMasterY(par1ItemStack));
            par3List.add("Z: " + ItemLinker.getMasterZ(par1ItemStack));
            int dimId = ItemLinker.getDimId(par1ItemStack);
            if (dimId != -1) {
                par3List.add("Dim: " + dimId);
            }
        }
    }

    public static boolean isSet(@Nonnull ItemStack stack) {
        return ItemLinker.getMasterY(stack) != 0;
    }

    @Deprecated
    public static int getMasterX(@Nonnull ItemStack itemStack) {
        NBTTagCompound nbt = itemStack.func_77978_p();
        nbt = nbt.func_74775_l("MasterPos");
        return nbt.func_74762_e("MasterX");
    }

    @Deprecated
    public static int getMasterY(@Nonnull ItemStack itemStack) {
        NBTTagCompound nbt = itemStack.func_77978_p();
        if (nbt == null) {
            return 0;
        }
        nbt = nbt.func_74775_l("MasterPos");
        return nbt.func_74762_e("MasterY");
    }

    @Deprecated
    public static int getMasterZ(@Nonnull ItemStack itemStack) {
        NBTTagCompound nbt = itemStack.func_77978_p();
        nbt = nbt.func_74775_l("MasterPos");
        return nbt.func_74762_e("MasterZ");
    }

    public static void setDimId(@Nonnull ItemStack itemStack, int id) {
        NBTTagCompound nbt;
        if (!itemStack.func_77942_o()) {
            nbt = new NBTTagCompound();
            itemStack.func_77982_d(nbt);
        } else {
            nbt = itemStack.func_77978_p();
        }
        nbt.func_74768_a("dimId", id);
    }

    public static int getDimId(@Nonnull ItemStack itemStack) {
        NBTTagCompound nbt = !itemStack.func_77942_o() ? new NBTTagCompound() : itemStack.func_77978_p();
        return nbt.func_74764_b("dimId") ? nbt.func_74762_e("dimId") : -1;
    }

    public static void setMasterX(@Nonnull ItemStack itemStack, int num) {
        NBTTagCompound nbt = itemStack.func_77978_p();
        nbt = nbt.func_74775_l("MasterPos");
        nbt.func_74768_a("MasterX", num);
    }

    public static void setMasterY(@Nonnull ItemStack itemStack, int num) {
        NBTTagCompound nbt = itemStack.func_77978_p();
        nbt = nbt.func_74775_l("MasterPos");
        nbt.func_74768_a("MasterY", num);
    }

    public static void setMasterZ(@Nonnull ItemStack itemStack, int num) {
        NBTTagCompound nbt = itemStack.func_77978_p();
        nbt = nbt.func_74775_l("MasterPos");
        nbt.func_74768_a("MasterZ", num);
    }

    public static void setMasterCoords(@Nonnull ItemStack stack, int x, int y, int z) {
        NBTTagCompound nbt;
        if (!stack.func_77942_o()) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        } else {
            nbt = stack.func_77978_p();
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("MasterX", x);
        tag.func_74768_a("MasterY", y);
        tag.func_74768_a("MasterZ", z);
        nbt.func_74782_a("MasterPos", (NBTBase)tag);
    }

    public static void setMasterCoords(@Nonnull ItemStack stack, BlockPos pos) {
        ItemLinker.setMasterCoords(stack, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static BlockPos getMasterCoords(@Nonnull ItemStack stack) {
        if (!stack.func_77942_o()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("MasterPos", (NBTBase)new NBTTagCompound());
            stack.func_77982_d(nbt);
        }
        return new BlockPos(ItemLinker.getMasterX(stack), ItemLinker.getMasterY(stack), ItemLinker.getMasterZ(stack));
    }

    public static void resetPosition(@Nonnull ItemStack itemStack) {
        NBTTagCompound position = new NBTTagCompound();
        position.func_74768_a("MasterX", 0);
        position.func_74768_a("MasterY", 0);
        position.func_74768_a("MasterZ", 0);
        position.func_74768_a("dimId", -1);
        itemStack.func_77983_a("MasterPos", (NBTBase)position);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity entity = worldIn.func_175625_s(pos);
        ItemStack stack = playerIn.func_184586_b(hand);
        if (entity != null) {
            if (entity instanceof ILinkableTile) {
                this.applySettings(stack, (ILinkableTile)entity, playerIn, worldIn);
                return EnumActionResult.SUCCESS;
            }
        } else if (playerIn.func_70093_af()) {
            ItemLinker.resetPosition(stack);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    protected void applySettings(@Nonnull ItemStack itemStack, ILinkableTile pad, EntityPlayer player, World world) {
        if (!ItemLinker.isSet(itemStack)) {
            pad.onLinkStart(itemStack, (TileEntity)pad, player, world);
        } else {
            pad.onLinkComplete(itemStack, (TileEntity)pad, player, world);
        }
    }
}

