/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile;

import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.interfaces.ILinkableTile;
import zmaster587.libVulpes.tile.IMultiblock;

public class TilePointer
extends TileEntity
implements IMultiblock,
ILinkableTile {
    BlockPos masterBlockPos;
    TileEntity masterBlock;

    public TilePointer() {
        this.masterBlockPos = null;
    }

    public TilePointer(BlockPos pos) {
        this.masterBlockPos = pos;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public boolean onLinkStart(@Nonnull ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        TileEntity master;
        if (this.hasMaster() && (master = this.getMasterBlock()) instanceof ILinkableTile) {
            return ((ILinkableTile)master).onLinkStart(item, master, player, world);
        }
        return false;
    }

    @Override
    public boolean onLinkComplete(@Nonnull ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        TileEntity master;
        if (this.hasMaster() && (master = this.getMasterBlock()) instanceof ILinkableTile) {
            return ((ILinkableTile)master).onLinkComplete(item, master, player, world);
        }
        return false;
    }

    public boolean allowRedstoneOutputOnSide(EnumFacing facing) {
        return true;
    }

    public boolean isSet() {
        return this.masterBlockPos != null;
    }

    public BlockPos getMasterPos() {
        return this.masterBlockPos;
    }

    public void setBlockPos(BlockPos pos) {
        this.masterBlockPos = pos;
    }

    @Override
    public void setMasterBlock(BlockPos pos) {
        this.setComplete(pos);
    }

    public TileEntity getFinalPointedTile() {
        TileEntity pointedTile;
        try {
            pointedTile = this.field_145850_b.func_175697_a(this.masterBlockPos, 1) ? this.field_145850_b.func_175625_s(this.masterBlockPos) : null;
        }
        catch (NullPointerException e) {
            return null;
        }
        if (pointedTile == null) {
            return null;
        }
        if (pointedTile instanceof TilePointer) {
            try {
                return ((TilePointer)pointedTile).getFinalPointedTile();
            }
            catch (StackOverflowError e) {
                LibVulpes.logger.warn("Stack overflow has occured with tile at location " + this.func_174877_v() + ".  The game has been prevented from crashing (in theory)");
                return null;
            }
        }
        return pointedTile;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    @Override
    public boolean hasMaster() {
        return this.isSet();
    }

    @Override
    public TileEntity getMasterBlock() {
        if (this.hasMaster()) {
            if (this.masterBlock == null || this.masterBlock.func_145837_r()) {
                this.masterBlock = this.field_145850_b.func_175625_s(this.masterBlockPos);
            }
            return this.masterBlock;
        }
        return null;
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public void setComplete(BlockPos pos) {
        this.masterBlockPos = pos;
    }

    @Override
    public void setIncomplete() {
        this.masterBlockPos = null;
        this.masterBlock = null;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        return this.writeToNBTHelper(nbtTagCompound);
    }

    protected NBTTagCompound writeToNBTHelper(NBTTagCompound nbtTagCompound) {
        if (this.masterBlockPos != null) {
            nbtTagCompound.func_74768_a("masterX", this.masterBlockPos.func_177958_n());
            nbtTagCompound.func_74768_a("masterY", this.masterBlockPos.func_177956_o());
            nbtTagCompound.func_74768_a("masterZ", this.masterBlockPos.func_177952_p());
        }
        return nbtTagCompound;
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.readFromNBTHelper(nbtTagCompound);
    }

    protected void readFromNBTHelper(NBTTagCompound nbtTagCompound) {
        this.masterBlockPos = nbtTagCompound.func_74764_b("masterX") ? new BlockPos(nbtTagCompound.func_74762_e("masterX"), nbtTagCompound.func_74762_e("masterY"), nbtTagCompound.func_74762_e("masterZ")) : null;
    }
}

