/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.entities;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import xyz.przemyk.simpleplanes.PlaneMaterial;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.math.Vector3f;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public class LargePlaneEntity
extends PlaneEntity {
    public LargePlaneEntity(World worldIn) {
        super(worldIn);
    }

    public LargePlaneEntity(World worldIn, PlaneMaterial material) {
        super(worldIn, material);
    }

    public LargePlaneEntity(World worldIn, PlaneMaterial material, double x, double y, double z) {
        super(worldIn, material, x, y, z);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelectors.func_188442_a((Entity)this));
        for (Entity entity : list) {
            if (this.field_70170_p.field_72995_K || this.func_184179_bs() instanceof EntityPlayer || entity.func_184196_w((Entity)this) || entity.func_184218_aH() || !(entity instanceof EntityLiving) || entity instanceof EntityPlayer) continue;
            entity.func_184220_m((Entity)this);
        }
    }

    @Override
    protected float getGroundPitch() {
        return 10.0f;
    }

    protected boolean func_184219_q(Entity passenger) {
        if (this.func_184188_bt().size() > 1 || passenger.func_184187_bx() == this) {
            return false;
        }
        if (passenger instanceof PlaneEntity) {
            return false;
        }
        if (this.func_184188_bt().size() == 1) {
            for (Upgrade upgrade : this.upgrades.values()) {
                if (!upgrade.getType().occupyBackSeat) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void func_184232_k(Entity passenger) {
        List passengers = this.func_184188_bt();
        if (passengers.size() > 1) {
            super.func_184232_k(passenger);
            if (passengers.indexOf(passenger) != 0) {
                this.updatePassengerTwo(passenger);
            }
        } else {
            super.func_184232_k(passenger);
        }
    }

    public void updatePassengerTwo(Entity passenger) {
        Vector3f pos = this.transformPos(this.getPassengerTwoPos(passenger));
        passenger.func_70107_b(this.getPosX() + (double)pos.getX(), this.getPosY() + (double)pos.getY(), this.getPosZ() + (double)pos.getZ());
    }

    protected Vector3f getPassengerTwoPos(Entity passenger) {
        return new Vector3f(0.0f, (float)(super.func_70042_X() + passenger.func_70033_W()), -1.0f);
    }

    @Override
    protected Item getItem() {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("simpleplanes", this.getMaterial().name + "_large_plane"));
    }

    @Override
    public double getCameraDistanceMultiplayer() {
        return 1.2;
    }

    @Override
    protected void spawnSmokeParticles(int fuel) {
        this.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, new Vector3f(0.0f, 0.8f, -2.0f), 0);
        if (fuel > 4 && fuel < 100) {
            this.spawnParticle(EnumParticleTypes.SMOKE_LARGE, new Vector3f(0.0f, 0.8f, -2.0f), 5);
        }
    }

    @Override
    public boolean canAddUpgrade(UpgradeType upgradeType) {
        if (upgradeType.occupyBackSeat) {
            if (this.func_184188_bt().size() > 1) {
                return false;
            }
            for (Upgrade upgrade : this.upgrades.values()) {
                if (!upgrade.getType().occupyBackSeat) continue;
                return false;
            }
        }
        return !this.upgrades.containsKey(upgradeType.getRegistryName()) && upgradeType.isPlaneApplicable(this);
    }

    @Override
    public boolean isLarge() {
        return true;
    }
}

