/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.handler;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketOpenWindow;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.math.MathUtil;
import xyz.przemyk.simpleplanes.math.Quaternion;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.storage.ChestUpgrade;

public class PlaneNetworking {
    public static final SimpleNetworkWrapper INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel("simpleplanes");
    private static int messageID = 1;
    private static final String PROTOCOL_VERSION = "3";

    public static void init() {
        INSTANCE.registerMessage(QuaternionMSG.class, QuaternionMSG.MSG.class, messageID++, Side.SERVER);
        INSTANCE.registerMessage(BoostMSG.class, BoostMSG.MSG.class, messageID++, Side.SERVER);
        INSTANCE.registerMessage(InventoryMSG.class, InventoryMSG.MSG.class, messageID++, Side.SERVER);
    }

    public static class InventoryMSG
    implements IMessageHandler<MSG, IMessage> {
        public IMessage onMessage(MSG msg, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (player != null && player.func_184187_bx() instanceof PlaneEntity) {
                PlaneEntity planeEntity = (PlaneEntity)player.func_184187_bx();
                if (player.func_184187_bx() instanceof PlaneEntity) {
                    PlaneEntity plane = (PlaneEntity)player.func_184187_bx();
                    Upgrade chest = plane.upgrades.getOrDefault(SimplePlanesUpgrades.CHEST.getId(), null);
                    if (chest instanceof ChestUpgrade) {
                        ChestUpgrade chest1 = (ChestUpgrade)chest;
                        if (chest1.inventory != null) {
                            if (player.field_71070_bA != player.field_71069_bz) {
                                player.func_71053_j();
                            }
                            player.func_71117_bO();
                            player.field_71135_a.func_147359_a((Packet)new SPacketOpenWindow(player.field_71139_cq, chest1.func_174875_k(), chest1.func_145748_c_(), chest1.inventory.func_70302_i_(), planeEntity.func_145782_y()));
                            player.field_71070_bA = chest1.func_174876_a(player.field_71071_by, (EntityPlayer)player);
                            player.field_71070_bA.field_75152_c = player.field_71139_cq;
                            player.field_71070_bA.func_75132_a((IContainerListener)player);
                        }
                    }
                }
            }
            return null;
        }

        public static class MSG
        implements IMessage {
            Boolean inv;

            public MSG() {
                this(true);
            }

            public MSG(boolean b) {
                this.inv = b;
            }

            public void fromBytes(ByteBuf buf) {
                try {
                    this.inv = buf.readBoolean();
                }
                catch (IndexOutOfBoundsException e) {
                    throw new RuntimeException("packet buffer does not contain enough data to construct plane's Quaternion", e);
                }
            }

            public void toBytes(ByteBuf buf) {
                buf.writeBoolean(this.inv.booleanValue());
            }
        }
    }

    public static class BoostMSG
    implements IMessageHandler<MSG, IMessage> {
        public IMessage onMessage(MSG msg, MessageContext ctx) {
            EntityPlayerMP ServerEntityPlayer = ctx.getServerHandler().field_147369_b;
            if (ServerEntityPlayer != null && ServerEntityPlayer.func_184187_bx() instanceof PlaneEntity) {
                PlaneEntity planeEntity = (PlaneEntity)ServerEntityPlayer.func_184187_bx();
                planeEntity.func_70031_b(msg.boost);
            }
            return null;
        }

        public static class MSG
        implements IMessage {
            Boolean boost;

            public MSG() {
                this(false);
            }

            public MSG(boolean boost) {
                this.boost = boost;
            }

            public void fromBytes(ByteBuf buf) {
                try {
                    this.boost = buf.readBoolean();
                }
                catch (IndexOutOfBoundsException e) {
                    throw new RuntimeException("packet buffer does not contain enough data to construct plane's Quaternion", e);
                }
            }

            public void toBytes(ByteBuf buf) {
                buf.writeBoolean(this.boost.booleanValue());
            }
        }
    }

    public static class QuaternionMSG
    implements IMessageHandler<MSG, IMessage> {
        public IMessage onMessage(MSG msg, MessageContext ctx) {
            EntityPlayerMP ServerEntityPlayer = ctx.getServerHandler().field_147369_b;
            if (ServerEntityPlayer != null && ServerEntityPlayer.func_184187_bx() instanceof PlaneEntity) {
                PlaneEntity planeEntity = (PlaneEntity)ServerEntityPlayer.func_184187_bx();
                planeEntity.setQ(msg.q);
                MathUtil.EulerAngles eulerAngles = MathUtil.toEulerAngles(msg.q);
                planeEntity.field_70177_z = (float)eulerAngles.yaw;
                planeEntity.field_70125_A = (float)eulerAngles.pitch;
                planeEntity.rotationRoll = (float)eulerAngles.roll;
                planeEntity.setQ_Client(msg.q);
            }
            return null;
        }

        public static class MSG
        implements IMessage {
            Quaternion q;

            public MSG() {
                this(new Quaternion());
            }

            public MSG(Quaternion q) {
                this.q = q;
            }

            public void fromBytes(ByteBuf buf) {
                try {
                    this.q = new Quaternion(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat());
                }
                catch (IndexOutOfBoundsException e) {
                    throw new RuntimeException("packet buffer does not contain enough data to construct plane's Quaternion", e);
                }
            }

            public void toBytes(ByteBuf buf) {
                buf.writeFloat(this.q.getX());
                buf.writeFloat(this.q.getY());
                buf.writeFloat(this.q.getZ());
                buf.writeFloat(this.q.getW());
            }
        }
    }
}

