/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.setup;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xyz.przemyk.simpleplanes.entities.LargePlaneEntity;
import xyz.przemyk.simpleplanes.entities.MegaPlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.banner.BannerUpgradeType;
import xyz.przemyk.simpleplanes.upgrades.dragon.DragonUpgrade;
import xyz.przemyk.simpleplanes.upgrades.energy.CoalEngine;
import xyz.przemyk.simpleplanes.upgrades.energy.FurnceJunkEngine;
import xyz.przemyk.simpleplanes.upgrades.floating.FloatingUpgrade;
import xyz.przemyk.simpleplanes.upgrades.folding.FoldingUpgrade;
import xyz.przemyk.simpleplanes.upgrades.heal.HealUpgrade;
import xyz.przemyk.simpleplanes.upgrades.rocket.RocketUpgrade;
import xyz.przemyk.simpleplanes.upgrades.shooter.ShooterUpgrade;
import xyz.przemyk.simpleplanes.upgrades.sprayer.SprayerUpgrade;
import xyz.przemyk.simpleplanes.upgrades.storage.ChestUpgrade;
import xyz.przemyk.simpleplanes.upgrades.tnt.TNTUpgrade;

@Mod.EventBusSubscriber(modid="simpleplanes")
public class SimplePlanesUpgrades {
    private static final ArrayList<UpgradeType> UPGRADE_TYPES = new ArrayList();
    public static final UpgradeType SPRAYER = SimplePlanesUpgrades.register("sprayer", () -> new UpgradeType(SimplePlanesItems.SPRAYER, SprayerUpgrade::new){

        @Override
        public boolean isPlaneApplicable(MegaPlaneEntity planeEntity) {
            return false;
        }
    });
    public static final UpgradeType TNT = SimplePlanesUpgrades.register("tnt", () -> new UpgradeType(Item.func_150898_a((Block)Blocks.field_150335_W), TNTUpgrade::new, true));
    public static final UpgradeType HEAL = SimplePlanesUpgrades.register("heal", () -> new UpgradeType(SimplePlanesItems.HEALING, HealUpgrade::new));
    public static final UpgradeType FLOATING = SimplePlanesUpgrades.register("floating", () -> new UpgradeType(SimplePlanesItems.FLOATY_BEDDING, FloatingUpgrade::new){

        @Override
        public boolean isPlaneApplicable(MegaPlaneEntity planeEntity) {
            return false;
        }
    });
    public static final UpgradeType BOOSTER = SimplePlanesUpgrades.register("booster", () -> new UpgradeType(SimplePlanesItems.BOOSTER, RocketUpgrade::new){

        @Override
        public boolean isPlaneApplicable(LargePlaneEntity planeEntity) {
            return false;
        }

        @Override
        public boolean isPlaneApplicable(MegaPlaneEntity planeEntity) {
            return false;
        }
    });
    public static final UpgradeType SHOOTER = SimplePlanesUpgrades.register("shooter", () -> new UpgradeType(SimplePlanesItems.SHOOTER, ShooterUpgrade::new){

        @Override
        public boolean isPlaneApplicable(MegaPlaneEntity planeEntity) {
            return false;
        }
    });
    public static final UpgradeType DRAGON = SimplePlanesUpgrades.register("dragon", () -> new UpgradeType(Items.field_151144_bL, DragonUpgrade::new){

        @Override
        public boolean isPlaneApplicable(MegaPlaneEntity planeEntity) {
            return false;
        }
    });
    public static final UpgradeType FOLDING = SimplePlanesUpgrades.register("folding", () -> new UpgradeType(SimplePlanesItems.FOLDING, FoldingUpgrade::new){

        @Override
        public boolean isPlaneApplicable(MegaPlaneEntity planeEntity) {
            return false;
        }
    });
    public static final UpgradeType BANNER = SimplePlanesUpgrades.register("banner", BannerUpgradeType::new);
    public static final UpgradeType COAL_ENGINE = SimplePlanesUpgrades.register("coal_engine", () -> new UpgradeType(SimplePlanesItems.FURNACE_ENGINE, CoalEngine::new));
    public static final UpgradeType SMOKER_ENGINE = SimplePlanesUpgrades.register("smoker_engine", () -> new UpgradeType(SimplePlanesItems.JUNK_ENGINE, FurnceJunkEngine::new));
    public static final UpgradeType CHEST = SimplePlanesUpgrades.register("chest", () -> new UpgradeType(Item.func_150898_a((Block)Blocks.field_150486_ae), ChestUpgrade::new, true));

    @SubscribeEvent
    public static void registerUpgrades(RegistryEvent.Register<UpgradeType> event) {
        for (UpgradeType upgradeType : UPGRADE_TYPES) {
            event.getRegistry().register((IForgeRegistryEntry)upgradeType);
        }
    }

    public static UpgradeType register(String id, UpgradeType upgradeType) {
        UPGRADE_TYPES.add(upgradeType);
        upgradeType.setRegistryName(new ResourceLocation("simpleplanes", id));
        return upgradeType;
    }

    public static UpgradeType register(String id, Supplier<UpgradeType> upgradeType) {
        UpgradeType e = upgradeType.get();
        return SimplePlanesUpgrades.register(id, e);
    }
}

