/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat;

import de.maxhenkel.voicechat.ForgeVoicechatClientMod;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.command.VoicechatCommand;
import de.maxhenkel.voicechat.config.ForgeServerConfig;
import de.maxhenkel.voicechat.configbuilder.ConfigBuilder;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.intercompatibility.ForgeCommonCompatibilityManager;
import de.maxhenkel.voicechat.permission.ForgePermissionManager;
import de.maxhenkel.voicechat.permission.PermissionManager;
import javax.annotation.Nullable;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;

@Mod(modid="voicechat", acceptedMinecraftVersions="[1.12.2]", updateJSON="https://maxhenkel.de/update/voicechat.json", guiFactory="de.maxhenkel.voicechat.VoicechatGuiFactory")
public class ForgeVoicechatMod
extends Voicechat {
    public static ForgeVoicechatMod INSTANCE;
    @Nullable
    private static ForgeVoicechatClientMod CLIENT_MOD;
    private final ForgeCommonCompatibilityManager compatibilityManager;

    public ForgeVoicechatMod() {
        INSTANCE = this;
        this.compatibilityManager = (ForgeCommonCompatibilityManager)CommonCompatibilityManager.INSTANCE;
        SERVER_CONFIG = ConfigBuilder.build(Loader.instance().getConfigDir().toPath().resolve("voicechat").resolve("voicechat-server.properties"), true, ForgeServerConfig::new);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (event.getSide().isClient()) {
            CLIENT_MOD = new ForgeVoicechatClientMod(event);
        }
        this.compatibilityManager.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.initialize();
        MinecraftForge.EVENT_BUS.register((Object)this.compatibilityManager);
        ((ForgePermissionManager)PermissionManager.INSTANCE).registerPermissions();
        if (CLIENT_MOD != null) {
            CLIENT_MOD.clientSetup(event);
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new VoicechatCommand());
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartedEvent event) {
        this.compatibilityManager.serverStarted(event);
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        this.compatibilityManager.serverStopping(event);
    }
}

