/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat;

import com.sun.jna.Platform;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.config.ClientConfig;
import de.maxhenkel.voicechat.config.VolumeConfig;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.macos.VersionCheck;
import de.maxhenkel.voicechat.profile.UsernameCache;
import de.maxhenkel.voicechat.resourcepacks.VoiceChatResourcePack;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public abstract class VoicechatClient {
    public static ClientConfig CLIENT_CONFIG;
    public static VolumeConfig VOLUME_CONFIG;
    public static UsernameCache USERNAME_CACHE;
    public static VoiceChatResourcePack CLASSIC_ICONS;
    public static VoiceChatResourcePack WHITE_ICONS;
    public static VoiceChatResourcePack BLACK_ICONS;

    public void initializeClient() {
        this.fixVolumeConfig();
        VOLUME_CONFIG = new VolumeConfig(Minecraft.func_71410_x().field_71412_D.toPath().resolve("config").resolve("voicechat").resolve("voicechat-volumes.properties"));
        USERNAME_CACHE = new UsernameCache(Minecraft.func_71410_x().field_71412_D.toPath().resolve("config").resolve("voicechat").resolve("username-cache.json").toFile());
        ClientManager.instance();
        if (Platform.isMac() && !VersionCheck.isMacOSNativeCompatible()) {
            Voicechat.LOGGER.warn("Your MacOS version is incompatible with {}", (Object)CommonCompatibilityManager.INSTANCE.getModName());
        }
    }

    private void fixVolumeConfig() {
        Path oldLocation = Minecraft.func_71410_x().field_71412_D.toPath().resolve("config").resolve("voicechat-volumes.properties");
        Path newLocation = Minecraft.func_71410_x().field_71412_D.toPath().resolve("config").resolve("voicechat").resolve("voicechat-volumes.properties");
        if (!newLocation.toFile().exists() && oldLocation.toFile().exists()) {
            try {
                Files.move(oldLocation, newLocation, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e) {
                Voicechat.LOGGER.error("Failed to move volumes config: {}", (Object)e.getMessage());
            }
        }
    }

    static {
        CLASSIC_ICONS = new VoiceChatResourcePack("classic_icons", (ITextComponent)new TextComponentTranslation("resourcepack.voicechat.classic_icons", new Object[0]));
        WHITE_ICONS = new VoiceChatResourcePack("white_icons", (ITextComponent)new TextComponentTranslation("resourcepack.voicechat.white_icons", new Object[0]));
        BLACK_ICONS = new VoiceChatResourcePack("black_icons", (ITextComponent)new TextComponentTranslation("resourcepack.voicechat.black_icons", new Object[0]));
    }
}

