/*
 * Decompiled with CFR 0.152.
 */
package nc.gui.element;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;

public class GuiBlockRenderer {
    private static final Minecraft MC = Minecraft.func_71410_x();

    private static TextureAtlasSprite getTexture(IBlockState state, EnumFacing facing) {
        IBakedModel ibakedmodel = MC.func_175602_ab().func_175023_a().func_178125_b(state);
        List quadList = ibakedmodel.func_188616_a(state, facing, 0L);
        TextureAtlasSprite sprite = quadList.isEmpty() ? ibakedmodel.func_177554_e() : ((BakedQuad)quadList.get(0)).func_187508_a();
        return sprite == null ? GuiBlockRenderer.getMissingSprite() : sprite;
    }

    @Nonnull
    private static TextureAtlasSprite getMissingSprite() {
        return MC.func_147117_R().func_174944_f();
    }

    public static void renderGuiBlock(@Nullable IBlockState state, EnumFacing facing, int x, int y, double zLevel, int width, int height) {
        if (state == null || facing == null) {
            return;
        }
        TextureAtlasSprite icon = GuiBlockRenderer.getTexture(state, facing);
        GuiBlockRenderer.MC.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179147_l();
        for (int i = 0; i < width; i += 16) {
            for (int j = 0; j < height; j += 16) {
                int drawWidth = Math.min(width - i, 16);
                int drawHeight = Math.min(height - j, 16);
                int drawX = x + i;
                int drawY = y + j;
                double minU = icon.func_94209_e();
                double maxU = icon.func_94212_f();
                double minV = icon.func_94206_g();
                double maxV = icon.func_94210_h();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                buffer.func_181662_b((double)drawX, (double)(drawY + drawHeight), 0.0).func_187315_a(minU, minV + (maxV - minV) * (double)drawHeight / 16.0).func_181675_d();
                buffer.func_181662_b((double)(drawX + drawWidth), (double)(drawY + drawHeight), 0.0).func_187315_a(minU + (maxU - minU) * (double)drawWidth / 16.0, minV + (maxV - minV) * (double)drawHeight / 16.0).func_181675_d();
                buffer.func_181662_b((double)(drawX + drawWidth), (double)drawY, 0.0).func_187315_a(minU + (maxU - minU) * (double)drawWidth / 16.0, minV).func_181675_d();
                buffer.func_181662_b((double)drawX, (double)drawY, 0.0).func_187315_a(minU, minV).func_181675_d();
                tessellator.func_78381_a();
            }
        }
        GlStateManager.func_179084_k();
    }
}

