/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.commands;

import java.util.ArrayList;
import java.util.List;
import mcjty.rftoolsdim.commands.AbstractRfToolsCommand;
import mcjty.rftoolsdim.dimensions.RfToolsDimensionManager;
import mcjty.rftoolsdim.dimensions.description.DimensionDescriptor;
import mcjty.rftoolsdim.dimensions.dimlets.DimletKey;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletType;
import mcjty.rftoolsdim.dimensions.types.TerrainType;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class CmdCreateDimension
extends AbstractRfToolsCommand {
    @Override
    public String getHelp() {
        return "<Name> [Terrain|Descriptor] [Seed]";
    }

    @Override
    public String getCommand() {
        return "createdim";
    }

    @Override
    public int getPermissionLevel() {
        return 3;
    }

    @Override
    public boolean isClientSide() {
        return false;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        List<DimletKey> descriptors;
        if (!(sender instanceof EntityPlayer)) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You must be a player to use this command!"));
            return;
        }
        EntityPlayer player = (EntityPlayer)sender;
        if (args.length < 2) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "The name parameter is missing!"), false);
            return;
        }
        if (args.length > 4) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "Too many parameters!"), false);
            return;
        }
        String name = this.fetchString((ICommandSender)player, args, 1, "");
        String terrainName = this.fetchString((ICommandSender)player, args, 2, "Void");
        if (terrainName.charAt(0) == '@') {
            descriptors = DimensionDescriptor.parseDescriptionString(terrainName);
            for (DimletKey key : descriptors) {
                if (key.getType() != null) continue;
                player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid descriptor!"), false);
                return;
            }
        } else {
            TerrainType terrainType = TerrainType.getTerrainById(terrainName);
            if (terrainType == null) {
                player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "Unknown terrain type!"), false);
                return;
            }
            descriptors = new ArrayList<DimletKey>(1);
            descriptors.add(new DimletKey(DimletType.DIMLET_TERRAIN, terrainType.getId()));
        }
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(player.func_130014_f_());
        DimensionDescriptor descriptor = new DimensionDescriptor(descriptors, this.fetchInt((ICommandSender)player, args, 3, 0));
        Integer dim = dimensionManager.getDimensionID(descriptor);
        if (dim != null) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "A dimension with that descriptor already exists: " + dim), false);
            return;
        }
        dim = dimensionManager.createNewDimension(player.func_130014_f_(), descriptor, name, player.func_70005_c_(), player.getPersistentID());
        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Created dimension: " + dim), false);
        dimensionManager.save(player.func_130014_f_());
    }
}

