/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.util;

import CoroUtil.ai.tasks.TaskDigTowardsTarget;
import CoroUtil.config.ConfigBlockDestruction;
import CoroUtil.config.ConfigCoroUtilAdvanced;
import CoroUtil.forge.CULog;
import CoroUtil.forge.CommonProxy;
import CoroUtil.util.BlockCoord;
import CoroUtil.util.CoroUtilBlockState;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.InvalidBlockStateException;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class UtilMining {
    public static List<IBlockState> listBlocksBlacklistedRepairing = new ArrayList<IBlockState>();
    public static List<IBlockState> listTileEntitiesWhitelistedBreakable = new ArrayList<IBlockState>();
    public static GameProfile fakePlayerProfile = null;

    public static boolean needsToMineBlock(World world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        if (world.func_180495_p(pos).func_177230_c() == CommonProxy.blockRepairingBlock) {
            return false;
        }
        return UtilMining.blockHasCollision(world, pos);
    }

    public static boolean canMineBlockNew(World world, BlockPos pos) {
        if (!UtilMining.needsToMineBlock(world, pos)) {
            return false;
        }
        return UtilMining.canBreakBlockOrTileEntity(world, pos, false);
    }

    public static boolean blockHasCollision(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185890_d((IBlockAccess)world, pos) != Block.field_185506_k;
    }

    public static boolean canBreakBlockOrTileEntity(World world, BlockPos pos, boolean isClient) {
        boolean isTileEntity = world.func_175625_s(pos) != null;
        boolean cantMineTileEntity = isTileEntity && !UtilMining.isBlockWhitelistedToBreakTileEntity(world, pos, isClient);
        return !cantMineTileEntity || !TaskDigTowardsTarget.preventMinedTileEntitiesDuringInvasions;
    }

    public static boolean canConvertToRepairingBlockNew(World world, BlockPos pos, boolean isClient) {
        boolean isTileEntity;
        boolean bl = isTileEntity = world.func_175625_s(pos) != null;
        if (!isTileEntity) {
            return !UtilMining.isBlockBlacklistedFromRepairingBlockNonTileEntity(world, pos, isClient);
        }
        return false;
    }

    public static boolean isBlockBlacklistedFromRepairingBlockNonTileEntity(World world, BlockPos pos, boolean client) {
        IBlockState state = world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos);
        return CoroUtilBlockState.partialStateInListMatchesFullState(state, client ? ClientData.listBlocksBlacklistedRepairing : listBlocksBlacklistedRepairing);
    }

    public static boolean isBlockWhitelistedToBreakTileEntity(World world, BlockPos pos, boolean client) {
        IBlockState state = world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos);
        return CoroUtilBlockState.partialStateInListMatchesFullState(state, client ? ClientData.listTileEntitiesWhitelistedBreakable : listTileEntitiesWhitelistedBreakable);
    }

    public static boolean testing(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        HashSet<IBlockState> listBlocksBlacklisted = new HashSet<IBlockState>();
        ArrayList<IBlockState> listBlocksBlacklisted2 = new ArrayList<IBlockState>();
        IBlockState state1 = Blocks.field_150398_cm.func_176223_P().func_177226_a((IProperty)BlockDoublePlant.field_176493_a, (Comparable)BlockDoublePlant.EnumPlantType.SUNFLOWER).func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.UPPER);
        IBlockState state2 = Blocks.field_150398_cm.func_176223_P().func_177226_a((IProperty)BlockDoublePlant.field_176493_a, (Comparable)BlockDoublePlant.EnumPlantType.SUNFLOWER).func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.UPPER);
        IBlockState state3 = Blocks.field_150398_cm.func_176223_P().func_177226_a((IProperty)BlockDoublePlant.field_176493_a, (Comparable)BlockDoublePlant.EnumPlantType.SUNFLOWER);
        String str = "variant=sunflower,half=upper";
        IBlockState state5 = null;
        try {
            state5 = CoroUtilBlockState.convertArgToPartialBlockState((Block)Blocks.field_150398_cm, str);
        }
        catch (NumberInvalidException e) {
            e.printStackTrace();
        }
        catch (InvalidBlockStateException e) {
            e.printStackTrace();
        }
        IBlockState state4 = Blocks.field_150398_cm.func_176203_a(Blocks.field_150398_cm.func_176201_c(state1));
        listBlocksBlacklisted.add(state2);
        if (state5 != null) {
            listBlocksBlacklisted2.add(state5);
        }
        if (listBlocksBlacklisted2.contains(state1)) {
            System.out.println("within list state match");
        } else {
            System.out.println("within list state mismatch");
        }
        if (state5 != null && CoroUtilBlockState.partialStateMatchesFullState(state5, state1)) {
            System.out.println("partial state match");
        } else {
            System.out.println("partial state mismatch");
        }
        return false;
    }

    @Deprecated
    public static boolean canMineBlock(World world, BlockCoord pos, Block block) {
        return UtilMining.canMineBlock(world, pos.toBlockPos(), block);
    }

    @Deprecated
    public static boolean canMineBlock(World world, BlockPos pos, Block block) {
        return UtilMining.canMineBlock(world, pos);
    }

    @Deprecated
    public static boolean canMineBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c() == CommonProxy.blockRepairingBlock) {
            return false;
        }
        if (TaskDigTowardsTarget.preventMinedTileEntitiesDuringInvasions && world.func_175625_s(pos) != null) {
            return false;
        }
        return !state.func_185904_a().func_76224_d();
    }

    @Deprecated
    public static boolean canConvertToRepairingBlock(World world, IBlockState state) {
        if (state.func_185904_a() == Material.field_151592_s) {
            return true;
        }
        return state.func_185917_h();
    }

    public static boolean tryRemoveBlockWithFakePlayer(World world, BlockPos pos) {
        IBlockState stateRemove = world.func_180495_p(pos);
        if (UtilMining.canGrabEventCheck(world, stateRemove, pos)) {
            boolean forceRemoveIfNeeded = true;
            if (fakePlayerProfile == null) {
                fakePlayerProfile = new GameProfile(UUID.fromString("4365749c-bd72-497c-a0dd-73f28dafd8a1"), "coroutilMiningFakePlayer");
            }
            FakePlayer player = FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)fakePlayerProfile);
            player.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            boolean actuallyRemoved = stateRemove.func_177230_c().removedByPlayer(stateRemove, world, pos, (EntityPlayer)player, true);
            boolean canHarvest = stateRemove.func_177230_c().canHarvestBlock((IBlockAccess)world, pos, (EntityPlayer)player);
            if (!actuallyRemoved && forceRemoveIfNeeded) {
                world.func_175698_g(pos);
                actuallyRemoved = true;
            }
            if (actuallyRemoved) {
                stateRemove.func_177230_c().func_176206_d(world, pos, stateRemove);
                if (canHarvest) {
                    ItemStack stack = new ItemStack(Items.field_151046_w);
                    stateRemove.func_177230_c().func_180657_a(world, (EntityPlayer)player, pos, stateRemove, world.func_175625_s(pos), stack);
                }
            }
        }
        return false;
    }

    public static boolean canGrabEventCheck(World world, IBlockState state, BlockPos pos) {
        if (!ConfigCoroUtilAdvanced.blockBreakingInvokesCancellableEvent) {
            return true;
        }
        if (world instanceof WorldServer) {
            if (fakePlayerProfile == null) {
                fakePlayerProfile = new GameProfile(UUID.fromString("4365749c-bd72-497c-a0dd-73f28dafd8a1"), "coroutilMiningFakePlayer");
            }
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, (EntityPlayer)FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)fakePlayerProfile));
            MinecraftForge.EVENT_BUS.post((Event)event);
            return !event.isCanceled();
        }
        return false;
    }

    public static void processBlockBlacklist(String config, List<IBlockState> list) {
        try {
            String[] names = config.split(" ");
            for (int i = 0; i < names.length; ++i) {
                Block block;
                names[i] = names[i].trim();
                String name = "";
                String metaOrState = "";
                if (names[i].contains("[")) {
                    name = names[i].split("\\[")[0];
                    try {
                        metaOrState = names[i].split("\\[")[1];
                        metaOrState = metaOrState.substring(0, metaOrState.length() - 1);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else {
                    name = names[i];
                }
                if ((block = Block.func_149684_b((String)name)) == null) continue;
                IBlockState state = null;
                try {
                    state = metaOrState.equals("") ? CoroUtilBlockState.getStatelessBlock(block) : CoroUtilBlockState.convertArgToPartialBlockState(block, metaOrState);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (state == null) continue;
                CULog.dbg("Adding: " + state);
                list.add(state);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void processBlockLists() {
        try {
            CULog.dbg("Processing destructable blocks for CoroUtil");
            listBlocksBlacklistedRepairing.clear();
            listTileEntitiesWhitelistedBreakable.clear();
            UtilMining.processBlockBlacklist(ConfigBlockDestruction.blacklistRepairable_RegularBlocks, listBlocksBlacklistedRepairing);
            UtilMining.processBlockBlacklist(ConfigBlockDestruction.whitelistMineable_TileEntities, listTileEntitiesWhitelistedBreakable);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static class ClientData {
        public static List<IBlockState> listBlocksBlacklistedRepairing = new ArrayList<IBlockState>();
        public static List<IBlockState> listTileEntitiesWhitelistedBreakable = new ArrayList<IBlockState>();
    }
}

