/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity.tubes;

import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.tileentity.tubes.TileEntityCableTray;
import cassiokf.industrialrenewal.tileentity.tubes.TileEntityMultiBlocksTube;
import cassiokf.industrialrenewal.util.MultiBlockHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityFluidPipe
extends TileEntityMultiBlocksTube<TileEntityFluidPipe> {
    public int averageFluid;
    public int maxOutput;
    private int oldFluid;
    private int tick;
    private boolean inUse;
    public FluidTank tank;

    public TileEntityFluidPipe() {
        this.maxOutput = IRConfig.MainConfig.Main.maxFluidPipeTransferAmount;
        this.inUse = false;
        this.tank = new FluidTank(1000){

            public int fill(FluidStack resource, boolean doFill) {
                return TileEntityFluidPipe.this.onFluidReceived(resource, doFill);
            }
        };
    }

    @Override
    public void tick() {
        if (!this.field_145850_b.field_72995_K && this.isMaster()) {
            if (this.tick >= 10) {
                this.tick = 0;
                this.averageFluid = this.outPut / 10;
                this.outPut = 0;
                if (this.averageFluid != this.oldFluid) {
                    this.oldFluid = this.averageFluid;
                    this.sync();
                }
            }
            ++this.tick;
        }
    }

    public int onFluidReceived(FluidStack resource, boolean doFill) {
        if (!this.isMaster() && !this.isMasterInvalid()) {
            return ((TileEntityFluidPipe)this.getMaster()).onFluidReceived(resource, doFill);
        }
        if (this.inUse) {
            return 0;
        }
        this.inUse = true;
        if (resource == null || resource.amount <= 0) {
            this.inUse = false;
            return 0;
        }
        List<Integer> out = MultiBlockHelper.outputFluid(this, resource, this.maxOutput, doFill, this.field_145850_b);
        if (doFill) {
            this.outPut += out.get(0).intValue();
        }
        this.outPutCount = out.get(1);
        this.inUse = false;
        return out.get(0);
    }

    @Override
    public void checkForOutPuts() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (EnumFacing face : EnumFacing.field_82609_l) {
            BlockPos currentPos = this.field_174879_c.func_177972_a(face);
            TileEntity te = this.field_145850_b.func_175625_s(currentPos);
            boolean hasMachine = te != null && !(te instanceof TileEntityFluidPipe);
            IFluidHandler machineCap = null;
            if (hasMachine) {
                machineCap = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face.func_176734_d());
            }
            if (!hasMachine || machineCap == null || machineCap.getTankProperties() == null || machineCap.getTankProperties().length <= 0 || !machineCap.getTankProperties()[0].canFill()) continue;
            this.addMachine(te, face);
        }
    }

    @Override
    public boolean instanceOf(TileEntity te) {
        return te instanceof TileEntityFluidPipe || te instanceof TileEntityCableTray && ((TileEntityCableTray)te).hasPipe();
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.getMaster() != null) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)((TileEntityFluidPipe)this.getMaster()).tank);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("fluid_average", this.averageFluid);
        return super.func_189515_b(tagCompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        this.averageFluid = tagCompound.func_74762_e("fluid_average");
        super.func_145839_a(tagCompound);
    }
}

