/*
 * Decompiled with CFR 0.152.
 */
package com.slashking.instahouses.blueprint;

import com.slashking.instahouses.InstaHouses;
import com.slashking.instahouses.blueprint.BlockData;
import com.slashking.instahouses.blueprint.BlueprintData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class Blueprint {
    List<BlueprintData> data = new ArrayList<BlueprintData>();
    int posX = 0;
    int posY = 0;
    int posZ = 0;
    public boolean finished = false;

    public void reset() {
        this.posX = 0;
        this.posY = 0;
        this.posZ = 0;
        this.finished = false;
    }

    public Blueprint(List<String> bpData) {
        this.data = this.formatBPdata(bpData);
    }

    List<BlueprintData> formatBPdata(List<String> bpData) {
        ArrayList<BlueprintData> returnList = new ArrayList<BlueprintData>();
        BlueprintData current = null;
        for (int i = 0; i < bpData.size(); ++i) {
            if (bpData.get(i).startsWith("$$")) {
                if (current != null) {
                    returnList.add(current);
                }
                current = new BlueprintData();
                String cleared = bpData.get(i).replaceAll("\\$\\$", "");
                current.layerOffset = Integer.parseInt(cleared);
                continue;
            }
            current.layerData.add(bpData.get(i));
        }
        returnList.add(current);
        return returnList;
    }

    public BlockData getNextBlock(BlockPos start) {
        if (this.finished) {
            return null;
        }
        BlockData bd = new BlockData();
        BlueprintData dataBlock = this.data.get(this.posY);
        String lineData = dataBlock.layerData.get(this.posZ);
        String[] splitData = lineData.split("~~");
        IBlockState state = this.formatBlockString(splitData[this.posX]);
        int xPos = start.func_177958_n() - splitData.length / 2 + this.posX;
        int yPos = start.func_177956_o() + dataBlock.layerOffset;
        int zPos = start.func_177952_p() - dataBlock.layerData.size() / 2 + this.posZ;
        BlockPos pos = new BlockPos(xPos, yPos, zPos);
        bd.state = state;
        bd.pos = pos;
        if (splitData.length > this.posX + 1) {
            ++this.posX;
        } else if (dataBlock.layerData.size() > this.posZ + 1) {
            this.posX = 0;
            ++this.posZ;
        } else if (this.data.size() > this.posY + 1) {
            this.posX = 0;
            this.posZ = 0;
            ++this.posY;
        } else {
            this.finished = true;
        }
        return bd;
    }

    IBlockState formatBlockString(String input) {
        IBlockState output;
        if (input.startsWith("wp")) {
            output = Blocks.field_150344_f.func_176223_P();
        } else if (input.startsWith("hb")) {
            output = Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.SMOOTHBRICK);
            output = this.applySlabOperations(output, input);
        } else if (input.startsWith("sb")) {
            output = Blocks.field_150390_bg.func_176223_P();
            output = this.applyStairOperations(output, input);
        } else if (input.startsWith("b")) {
            output = Blocks.field_150417_aV.func_176223_P();
        } else if (input.startsWith("cb")) {
            double rand = InstaHouses.rand.nextDouble();
            output = rand < 0.0075 ? Blocks.field_150341_Y.func_176223_P() : Blocks.field_150347_e.func_176223_P();
        } else if (input.startsWith("fl")) {
            output = Blocks.field_150328_O.func_176223_P();
        } else if (input.startsWith("gb")) {
            output = Blocks.field_150349_c.func_176223_P();
        } else if (input.startsWith("gp")) {
            output = Blocks.field_150410_aZ.func_176223_P();
            output = this.applyPaneOperations(output, input);
        } else if (input.startsWith("ib")) {
            output = Blocks.field_150411_aY.func_176223_P();
            output = this.applyPaneOperations(output, input);
        } else if (input.startsWith("hw")) {
            output = Blocks.field_150376_bx.func_176223_P();
            output = this.applySlabOperations(output, input);
        } else if (input.startsWith("sw")) {
            output = Blocks.field_150476_ad.func_176223_P();
            output = this.applyStairOperations(output, input);
        } else if (input.startsWith("nl")) {
            output = Blocks.field_150364_r.func_176223_P();
            output = this.applyBlockOperations(output, input);
        } else if (input.startsWith("sl")) {
            output = Blocks.field_150344_f.func_176223_P();
        } else if (input.startsWith("db")) {
            output = Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER);
            output = this.applyFacingOperations(output, input);
        } else if (input.startsWith("dt")) {
            output = Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER);
            output = this.applyFacingOperations(output, input);
        } else if (input.startsWith("ds")) {
            output = Blocks.field_150415_aT.func_176223_P().func_177226_a((IProperty)BlockTrapDoor.field_176283_b, (Comparable)Boolean.valueOf(true));
            output = this.applyFacingOperations(output, input);
        } else if (input.startsWith("tw")) {
            output = Blocks.field_150478_aa.func_176223_P();
            output = this.applyTorchFacingOperations(output, input);
        } else if (input.startsWith("t")) {
            output = Blocks.field_150478_aa.func_176223_P();
        } else if (input.startsWith("la")) {
            output = Blocks.field_150426_aN.func_176223_P();
        } else if (input.startsWith("l")) {
            output = Blocks.field_150468_ap.func_176223_P();
            output = this.applyFacingOperations(output, input);
        } else if (input.startsWith("f")) {
            output = Blocks.field_180407_aO.func_176223_P();
            output = this.applyPaneOperations(output, input);
        } else {
            output = input.startsWith("a") ? Blocks.field_150350_a.func_176223_P() : (input.startsWith("xx") ? Blocks.field_150353_l.func_176223_P() : (input.startsWith("ext") ? Blocks.field_150325_L.func_176223_P() : Blocks.field_150347_e.func_176223_P()));
        }
        return output;
    }

    IBlockState applyFacingOperations(IBlockState in, String input) {
        String[] operations = input.split("\\.");
        for (int i = 1; i < operations.length; ++i) {
            if (operations[i].equals("N")) {
                in = in.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.Plane.HORIZONTAL.func_179516_a()[0]);
            }
            if (operations[i].equals("E")) {
                in = in.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.Plane.HORIZONTAL.func_179516_a()[1]);
            }
            if (operations[i].equals("S")) {
                in = in.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.Plane.HORIZONTAL.func_179516_a()[2]);
            }
            if (!operations[i].equals("W")) continue;
            in = in.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.Plane.HORIZONTAL.func_179516_a()[3]);
        }
        return in;
    }

    IBlockState applyTorchFacingOperations(IBlockState in, String input) {
        String[] operations = input.split("\\.");
        for (int i = 1; i < operations.length; ++i) {
            if (operations[i].equals("N")) {
                in = in.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.NORTH);
            }
            if (operations[i].equals("E")) {
                in = in.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.EAST);
            }
            if (operations[i].equals("S")) {
                in = in.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.SOUTH);
            }
            if (!operations[i].equals("W")) continue;
            in = in.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.WEST);
        }
        return in;
    }

    IBlockState applySlabOperations(IBlockState in, String input) {
        String[] operations = input.split("\\.");
        for (int i = 1; i < operations.length; ++i) {
            if (operations[i].equals("B")) {
                in = in.func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
            }
            if (!operations[i].equals("T")) continue;
            in = in.func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP);
        }
        return in;
    }

    IBlockState applyStairOperations(IBlockState in, String input) {
        String[] operations = input.split("\\.");
        for (int i = 1; i < operations.length; ++i) {
            if (operations[i].equals("N")) {
                in = in.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.Plane.HORIZONTAL.func_179516_a()[0]);
            }
            if (operations[i].equals("E")) {
                in = in.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.Plane.HORIZONTAL.func_179516_a()[1]);
            }
            if (operations[i].equals("S")) {
                in = in.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.Plane.HORIZONTAL.func_179516_a()[2]);
            }
            if (operations[i].equals("W")) {
                in = in.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.Plane.HORIZONTAL.func_179516_a()[3]);
            }
            if (operations[i].equals("OL")) {
                in = in.func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.OUTER_LEFT);
            }
            if (operations[i].equals("OR")) {
                in = in.func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.OUTER_RIGHT);
            }
            if (operations[i].equals("IL")) {
                in = in.func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.INNER_LEFT);
            }
            if (operations[i].equals("IR")) {
                in = in.func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.INNER_RIGHT);
            }
            if (operations[i].equals("T")) {
                in = in.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
            }
            if (!operations[i].equals("B")) continue;
            in = in.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM);
        }
        return in;
    }

    IBlockState applyPaneOperations(IBlockState in, String input) {
        String[] operations = input.split("\\.");
        for (int i = 1; i < operations.length; ++i) {
            if (operations[i].equals("N")) {
                in = in.func_177226_a((IProperty)BlockPane.field_176241_b, (Comparable)Boolean.valueOf(true));
            }
            if (operations[i].equals("E")) {
                in = in.func_177226_a((IProperty)BlockPane.field_176242_M, (Comparable)Boolean.valueOf(true));
            }
            if (operations[i].equals("S")) {
                in = in.func_177226_a((IProperty)BlockPane.field_176243_N, (Comparable)Boolean.valueOf(true));
            }
            if (!operations[i].equals("W")) continue;
            in = in.func_177226_a((IProperty)BlockPane.field_176244_O, (Comparable)Boolean.valueOf(true));
        }
        return in;
    }

    IBlockState applyBlockOperations(IBlockState in, String input) {
        String[] operations = input.split("\\.");
        for (int i = 1; i < operations.length; ++i) {
            if (operations[i].equals("UP")) {
                in = in.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
            }
            if (operations[i].equals("NS")) {
                in = in.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z);
            }
            if (!operations[i].equals("EW")) continue;
            in = in.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X);
        }
        return in;
    }
}

