/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.packager;

import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.block.packager.BlockPackager;
import com.lothrazar.cyclicmagic.block.packager.RecipePackager;
import com.lothrazar.cyclicmagic.capability.EnergyStore;
import com.lothrazar.cyclicmagic.data.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;

public class TileEntityPackager
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITickable {
    public static final int INPUT_SIZE = 6;
    public static final int OUTPUT_SIZE = 6;
    public InventoryCrafting crafter = new InventoryCrafting((Container)new ContainerDummyPackager(), 3, 2);
    private RecipePackager lastRecipe = null;
    private int lastInvHash = 0;

    public TileEntityPackager() {
        super(12);
        this.setSlotsForInsert(0, 5);
        this.setSlotsForExtract(6, 11);
        this.initEnergy(new EnergyStore(64000, 64000, 64000), BlockPackager.FUEL_COST);
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public int func_174890_g() {
        return this.getFieldOrdinals().length;
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        this.shiftAllUp(6);
        if (this.hasEnoughEnergy()) {
            if (this.lastRecipe != null && this.lastRecipe.func_77569_a(this.crafter, this.field_145850_b) && this.tryProcessRecipe(this.lastRecipe)) {
                this.consumeEnergy();
            } else if (!this.field_145850_b.field_72995_K) {
                this.lastRecipe = null;
                int currHash = this.calculateInventoryHash(0, 6);
                if (currHash != this.lastInvHash && !this.isInventoryEmpty(0, 6)) {
                    this.lastInvHash = currHash;
                    this.findRecipe();
                }
            }
        }
    }

    private void findRecipe() {
        this.setRecipeInput();
        for (RecipePackager irecipe : RecipePackager.recipes) {
            if (!irecipe.func_77569_a(this.crafter, this.field_145850_b)) continue;
            this.lastRecipe = irecipe;
            break;
        }
    }

    private void setRecipeInput() {
        for (int slot = 0; slot < 6; ++slot) {
            ItemStack stack = this.func_70301_a(slot);
            if (stack == null) {
                stack = ItemStack.field_190927_a;
            }
            this.crafter.func_70299_a(slot, stack.func_77946_l());
        }
    }

    public boolean tryProcessRecipe(RecipePackager recipe) {
        boolean process = false;
        HashMap<Integer, Integer> mapSlotToCost = new HashMap<Integer, Integer>();
        for (ItemStack input : recipe.getInput()) {
            int needed;
            process = false;
            int neededRemaining = needed = input.func_190916_E();
            for (int i = 0; i < 6; ++i) {
                if (!UtilItemStack.isItemStackEqualIgnoreCount(input, this.func_70301_a(i))) continue;
                int payHere = Math.min(neededRemaining, this.func_70301_a(i).func_190916_E());
                mapSlotToCost.put(i, payHere);
                if ((neededRemaining -= payHere) != 0) continue;
                process = true;
                break;
            }
            if (process) continue;
            break;
        }
        if (process && this.inventoryHasRoom(6, recipe.func_77571_b())) {
            for (Map.Entry entry : mapSlotToCost.entrySet()) {
                this.func_70298_a((Integer)entry.getKey(), (Integer)entry.getValue());
            }
            this.sendOutputItem(recipe.func_77571_b());
        }
        return process;
    }

    public void sendOutputItem(ItemStack itemstack) {
        for (int i = 6; i < this.func_70302_i_(); ++i) {
            if (itemstack.func_190926_b()) continue;
            itemstack = this.tryMergeStackIntoSlot(itemstack, i);
        }
        if (!itemstack.func_190926_b()) {
            UtilItemStack.dropItemStackInWorld(this.func_145831_w(), this.field_174879_c.func_177984_a(), itemstack);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("redstone", this.needsRedstone);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.needsRedstone = compound.func_74762_e("redstone");
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.timer;
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
            case TIMER: {
                this.timer = value;
            }
        }
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone + 1;
        if (val > 1) {
            val = 0;
        }
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public static class ContainerDummyPackager
    extends Container {
        public boolean func_75145_c(EntityPlayer playerIn) {
            return false;
        }
    }

    public static enum Fields {
        REDSTONE,
        TIMER;

    }
}

