/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.registry.PermissionRegistry;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilSound;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class UtilPlaceBlocks {
    public static ArrayList<Block> ignoreList = new ArrayList();

    public static boolean buildStackAsPlayer(World world, EntityPlayer player, BlockPos placePos, ItemStack stack) {
        return UtilPlaceBlocks.buildStackAsPlayer(world, player, placePos, stack, null, null, null);
    }

    public static boolean buildStackAsPlayer(World world, EntityPlayer player, BlockPos placePos, ItemStack stack, EnumFacing sideMouseover, Vec3d hitVec, EnumFacing playerFacing) {
        if (!PermissionRegistry.hasPermissionHere(player, placePos)) {
            return false;
        }
        if (sideMouseover == null) {
            sideMouseover = EnumFacing.UP;
        }
        if (playerFacing == null) {
            playerFacing = EnumFacing.NORTH;
        }
        if (hitVec == null) {
            hitVec = Vec3d.field_186680_a;
        }
        BuildPlayer builder = new BuildPlayer(world, player.func_146103_bH(), stack, playerFacing);
        boolean result = EnumActionResult.SUCCESS == stack.func_77973_b().func_180614_a((EntityPlayer)builder, world, placePos, EnumHand.MAIN_HAND, sideMouseover, (float)hitVec.field_72450_a, (float)hitVec.field_72448_b, (float)hitVec.field_72449_c);
        return result;
    }

    public static boolean placeStateSafe(World world, EntityPlayer player, BlockPos placePos, IBlockState placeState) {
        return UtilPlaceBlocks.placeStateSafe(world, player, placePos, placeState, false);
    }

    public static boolean placeStateSafe(World world, EntityPlayer player, BlockPos placePos, IBlockState placeState, boolean playSound) {
        SoundType type;
        if (placePos == null) {
            return false;
        }
        IBlockState stateHere = null;
        if (player != null && !PermissionRegistry.hasPermissionHere(player, placePos)) {
            return false;
        }
        if (!world.func_175623_d(placePos) && (stateHere = world.func_180495_p(placePos)) != null) {
            Block blockHere = stateHere.func_177230_c();
            if (!blockHere.func_176200_f((IBlockAccess)world, placePos)) {
                return false;
            }
            if (!stateHere.func_185904_a().func_76224_d()) {
                boolean dropBlock = true;
                if (!world.field_72995_K) {
                    world.func_175655_b(placePos, dropBlock);
                }
            }
        }
        if (placeState.func_177230_c() instanceof BlockLeaves) {
            placeState = placeState.func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false));
        }
        boolean success = false;
        try {
            if (!world.field_72995_K) {
                success = world.func_180501_a(placePos, placeState, 3);
            }
        }
        catch (Exception e) {
            ModCyclic.logger.error("Error attempting to place block ", e);
        }
        if (success && playSound && (type = UtilSound.getSoundFromBlockstate(placeState, world, placePos)) != null && type.func_185841_e() != null) {
            UtilSound.playSoundFromServer(type.func_185841_e(), SoundCategory.BLOCKS, placePos, world.field_73011_w.getDimension(), 18);
        }
        return success;
    }

    private static void translateCSV() {
        if (ignoreList.size() == 0) {
            ignoreList.add(Blocks.field_150378_br);
            ignoreList.add(Blocks.field_150384_bq);
            ignoreList.add((Block)Blocks.field_150427_aO);
            ignoreList.add(Blocks.field_150324_C);
            ignoreList.add((Block)Blocks.field_180409_at);
            ignoreList.add((Block)Blocks.field_180410_as);
            ignoreList.add((Block)Blocks.field_180412_aq);
            ignoreList.add((Block)Blocks.field_180413_ao);
            ignoreList.add((Block)Blocks.field_180414_ap);
            ignoreList.add((Block)Blocks.field_180411_ar);
            ignoreList.add((Block)Blocks.field_150454_av);
            ignoreList.add((Block)Blocks.field_150465_bP);
            ignoreList.add((Block)Blocks.field_150398_cm);
        }
    }

    public static boolean moveBlockTo(World world, EntityPlayer player, BlockPos pos, BlockPos posMoveToHere) {
        IBlockState newStateToPlace = world.func_180495_p(pos);
        UtilPlaceBlocks.translateCSV();
        if (newStateToPlace == null || ignoreList.contains(newStateToPlace.func_177230_c())) {
            return false;
        }
        if (newStateToPlace.func_185887_b(world, posMoveToHere) == -1.0f) {
            return false;
        }
        boolean moved = false;
        if (world.func_175623_d(posMoveToHere) && world.func_175660_a(player, pos)) {
            TileEntity newTile;
            TileEntity tile = world.func_175625_s(pos);
            NBTTagCompound tileData = null;
            if (tile != null) {
                tileData = new NBTTagCompound();
                tile.func_189515_b(tileData);
            }
            UtilPlaceBlocks.destroyBlock(world, pos);
            moved = UtilPlaceBlocks.placeStateSafe(world, player, posMoveToHere, newStateToPlace);
            if (moved && tileData != null && (newTile = world.func_175625_s(posMoveToHere)) != null) {
                tileData.func_74768_a("x", posMoveToHere.func_177958_n());
                tileData.func_74768_a("y", posMoveToHere.func_177956_o());
                tileData.func_74768_a("z", posMoveToHere.func_177952_p());
                newTile.func_145839_a(tileData);
                newTile.func_70296_d();
                world.func_175646_b(posMoveToHere, newTile);
            }
        }
        return moved;
    }

    public static boolean destroyBlock(World world, BlockPos pos) {
        if (world.func_175625_s(pos) != null) {
            world.func_175713_t(pos);
        }
        try {
            boolean setToAirSuccess = world.func_175698_g(pos);
            if (!setToAirSuccess) {
                setToAirSuccess = world.func_175655_b(pos, false);
            }
        }
        catch (Exception e) {
            ModCyclic.logger.error("Error thrown by a tile entity when removing the block: ", e);
            return false;
        }
        world.func_175646_b(pos, null);
        UtilPlaceBlocks.tryUpdateNeighbour(world, pos.func_177978_c());
        UtilPlaceBlocks.tryUpdateNeighbour(world, pos.func_177968_d());
        UtilPlaceBlocks.tryUpdateNeighbour(world, pos.func_177974_f());
        UtilPlaceBlocks.tryUpdateNeighbour(world, pos.func_177976_e());
        return true;
    }

    public static void tryUpdateNeighbour(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            tile.func_145836_u();
            tile.func_70296_d();
        }
    }

    public static BlockPos pullBlock(World worldIn, EntityPlayer player, BlockPos pos, EnumFacing face) {
        BlockPos posTowardsPlayer = pos.func_177972_a(face);
        if (UtilPlaceBlocks.moveBlockTo(worldIn, player, pos, posTowardsPlayer)) {
            return posTowardsPlayer;
        }
        return null;
    }

    public static BlockPos pushBlock(World worldIn, EntityPlayer player, BlockPos pos, EnumFacing face) {
        BlockPos posAwayPlayer = pos.func_177972_a(face.func_176734_d());
        if (UtilPlaceBlocks.moveBlockTo(worldIn, player, pos, posAwayPlayer)) {
            return posAwayPlayer;
        }
        return null;
    }

    public static boolean placeStateOverwrite(World world, EntityPlayer player, BlockPos placePos, IBlockState placeState) {
        if (world.func_175698_g(placePos)) {
            return UtilPlaceBlocks.placeStateSafe(world, player, placePos, placeState);
        }
        return false;
    }

    public static boolean rotateBlockValidState(World worldObj, EntityPlayer p, BlockPos pos, EnumFacing side) {
        if (pos == null || worldObj.func_180495_p(pos) == null || side == null) {
            return false;
        }
        IBlockState clicked = worldObj.func_180495_p(pos);
        if (clicked.func_177230_c() == null) {
            return false;
        }
        Block clickedBlock = clicked.func_177230_c();
        boolean isDone = clickedBlock.rotateBlock(worldObj, pos, side);
        if (isDone) {
            if (p != null) {
                UtilSound.playSoundPlaceBlock(p, pos, clickedBlock);
            }
            return true;
        }
        IBlockState placeState = null;
        if (clickedBlock == Blocks.field_150348_b) {
            BlockStone.EnumType variant = (BlockStone.EnumType)clicked.func_177229_b((IProperty)BlockStone.field_176247_a);
            switch (variant) {
                case ANDESITE: {
                    placeState = clicked.func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE_SMOOTH);
                    break;
                }
                case ANDESITE_SMOOTH: {
                    placeState = clicked.func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE);
                    break;
                }
                case DIORITE: {
                    placeState = clicked.func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE_SMOOTH);
                    break;
                }
                case DIORITE_SMOOTH: {
                    placeState = clicked.func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE);
                    break;
                }
                case GRANITE: {
                    placeState = clicked.func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE_SMOOTH);
                    break;
                }
                case GRANITE_SMOOTH: {
                    placeState = clicked.func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE);
                    break;
                }
                case STONE: {
                    placeState = Blocks.field_150417_aV.func_176223_P();
                }
            }
        } else if (clickedBlock == Blocks.field_150417_aV) {
            if (Blocks.field_150417_aV.func_176201_c(clicked) == BlockStoneBrick.field_176248_b) {
                placeState = UtilItemStack.getStateFromMeta(Blocks.field_150417_aV, BlockStoneBrick.field_176252_O);
            } else if (Blocks.field_150417_aV.func_176201_c(clicked) == BlockStoneBrick.field_176252_O) {
                placeState = Blocks.field_150348_b.func_176223_P();
            }
        }
        if (placeState != null) {
            isDone = UtilPlaceBlocks.placeStateOverwrite(worldObj, p, pos, placeState);
        }
        if (isDone) {
            return true;
        }
        for (IProperty prop : clicked.func_177228_b().keySet()) {
            if (isDone) break;
            if (prop.func_177701_a().equals("half")) {
                isDone = UtilPlaceBlocks.placeStateOverwrite(worldObj, p, pos, clicked.func_177231_a(prop));
                continue;
            }
            if (prop.func_177701_a().equals("seamless")) {
                isDone = UtilPlaceBlocks.placeStateOverwrite(worldObj, p, pos, clicked.func_177231_a(prop));
                continue;
            }
            if (prop.func_177701_a().equals("axis")) {
                isDone = UtilPlaceBlocks.placeStateOverwrite(worldObj, p, pos, clicked.func_177231_a(prop));
                continue;
            }
            if (!prop.func_177701_a().equals("type") || clickedBlock != Blocks.field_150322_A && clickedBlock != Blocks.field_180395_cM) continue;
            isDone = UtilPlaceBlocks.placeStateOverwrite(worldObj, p, pos, clicked.func_177231_a(prop));
        }
        return isDone;
    }

    public static class BuildPlayer
    extends EntityPlayer {
        private ItemStack holding;
        private EnumFacing facing;

        public BuildPlayer(World worldIn, GameProfile gameProfileIn, ItemStack holding, EnumFacing facing) {
            super(worldIn, gameProfileIn);
            this.holding = holding;
            this.facing = facing;
        }

        public EnumFacing func_174811_aO() {
            return this.facing == null ? EnumFacing.NORTH : this.facing;
        }

        public ItemStack func_184586_b(EnumHand hand) {
            return this.holding;
        }

        public boolean func_175149_v() {
            return false;
        }

        public boolean func_184812_l_() {
            return false;
        }
    }
}

