/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.launcher;

import icbm.classic.api.events.LauncherSetTargetEvent;
import icbm.classic.api.tile.IRadioWaveReceiver;
import icbm.classic.api.tile.IRadioWaveSender;
import icbm.classic.lib.LanguageUtility;
import icbm.classic.lib.radio.RadioRegistry;
import icbm.classic.lib.transform.region.Cube;
import icbm.classic.lib.transform.vector.Pos;
import icbm.classic.prefab.tile.TileFrequency;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class TileLauncherPrefab
extends TileFrequency
implements IRadioWaveReceiver {
    private Pos _targetPos = Pos.zero;

    public void onLoad() {
        super.onLoad();
        if (this.isServer()) {
            RadioRegistry.add(this);
        }
    }

    @Override
    public void func_145843_s() {
        RadioRegistry.remove(this);
        super.func_145843_s();
    }

    public Pos getTarget() {
        if (this._targetPos == null) {
            this._targetPos = this.targetWithYValue() ? new Pos(this.func_174877_v()) : new Pos(this.func_174877_v().func_177958_n(), 0.0, this.func_174877_v().func_177952_p());
        }
        return this._targetPos;
    }

    public boolean targetWithYValue() {
        return false;
    }

    public void setTarget(Pos target) {
        LauncherSetTargetEvent event = new LauncherSetTargetEvent(this, target);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            this._targetPos = (Pos)(event.target == null ? target : event.target).floor();
            this.updateClient = true;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this._targetPos = new Pos(nbt.func_74775_l("target"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (this._targetPos != null) {
            nbt.func_74782_a("target", (NBTBase)this._targetPos.toNBT());
        }
        return super.func_189515_b(nbt);
    }

    public String getStatus() {
        String color = "\u00a74";
        String status = LanguageUtility.getLocal("gui.misc.idle");
        return color + status;
    }

    @Override
    public void receiveRadioWave(float hz, IRadioWaveSender sender, String messageHeader, Object[] data) {
    }

    @Override
    public Cube getRadioReceiverRange() {
        return RadioRegistry.INFINITE;
    }

    public void onInventoryChanged(int slot, ItemStack prev, ItemStack item) {
        this.updateClient = true;
    }
}

