/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.block;

import de.keridos.floodlights.client.gui.CreativeTabFloodlight;
import de.keridos.floodlights.reference.Names;
import de.keridos.floodlights.reference.Textures;
import de.keridos.floodlights.tileentity.TileEntityFL;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFL
extends Block {
    protected BlockFL(String unlocName, Material material, SoundType type, float hardness) {
        super(material);
        this.func_149711_c(hardness);
        this.func_149672_a(type);
        this.setNames(unlocName);
        if (!unlocName.equals("phantomLight") && !unlocName.equals("phantomUVLight")) {
            this.func_149647_a(CreativeTabFloodlight.FL_TAB);
        }
    }

    public String func_149739_a() {
        return String.format("tile.%s%s", Textures.RESOURCE_PREFIX, this.getUnwrappedUnlocalizedName(super.func_149739_a()));
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof TileEntityFL)) {
            super.getDrops(drops, world, pos, state, fortune);
            return;
        }
        NBTTagCompound nbtTagCompound = ((TileEntityFL)tileEntity).writeOwnToNBT(new NBTTagCompound());
        ItemStack stack = new ItemStack(Item.func_150898_a((Block)this), 1, 0, nbtTagCompound);
        stack.func_77982_d(nbtTagCompound);
        drops.add((Object)stack);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileEntityFL)) {
            return;
        }
        TileEntityFL tileFL = (TileEntityFL)tile;
        if (stack.func_77942_o()) {
            tileFL.readOwnFromNBT(stack.func_77978_p());
        }
        if (stack.func_82837_s()) {
            tileFL.setCustomName(stack.func_82833_r());
        }
        tileFL.setOrientation(this.getFacing(placer));
    }

    public EnumFacing getFacing(EntityLivingBase entityLiving) {
        float rotationYaw = MathHelper.func_76142_g((float)entityLiving.field_70177_z);
        float rotationPitch = entityLiving.field_70125_A;
        int result = rotationPitch < -45.0f ? 1 : (rotationPitch > 45.0f ? 0 : (MathHelper.func_76128_c((double)((double)(rotationYaw * 4.0f / 360.0f) + 0.5)) & 3) + 2);
        EnumFacing[] direction = new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST};
        return direction[result];
    }

    private void setNames(String unlocalizedName) {
        this.func_149663_c(unlocalizedName);
        this.setRegistryName("floodlights", Names.convertToUnderscore(unlocalizedName));
    }

    private String getUnwrappedUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(".") + 1);
    }
}

