/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.item.itemBlock;

import de.keridos.floodlights.capability.CustomEnergyStorage;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ElectricItemBlock
extends ItemBlock {
    public ElectricItemBlock(Block block) {
        super(block);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (energy != null) {
            tooltip.add(String.format("Energy: %.1fk / %.1fk", Float.valueOf((float)energy.getEnergyStored() / 1000.0f), Float.valueOf((float)energy.getMaxEnergyStored() / 1000.0f)));
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ICapabilityProvider(){

            public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                return capability == CapabilityEnergy.ENERGY;
            }

            @Nullable
            public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                if (capability != CapabilityEnergy.ENERGY) {
                    return null;
                }
                CustomEnergyStorage storage = new CustomEnergyStorage(stack);
                return (T)((Object)storage);
            }
        };
    }

    public boolean func_179215_a(NBTTagCompound nbt) {
        return super.func_179215_a(nbt);
    }
}

