/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.util;

import cofh.redstoneflux.api.IEnergyContainerItem;
import de.keridos.floodlights.compatability.ModCompatibility;
import ic2.api.item.IElectricItem;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class GeneralUtil {
    public static Item getMinecraftItem(String name) {
        return (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("minecraft", name));
    }

    public static String safeLocalize(String key) {
        String translation = I18n.func_74838_a((String)key);
        if (translation.equals(key)) {
            translation = I18n.func_150826_b((String)key);
        }
        return translation;
    }

    public static int getBurnTime(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 150;
            }
            if (block.func_149688_o(block.func_176203_a(itemStack.func_77952_i())) == Material.field_151575_d) {
                return 300;
            }
            if (block == Blocks.field_150402_ci) {
                return 14400;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
            return 200;
        }
        if (item == Items.field_151055_y) {
            return 100;
        }
        if (item == Items.field_151044_h) {
            return 1600;
        }
        if (item == Items.field_151129_at) {
            return 20000;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 100;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        return ForgeEventFactory.getItemBurnTime((ItemStack)itemStack);
    }

    public static boolean isItemStackValidElectrical(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (ModCompatibility.IC2Loaded && item instanceof IElectricItem) {
            return ((IElectricItem)item).canProvideEnergy(itemStack);
        }
        return ModCompatibility.CofhCoreLoaded && item instanceof IEnergyContainerItem;
    }

    public static BlockPos getPosFromPosFacing(BlockPos pos, EnumFacing facing) {
        return new BlockPos(pos.func_177958_n() + facing.func_82601_c(), pos.func_177956_o() + facing.func_96559_d(), pos.func_177952_p() + facing.func_82599_e());
    }

    public static boolean isBlockValidGrowable(Block block, World world, BlockPos blockPos) {
        boolean result = false;
        if (block instanceof IGrowable && ((IGrowable)block).func_176473_a(world, blockPos, world.func_180495_p(blockPos), false)) {
            Logger.getGlobal().info("blockcangrow: " + ((IGrowable)block).func_176473_a(world, blockPos, world.func_180495_p(blockPos), false));
            result = true;
        }
        return result;
    }
}

