/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.world.generator.MineshaftVariantSettings;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.storage.loot.LootTableList;

public class SideRoomDungeon
extends MineshaftPiece {
    private static final int SECONDARY_AXIS_LEN = 9;
    private static final int Y_AXIS_LEN = 4;
    private static final int MAIN_AXIS_LEN = 9;
    private static final int LOCAL_X_END = 8;
    private static final int LOCAL_Y_END = 3;
    private static final int LOCAL_Z_END = 8;

    public SideRoomDungeon() {
    }

    public SideRoomDungeon(int i, int pieceChainLen, Random random, StructureBoundingBox blockBox, EnumFacing direction, MineshaftVariantSettings settings) {
        super(i, pieceChainLen, settings);
        this.func_186164_a(direction);
        this.field_74887_e = blockBox;
    }

    public static StructureBoundingBox determineBoxPosition(List<StructureComponent> list, Random random, int x, int y, int z, EnumFacing direction) {
        StructureBoundingBox blockBox = new StructureBoundingBox(x, y, z, x, y + 4 - 1, z);
        switch (direction) {
            default: {
                blockBox.field_78893_d = x + 4;
                blockBox.field_78897_a = x - 4;
                blockBox.field_78896_c = z - 8;
                break;
            }
            case SOUTH: {
                blockBox.field_78893_d = x + 4;
                blockBox.field_78897_a = x - 4;
                blockBox.field_78892_f = z + 8;
                break;
            }
            case WEST: {
                blockBox.field_78897_a = x - 8;
                blockBox.field_78892_f = z + 4;
                blockBox.field_78896_c = z - 4;
                break;
            }
            case EAST: {
                blockBox.field_78893_d = x + 8;
                blockBox.field_78892_f = z + 4;
                blockBox.field_78896_c = z - 4;
            }
        }
        StructureComponent intersectingPiece = StructureComponent.func_74883_a(list, (StructureBoundingBox)blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void func_74861_a(StructureComponent structurePiece, List<StructureComponent> list, Random random) {
    }

    @ParametersAreNonnullByDefault
    public boolean func_74875_a(World world, Random random, StructureBoundingBox box) {
        if (this.func_74860_a(world, box)) {
            return false;
        }
        if (this.isInOcean(world, 0, 0) || this.isInOcean(world, 8, 8)) {
            return false;
        }
        this.fill(world, box, random, 0, 0, 0, 8, 3, 8, this.getBrickSelector());
        this.fill(world, box, 1, 1, 1, 7, 2, 7, AIR);
        this.generateLegs(world, box, random);
        IBlockState LADDER = Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.NORTH);
        this.fill(world, box, 4, 1, 1, 4, 3, 1, LADDER);
        BlockPos spawnerPos = new BlockPos(this.func_74865_a(4, 5), this.func_74862_a(1), this.func_74873_b(4, 5));
        world.func_180501_a(spawnerPos, Blocks.field_150474_ac.func_176223_P(), 2);
        TileEntity blockEntity = world.func_175625_s(spawnerPos);
        if (blockEntity instanceof TileEntityMobSpawner) {
            ((TileEntityMobSpawner)blockEntity).func_145881_a().func_190894_a(new ResourceLocation("cave_spider"));
        }
        this.chanceReplaceAir(world, box, random, 0.9f, 3, 1, 4, 5, 2, 6, Blocks.field_150321_G.func_176223_P());
        this.chanceReplaceAir(world, box, random, 0.1f, 1, 1, 1, 7, 2, 8, Blocks.field_150321_G.func_176223_P());
        this.func_186167_a(world, box, random, 1, 1, 7, LootTableList.field_186424_f);
        if (random.nextInt(2) == 0) {
            this.func_186167_a(world, box, random, 7, 1, 7, LootTableList.field_186424_f);
        }
        this.addBiomeDecorations(world, box, random, 0, 0, 0, 8, 2, 8);
        return true;
    }

    private void generateLegs(World world, StructureBoundingBox box, Random random) {
        this.generateLeg(world, random, box, 1, 1, this.getBrickSelector());
        this.generateLeg(world, random, box, 1, 7, this.getBrickSelector());
        this.generateLeg(world, random, box, 7, 1, this.getBrickSelector());
        this.generateLeg(world, random, box, 7, 7, this.getBrickSelector());
    }
}

