/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.manager;

import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import com.supermartijn642.tesseract.manager.TesseractTracker;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class TesseractReference {
    private final int dimension;
    private final BlockPos pos;
    private final EnumMap<EnumChannelType, Integer> channels = new EnumMap(EnumChannelType.class);
    private final EnumMap<EnumChannelType, Boolean> canSend = new EnumMap(EnumChannelType.class);
    private final EnumMap<EnumChannelType, Boolean> canReceive = new EnumMap(EnumChannelType.class);

    public TesseractReference(TesseractBlockEntity entity) {
        this.dimension = entity.func_145831_w().field_73011_w.getDimension();
        this.pos = entity.func_174877_v();
        for (EnumChannelType type : EnumChannelType.values()) {
            this.channels.put(type, entity.getChannelId(type));
            this.canSend.put(type, entity.canSend(type));
            this.canReceive.put(type, entity.canReceive(type));
        }
    }

    public TesseractReference(NBTTagCompound tag) {
        this.dimension = tag.func_74762_e("dim");
        this.pos = new BlockPos(tag.func_74762_e("posx"), tag.func_74762_e("posy"), tag.func_74762_e("posz"));
        for (EnumChannelType type : EnumChannelType.values()) {
            this.channels.put(type, tag.func_74762_e((Object)((Object)type) + "_channel"));
            this.canSend.put(type, tag.func_74767_n((Object)((Object)type) + "_canSend"));
            this.canReceive.put(type, tag.func_74767_n((Object)((Object)type) + "_canReceive"));
        }
    }

    public int getDimension() {
        return this.dimension;
    }

    public World getLevel() {
        return DimensionManager.getWorld((int)this.dimension);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public boolean isValid() {
        boolean isValid;
        World level = this.getLevel();
        boolean bl = isValid = level != null && level.func_180495_p(this.pos).func_177230_c() == Tesseract.tesseract && level.func_175625_s(this.pos) instanceof TesseractBlockEntity;
        if (!isValid) {
            TesseractTracker.SERVER.remove(this.dimension, this.pos);
        }
        return isValid;
    }

    public TesseractBlockEntity getTesseract() {
        return (TesseractBlockEntity)this.getLevel().func_175625_s(this.pos);
    }

    public NBTTagCompound write() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("dim", this.dimension);
        compound.func_74768_a("posx", this.pos.func_177958_n());
        compound.func_74768_a("posy", this.pos.func_177956_o());
        compound.func_74768_a("posz", this.pos.func_177952_p());
        for (EnumChannelType type : EnumChannelType.values()) {
            compound.func_74768_a((Object)((Object)type) + "_channel", this.channels.get((Object)type).intValue());
            compound.func_74757_a((Object)((Object)type) + "_canSend", this.canSend.get((Object)type).booleanValue());
            compound.func_74757_a((Object)((Object)type) + "_canReceive", this.canReceive(type));
        }
        return compound;
    }

    public boolean canSend(EnumChannelType type) {
        return this.canSend.get((Object)type);
    }

    public boolean canReceive(EnumChannelType type) {
        return this.canReceive.get((Object)type);
    }

    public int getChannelId(EnumChannelType type) {
        return this.channels.get((Object)type);
    }

    public void update(TesseractBlockEntity entity) {
        for (EnumChannelType type : EnumChannelType.values()) {
            Channel channel;
            int channelId = entity.getChannelId(type);
            this.channels.put(type, channelId);
            this.canSend.put(type, entity.canSend(type));
            this.canReceive.put(type, entity.canReceive(type));
            if (channelId != -1 || (channel = TesseractChannelManager.getInstance(entity.func_145831_w()).getChannelById(type, channelId)) == null) continue;
            channel.updateTesseract(this);
        }
    }

    public void delete() {
        for (Map.Entry<EnumChannelType, Integer> entry : this.channels.entrySet()) {
            Channel channel = TesseractChannelManager.SERVER.getChannelById(entry.getKey(), entry.getValue());
            if (channel == null) continue;
            channel.removeTesseract(this);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TesseractReference)) {
            return false;
        }
        TesseractReference that = (TesseractReference)o;
        return that.dimension == this.dimension && Objects.equals(this.pos, that.pos);
    }

    public int hashCode() {
        int result = this.dimension;
        result = 31 * result + (this.pos != null ? this.pos.hashCode() : 0);
        return result;
    }
}

