/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.manager;

import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.manager.TesseractReference;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TesseractTracker {
    public static final TesseractTracker SERVER = new TesseractTracker();
    private final IntObjectMap<HashMap<BlockPos, TesseractReference>> tesseracts = new IntObjectHashMap();
    private final Set<TesseractReference> toBeRemoved = new HashSet<TesseractReference>();

    public static TesseractTracker getInstance(World world) {
        return world.field_72995_K ? null : SERVER;
    }

    public TesseractReference add(TesseractBlockEntity self) {
        int dimension = self.func_145831_w().field_73011_w.getDimension();
        this.tesseracts.putIfAbsent((Object)dimension, new HashMap());
        return ((HashMap)this.tesseracts.get(dimension)).computeIfAbsent(self.func_174877_v(), key -> new TesseractReference(self));
    }

    @Deprecated
    public TesseractReference tryAdd(int dimension, BlockPos pos) {
        WorldServer level = DimensionManager.getWorld((int)dimension);
        TileEntity entity = level.func_175625_s(pos);
        return entity instanceof TesseractBlockEntity ? this.add((TesseractBlockEntity)entity) : null;
    }

    public void remove(World level, BlockPos pos) {
        int dimension = level.field_73011_w.getDimension();
        this.remove(dimension, pos);
    }

    public void remove(int dimension, BlockPos pos) {
        this.tesseracts.putIfAbsent((Object)dimension, new HashMap());
        TesseractReference reference = (TesseractReference)((HashMap)this.tesseracts.get(dimension)).get(pos);
        if (reference != null) {
            this.toBeRemoved.add(reference);
        }
    }

    private void removeAndUpdate(TesseractReference reference) {
        reference.delete();
        this.tesseracts.putIfAbsent((Object)reference.getDimension(), new HashMap());
        ((HashMap)this.tesseracts.get(reference.getDimension())).remove(reference.getPos());
    }

    public TesseractReference get(World level, BlockPos pos) {
        int dimension = level.field_73011_w.getDimension();
        return (TesseractReference)((HashMap)this.tesseracts.putIfAbsent((Object)dimension, new HashMap())).get(pos);
    }

    public NBTTagCompound writeKey(TesseractReference reference) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("dimension", reference.getDimension());
        tag.func_74768_a("posx", reference.getPos().func_177958_n());
        tag.func_74768_a("posy", reference.getPos().func_177956_o());
        tag.func_74768_a("posz", reference.getPos().func_177952_p());
        return tag;
    }

    public TesseractReference fromKey(NBTTagCompound key) {
        int dimension = key.func_74762_e("dimension");
        BlockPos pos = new BlockPos(key.func_74762_e("posx"), key.func_74762_e("posy"), key.func_74762_e("posz"));
        return this.tesseracts.containsKey(dimension) ? (TesseractReference)((HashMap)this.tesseracts.get(dimension)).get(pos) : null;
    }

    @SubscribeEvent
    public static void onSave(WorldEvent.Save e) {
        World level = e.getWorld();
        if (level != null && !level.field_72995_K && level.field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
            File directory = new File(DimensionManager.getCurrentSaveRootDirectory(), "tesseract/tracking");
            int index = 0;
            for (Map.Entry dimensionEntry : TesseractTracker.SERVER.tesseracts.entrySet()) {
                for (Map.Entry entry : ((HashMap)dimensionEntry.getValue()).entrySet()) {
                    File file = new File(directory, "tesseract" + index++ + ".nbt");
                    try {
                        file.getParentFile().mkdirs();
                        file.createNewFile();
                        CompressedStreamTools.func_74795_b((NBTTagCompound)((TesseractReference)entry.getValue()).write(), (File)file);
                    }
                    catch (IOException ioException) {
                        ioException.printStackTrace();
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLoad(WorldEvent.Load e) {
        World level = e.getWorld();
        if (level != null && !level.field_72995_K && level.field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
            TesseractTracker.SERVER.tesseracts.clear();
            File directory = new File(DimensionManager.getCurrentSaveRootDirectory(), "tesseract/tracking");
            File[] files = directory.listFiles();
            if (files != null) {
                for (File file : directory.listFiles()) {
                    if (!file.isFile() || !file.getName().endsWith(".nbt")) continue;
                    try {
                        NBTTagCompound tag = CompressedStreamTools.func_74797_a((File)file);
                        TesseractReference location = new TesseractReference(tag);
                        TesseractTracker.SERVER.tesseracts.putIfAbsent((Object)location.getDimension(), new HashMap());
                        ((HashMap)TesseractTracker.SERVER.tesseracts.get(location.getDimension())).put(location.getPos(), location);
                    }
                    catch (IOException ioException) {
                        ioException.printStackTrace();
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent e) {
        if (e.world.field_72995_K || e.phase != TickEvent.Phase.END || e.world.field_73011_w.func_186058_p() != DimensionType.OVERWORLD) {
            return;
        }
        TesseractTracker.SERVER.toBeRemoved.forEach(SERVER::removeAndUpdate);
        TesseractTracker.SERVER.toBeRemoved.clear();
    }
}

