/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.models;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.helpers.BiblioEnums;
import jds.bibliocraft.helpers.ModelCache;
import jds.bibliocraft.helpers.PaintingUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class ModelCanvas
implements IBakedModel {
    public static final ModelResourceLocation modelResourceLocation = new ModelResourceLocation("bibliocraft:PaintingCanvas");
    private IBakedModel baseModel;
    List<String> modelParts;
    IModel model = null;
    private String paintingTitle = "blank";
    private int paintingType = 0;
    private BiblioEnums.EnumBiblioPaintings[] biblioArtList = BiblioEnums.EnumBiblioPaintings.values();
    private EntityPainting.EnumArt[] vanillaArtList = EntityPainting.EnumArt.values();
    private BufferBuilder worldRenderer;
    public Tessellator tessellator;
    private CustomItemOverrideList overrides = new CustomItemOverrideList();
    public IBakedModel wrapper;
    private ModelCache cache;
    private boolean gotOBJ = false;
    protected Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

        public TextureAtlasSprite apply(ResourceLocation location) {
            String output = location.toString();
            if (!ModelCanvas.this.paintingTitle.contains("blank") && output.contains("bibliocraft:paintings/canvas")) {
                switch (ModelCanvas.this.paintingType) {
                    case 0: {
                        for (int i = 0; i < ModelCanvas.this.biblioArtList.length; ++i) {
                            if (!ModelCanvas.this.paintingTitle.contentEquals(((ModelCanvas)ModelCanvas.this).biblioArtList[i].title)) continue;
                            output = ((ModelCanvas)ModelCanvas.this).biblioArtList[i].paintingTexturesStrings[0][0];
                        }
                        break;
                    }
                    case 1: {
                        output = "bibliocraft:paintings/vanilla";
                        break;
                    }
                    case 2: {
                        if (PaintingUtil.customArtNames == null || PaintingUtil.customArtNames.length <= 0 || PaintingUtil.customArtResources == null) break;
                        for (int i = 0; i < PaintingUtil.customArtNames.length; ++i) {
                            if (!ModelCanvas.this.paintingTitle.contentEquals(PaintingUtil.customArtNames[i])) continue;
                            output = PaintingUtil.customArtHeights[i] == PaintingUtil.customArtWidths[i] ? PaintingUtil.customArtResourceStrings[i] : "bibliocraft:paintings/custom";
                        }
                        break;
                    }
                }
            }
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(output);
        }
    };

    public ModelCanvas(IBakedModel model) {
        this.baseModel = model;
        this.modelParts = new ArrayList<String>();
        this.modelParts.add("canvas");
        this.modelParts.add("painting");
        this.wrapper = this;
        this.cache = new ModelCache();
    }

    private void renderVanillaPainting(float i, float j, float k) {
        for (int x = 0; x < this.vanillaArtList.length; ++x) {
            if (!this.paintingTitle.contentEquals(this.vanillaArtList[x].field_75702_A)) continue;
            float x1 = (float)this.vanillaArtList[x].field_75699_D / 256.0f;
            float x2 = (float)(this.vanillaArtList[x].field_75699_D + this.vanillaArtList[x].field_75703_B) / 256.0f;
            float y1 = (float)this.vanillaArtList[x].field_75700_E / 256.0f;
            float y2 = (float)(this.vanillaArtList[x].field_75700_E + this.vanillaArtList[x].field_75704_C) / 256.0f;
            this.worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            this.worldRenderer.func_181662_b(0.035, -0.4, -0.4).func_187315_a((double)x2, (double)y2);
            this.worldRenderer.func_181662_b(0.035, 0.4, -0.4).func_187315_a((double)x2, (double)y1);
            this.worldRenderer.func_181662_b(0.035, 0.4, 0.4).func_187315_a((double)x1, (double)y1);
            this.worldRenderer.func_181662_b(0.035, -0.4, 0.4).func_187315_a((double)x1, (double)y2);
            this.tessellator.func_78381_a();
        }
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        TRSRTransformation transform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
        switch (cameraTransformType) {
            case FIRST_PERSON_RIGHT_HAND: {
                transform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, -0.1f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f));
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: {
                transform = new TRSRTransformation(new Vector3f(-0.1f, 0.18f, 0.22f), new Quat4f(0.0f, -1.75f, 0.0f, 1.0f), new Vector3f(0.5f, 0.5f, 0.5f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case THIRD_PERSON_LEFT_HAND: {
                transform = new TRSRTransformation(new Vector3f(-0.1f, 0.18f, 0.22f), new Quat4f(0.0f, 0.75f, 0.0f, 1.0f), new Vector3f(0.5f, 0.5f, 0.5f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case GUI: {
                transform = new TRSRTransformation(new Vector3f(0.33f, -0.0f, 0.0f), new Quat4f(0.0f, -0.5f, 0.0f, 1.0f), new Vector3f(1.1f, 1.1f, 1.1f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case GROUND: {
                transform = new TRSRTransformation(new Vector3f(0.25f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(0.5f, 0.5f, 0.5f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case FIXED: {
                transform = new TRSRTransformation(new Vector3f(0.0f, -0.05f, -0.5f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case NONE: {
                transform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
            }
        }
        return Pair.of((Object)this, (Object)transform.getMatrix());
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        try {
            return this.baseModel.func_177554_e();
        }
        catch (NullPointerException e) {
            return Minecraft.func_71410_x().func_147117_R().func_110572_b("minecraft:blocks/planks_oak");
        }
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public boolean func_177555_b() {
        return false;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        try {
            List q = this.baseModel.func_188616_a(state, side, rand);
            return q;
        }
        catch (NullPointerException e) {
            return new ArrayList<BakedQuad>();
        }
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    private class CustomItemOverrideList
    extends ItemOverrideList {
        private CustomItemOverrideList() {
            super((List)ImmutableList.of());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nonnull World world, @Nonnull EntityLivingBase entity) {
            NBTTagCompound tags;
            if (ModelCanvas.this.tessellator == null || ModelCanvas.this.worldRenderer == null) {
                ModelCanvas.this.tessellator = Tessellator.func_178181_a();
                ModelCanvas.this.worldRenderer = ModelCanvas.this.tessellator.func_178180_c();
            }
            if ((tags = stack.func_77978_p()) != null && tags.func_74764_b("paintingTitle") && tags.func_74764_b("paintingType")) {
                ModelCanvas.this.paintingTitle = tags.func_74779_i("paintingTitle");
                ModelCanvas.this.paintingType = tags.func_74762_e("paintingType");
            } else {
                ModelCanvas.this.paintingTitle = "blank";
            }
            if (ModelCanvas.this.model == null || ModelCanvas.this.model != null && !ModelCanvas.this.model.toString().contains("obj.OBJModel")) {
                try {
                    ModelCanvas.this.model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("bibliocraft:item/canvas.obj"));
                    ModelCanvas.this.model = ModelCanvas.this.model.process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
                    ModelCanvas.this.gotOBJ = true;
                }
                catch (Exception e) {
                    ModelCanvas.this.model = ModelLoaderRegistry.getMissingModel();
                    ModelCanvas.this.gotOBJ = false;
                }
            }
            TRSRTransformation transform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
            OBJModel.OBJState partList = new OBJModel.OBJState(ModelCanvas.this.modelParts, true, (IModelState)transform);
            if (ModelCanvas.this.cache.hasModel(ModelCanvas.this.paintingTitle)) {
                ModelCanvas.this.baseModel = ModelCanvas.this.cache.getCurrentMatch();
            } else {
                IBakedModel bakedModel = ModelCanvas.this.model.bake((IModelState)partList, DefaultVertexFormats.field_176599_b, ModelCanvas.this.textureGetter);
                if (ModelCanvas.this.gotOBJ) {
                    ModelCanvas.this.cache.addToCache(bakedModel, ModelCanvas.this.paintingTitle);
                }
                ModelCanvas.this.baseModel = bakedModel;
            }
            return ModelCanvas.this.wrapper;
        }
    }
}

