/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.tileentities;

import jds.bibliocraft.containers.ContainerFancyWorkbench;
import jds.bibliocraft.items.ItemRecipeBook;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;

public class TileEntityFancyWorkbench
extends BiblioTileEntity {
    private NonNullList<ItemStack> playerGrid;
    private NonNullList<ItemStack> bookGrid;
    private ContainerFancyWorkbench[] container = new ContainerFancyWorkbench[8];
    private int[] playerIDs = new int[8];
    public int[] bookCheck = new int[8];
    public int angle;
    public int showText = -1;
    public boolean islocked = false;
    public String lockee = "";
    public String customTex = "none";
    public ResourceLocation customTexture = null;

    public TileEntityFancyWorkbench() {
        super(9, true);
        this.playerGrid = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        this.bookGrid = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    }

    public void setShowText(int textnum) {
        this.showText = textnum;
    }

    public int getShowText() {
        return this.showText;
    }

    public int[] getBookArray() {
        return this.bookCheck;
    }

    public void setPlayerGrid(NonNullList<ItemStack> grid) {
        this.playerGrid = grid;
    }

    public boolean isTooManyPlayers() {
        return this.playerIDs[7] != 0 & this.container[7] != null;
    }

    public void setBookGrid(int id) {
        int arrayid = -1;
        for (int n = 0; n < 8; ++n) {
            if (this.playerIDs[n] != id) continue;
            arrayid = n;
            break;
        }
        if (arrayid == -1 || this.container[arrayid] == null) {
            return;
        }
        if (this.func_70301_a(0) != ItemStack.field_190927_a && (this.func_70301_a(0).func_77973_b() == Items.field_151122_aG || this.func_70301_a(0).func_77973_b() instanceof ItemRecipeBook)) {
            this.func_70299_a(0, ItemStack.field_190927_a);
            ItemStack recipeBook = new ItemStack((Item)ItemRecipeBook.instance, 1, 0);
            NBTTagCompound nbt = new NBTTagCompound();
            NBTTagList itemList = new NBTTagList();
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = (ItemStack)this.playerGrid.get(i);
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("Slot", (byte)i);
                stack.func_77955_b(tag);
                itemList.func_74742_a((NBTBase)tag);
            }
            nbt.func_74782_a("grid", (NBTBase)itemList);
            ItemStack result = this.container[arrayid].craftResult.func_70301_a(0);
            if (result != ItemStack.field_190927_a) {
                NBTTagCompound display = new NBTTagCompound();
                display.func_74778_a("Name", TextFormatting.WHITE + I18n.func_74838_a((String)"book.setrecipename") + " " + result.func_82833_r());
                nbt.func_74782_a("display", (NBTBase)display);
                NBTTagCompound resultTag = new NBTTagCompound();
                result.func_77955_b(resultTag);
                nbt.func_74782_a("result", (NBTBase)resultTag);
            }
            recipeBook.func_77982_d(nbt);
            this.func_70299_a(0, recipeBook);
            for (int i = 0; i < this.playerGrid.size(); ++i) {
                this.bookGrid.set(i, this.playerGrid.get(i));
            }
        }
    }

    public NonNullList<ItemStack> getPlayerGrid() {
        return this.playerGrid;
    }

    public NonNullList<ItemStack> getBookGrid() {
        return this.bookGrid;
    }

    public void setContainer(ContainerFancyWorkbench bench, int id) {
        for (int n = 0; n < 8; ++n) {
            if (this.container[n] != null) continue;
            this.container[n] = bench;
            this.playerIDs[n] = id;
            break;
        }
    }

    public void clearContainer(int id) {
        for (int n = 0; n < 8; ++n) {
            if (this.playerIDs[n] != id) continue;
            this.playerIDs[n] = 0;
            this.container[n] = null;
        }
    }

    public void loadInvToGridForRecipe(int playerid) {
        if (this.container != null && this.func_70301_a(0) != null && this.func_70301_a(0).func_77973_b() instanceof ItemRecipeBook) {
            for (int n = 0; n < 8; ++n) {
                if (this.playerIDs[n] != playerid || this.container[n] == null) continue;
                this.readBookMatrix(this.func_70301_a(0));
                this.container[n].loadPlayerInventorytoRecipeBookGrid(this.bookGrid, playerid);
            }
        }
    }

    private void readBookMatrix(ItemStack stack) {
        NBTTagCompound nbt;
        if (stack.func_77973_b() instanceof ItemRecipeBook && (nbt = stack.func_77978_p()) != null) {
            NBTTagList tagList = nbt.func_150295_c("grid", 10);
            this.bookGrid = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
            for (int i = 0; i < 9; ++i) {
                ItemStack nbtStack;
                NBTTagCompound tag = tagList.func_150305_b(i);
                byte slot = tag.func_74771_c("Slot");
                if (slot < 0 || slot >= 9 || (nbtStack = new ItemStack(tag)) == ItemStack.field_190927_a) continue;
                this.bookGrid.set((int)slot, (Object)nbtStack);
            }
        }
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return false;
    }

    public String func_70005_c_() {
        return "FancyWorkbench";
    }

    @Override
    public void setInventorySlotContentsAdditionalCommands(int slot, ItemStack stack) {
        if (slot > 0 && slot < 10) {
            this.bookCheck[slot - 1] = this.func_70301_a(slot) != ItemStack.field_190927_a && stack.func_77973_b() != Items.field_190931_a ? 1 : 0;
        }
        if (this.container != null && slot == 0) {
            if (stack != ItemStack.field_190927_a && stack.func_77973_b() instanceof ItemRecipeBook) {
                this.readBookMatrix(stack);
            } else {
                for (int n = 0; n < 9; ++n) {
                    this.bookGrid.set(n, (Object)ItemStack.field_190927_a);
                }
            }
        }
    }

    @Override
    public void loadCustomNBTData(NBTTagCompound nbt) {
        this.bookCheck = nbt.func_74759_k("books");
    }

    @Override
    public NBTTagCompound writeCustomNBTData(NBTTagCompound nbt) {
        nbt.func_74783_a("books", this.bookCheck);
        return nbt;
    }

    public ITextComponent func_145748_c_() {
        TextComponentString chat = new TextComponentString(this.func_70005_c_());
        return chat;
    }
}

