/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.rwtema.extrautils2.backend.IXUItem;
import com.rwtema.extrautils2.backend.model.PassthruModelItem;
import com.rwtema.extrautils2.backend.model.Textures;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class XUItemFood
extends ItemFood
implements IXUItem {
    final String texture;
    @SideOnly(value=Side.CLIENT)
    TextureAtlasSprite sprite;

    public XUItemFood(int amount, float saturation, boolean isWolfFood, String texture) {
        super(amount, saturation, isWolfFood);
        this.texture = texture;
    }

    @OverridingMethodsMustInvokeSuper
    protected void func_77849_c(ItemStack stack, World worldIn, @Nonnull EntityPlayer player) {
        super.func_77849_c(stack, worldIn, player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        Textures.register(this.texture);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBakedModel createModel(int metadata) {
        return new PassthruModelItem(this);
    }

    @Override
    public TextureAtlasSprite getBaseTexture() {
        return this.sprite;
    }

    @Override
    public void addQuads(PassthruModelItem.ModelLayer model, ItemStack stack, World world, EntityLivingBase entity) {
        model.addTintedSprite(this.sprite, true, -1);
    }

    @Override
    public void postTextureRegister() {
        this.sprite = Textures.getSprite(this.texture);
    }

    @Override
    public boolean renderAsTool() {
        return false;
    }

    @Override
    public void clearCaches() {
        this.sprite = null;
    }

    @Override
    public boolean allowOverride() {
        return true;
    }

    @Override
    public int getMaxMetadata() {
        return 0;
    }
}

