/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridCraftingListener;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridNetworkAware;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridTab;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.IFilter;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageCacheListenerGridFluid;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageCacheListenerGridItem;
import com.raoulvdberge.refinedstorage.block.BlockGrid;
import com.raoulvdberge.refinedstorage.inventory.fluid.FluidInventory;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerFilter;
import com.raoulvdberge.refinedstorage.inventory.item.validator.ItemValidatorBasic;
import com.raoulvdberge.refinedstorage.inventory.listener.ListenerNetworkNode;
import com.raoulvdberge.refinedstorage.item.ItemPattern;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.tile.data.TileDataManager;
import com.raoulvdberge.refinedstorage.tile.grid.TileGrid;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class NetworkNodeGrid
extends NetworkNode
implements IGridNetworkAware,
IType {
    public static final String ID = "grid";
    public static int FACTORY_ID = 0;
    public static final String NBT_VIEW_TYPE = "ViewType";
    public static final String NBT_SORTING_DIRECTION = "SortingDirection";
    public static final String NBT_SORTING_TYPE = "SortingType";
    public static final String NBT_SEARCH_BOX_MODE = "SearchBoxMode";
    private static final String NBT_OREDICT_PATTERN = "OredictPattern";
    public static final String NBT_TAB_SELECTED = "TabSelected";
    public static final String NBT_TAB_PAGE = "TabPage";
    public static final String NBT_SIZE = "Size";
    private static final String NBT_PROCESSING_PATTERN = "ProcessingPattern";
    private static final String NBT_PROCESSING_TYPE = "ProcessingType";
    private static final String NBT_PROCESSING_MATRIX_FLUIDS = "ProcessingMatrixFluids";
    private Container craftingContainer = new Container(){

        public boolean func_75145_c(EntityPlayer player) {
            return false;
        }

        public void func_75130_a(IInventory inventory) {
            if (!NetworkNodeGrid.this.world.field_72995_K) {
                NetworkNodeGrid.this.onCraftingMatrixChanged();
            }
        }
    };
    private IRecipe currentRecipe;
    private InventoryCrafting matrix = new InventoryCrafting(this.craftingContainer, 3, 3);
    private InventoryCraftResult result = new InventoryCraftResult();
    private ItemHandlerBase processingMatrix = new ItemHandlerBase(18, new ListenerNetworkNode(this), new Predicate[0]);
    private FluidInventory processingMatrixFluids = new FluidInventory(18, 64000, new ListenerNetworkNode(this));
    private Set<IGridCraftingListener> craftingListeners = new HashSet<IGridCraftingListener>();
    private ItemHandlerBase patterns = new ItemHandlerBase(2, new ListenerNetworkNode(this), new Predicate[]{new ItemValidatorBasic(RSItems.PATTERN)}){

        @Override
        protected void onContentsChanged(int slot) {
            block3: {
                boolean isPatternProcessing;
                ItemStack pattern;
                block4: {
                    int i;
                    super.onContentsChanged(slot);
                    pattern = this.getStackInSlot(slot);
                    if (slot != 1 || pattern.func_190926_b()) break block3;
                    isPatternProcessing = ItemPattern.isProcessing(pattern);
                    if (!isPatternProcessing || !NetworkNodeGrid.this.isProcessingPattern()) break block4;
                    for (i = 0; i < 9; ++i) {
                        NetworkNodeGrid.this.processingMatrix.setStackInSlot(i, StackUtils.nullToEmpty(ItemPattern.getInputSlot(pattern, i)));
                        NetworkNodeGrid.this.processingMatrixFluids.setFluid(i, ItemPattern.getFluidInputSlot(pattern, i));
                    }
                    for (i = 0; i < 9; ++i) {
                        NetworkNodeGrid.this.processingMatrix.setStackInSlot(9 + i, StackUtils.nullToEmpty(ItemPattern.getOutputSlot(pattern, i)));
                        NetworkNodeGrid.this.processingMatrixFluids.setFluid(9 + i, ItemPattern.getFluidOutputSlot(pattern, i));
                    }
                    break block3;
                }
                if (isPatternProcessing || NetworkNodeGrid.this.isProcessingPattern()) break block3;
                for (int i = 0; i < 9; ++i) {
                    NetworkNodeGrid.this.matrix.func_70299_a(i, StackUtils.nullToEmpty(ItemPattern.getInputSlot(pattern, i)));
                }
            }
        }

        public int getSlotLimit(int slot) {
            return slot == 1 ? 1 : super.getSlotLimit(slot);
        }

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (slot == 0 || stack.func_77978_p() != null) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    };
    private List<IFilter> filters = new ArrayList<IFilter>();
    private List<IGridTab> tabs = new ArrayList<IGridTab>();
    private ItemHandlerFilter filter = new ItemHandlerFilter(this.filters, this.tabs, new ListenerNetworkNode(this));
    private GridType type;
    private int viewType = 0;
    private int sortingDirection = 1;
    private int sortingType = 0;
    private int searchBoxMode = 0;
    private int size = 0;
    private int tabSelected = -1;
    private int tabPage = 0;
    private boolean oredictPattern = false;
    private boolean processingPattern = false;
    private int processingType = 0;

    public NetworkNodeGrid(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        switch (this.getGridType()) {
            case NORMAL: {
                return RS.INSTANCE.config.gridUsage;
            }
            case CRAFTING: {
                return RS.INSTANCE.config.craftingGridUsage;
            }
            case PATTERN: {
                return RS.INSTANCE.config.patternGridUsage;
            }
            case FLUID: {
                return RS.INSTANCE.config.fluidGridUsage;
            }
        }
        return 0;
    }

    public void setViewType(int viewType) {
        this.viewType = viewType;
    }

    public void setSortingDirection(int sortingDirection) {
        this.sortingDirection = sortingDirection;
    }

    public void setSortingType(int sortingType) {
        this.sortingType = sortingType;
    }

    public void setSearchBoxMode(int searchBoxMode) {
        this.searchBoxMode = searchBoxMode;
    }

    public void setTabSelected(int tabSelected) {
        this.tabSelected = tabSelected;
    }

    public void setTabPage(int page) {
        this.tabPage = page;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public boolean isOredictPattern() {
        return this.oredictPattern;
    }

    public void setOredictPattern(boolean oredictPattern) {
        this.oredictPattern = oredictPattern;
    }

    public boolean isProcessingPattern() {
        return this.world.field_72995_K ? TileGrid.PROCESSING_PATTERN.getValue() : this.processingPattern;
    }

    public void setProcessingPattern(boolean processingPattern) {
        this.processingPattern = processingPattern;
    }

    @Override
    public GridType getGridType() {
        IBlockState state;
        if (this.type == null && (state = this.world.func_180495_p(this.pos)).func_177230_c() == RSBlocks.GRID) {
            this.type = (GridType)((Object)state.func_177229_b((IProperty)BlockGrid.TYPE));
        }
        return this.type == null ? GridType.NORMAL : this.type;
    }

    @Override
    public IStorageCacheListener createListener(EntityPlayerMP player) {
        return this.getGridType() == GridType.FLUID ? new StorageCacheListenerGridFluid(player, this.network) : new StorageCacheListenerGridItem(player, this.network);
    }

    @Override
    @Nullable
    public IStorageCache getStorageCache() {
        return this.network != null ? (this.getGridType() == GridType.FLUID ? this.network.getFluidStorageCache() : this.network.getItemStorageCache()) : null;
    }

    @Override
    @Nullable
    public IItemGridHandler getItemHandler() {
        return this.network != null ? this.network.getItemGridHandler() : null;
    }

    @Override
    @Nullable
    public IFluidGridHandler getFluidHandler() {
        return this.network != null ? this.network.getFluidGridHandler() : null;
    }

    @Override
    public void addCraftingListener(IGridCraftingListener listener) {
        this.craftingListeners.add(listener);
    }

    @Override
    public void removeCraftingListener(IGridCraftingListener listener) {
        this.craftingListeners.remove(listener);
    }

    @Override
    public String getGuiTitle() {
        GridType type = this.getGridType();
        switch (type) {
            case CRAFTING: {
                return "gui.refinedstorage:crafting_grid";
            }
            case PATTERN: {
                return "gui.refinedstorage:pattern_grid";
            }
            case FLUID: {
                return "gui.refinedstorage:fluid_grid";
            }
        }
        return "gui.refinedstorage:grid";
    }

    public IItemHandler getPatterns() {
        return this.patterns;
    }

    @Override
    public IItemHandlerModifiable getFilter() {
        return this.filter;
    }

    @Override
    public List<IFilter> getFilters() {
        return this.filters;
    }

    @Override
    public List<IGridTab> getTabs() {
        return this.tabs;
    }

    @Override
    public InventoryCrafting getCraftingMatrix() {
        return this.matrix;
    }

    @Override
    public InventoryCraftResult getCraftingResult() {
        return this.result;
    }

    public ItemHandlerBase getProcessingMatrix() {
        return this.processingMatrix;
    }

    public FluidInventory getProcessingMatrixFluids() {
        return this.processingMatrixFluids;
    }

    @Override
    public void onCraftingMatrixChanged() {
        if (this.currentRecipe == null || !this.currentRecipe.func_77569_a(this.matrix, this.world)) {
            this.currentRecipe = CraftingManager.func_192413_b((InventoryCrafting)this.matrix, (World)this.world);
        }
        if (this.currentRecipe == null) {
            this.result.func_70299_a(0, ItemStack.field_190927_a);
        } else {
            this.result.func_70299_a(0, this.currentRecipe.func_77572_b(this.matrix));
        }
        this.craftingListeners.forEach(IGridCraftingListener::onCraftingMatrixChanged);
        this.markDirty();
    }

    @Override
    public void onRecipeTransfer(EntityPlayer player, ItemStack[][] recipe) {
        NetworkNodeGrid.onRecipeTransfer(this, player, recipe);
    }

    public static void onRecipeTransfer(IGridNetworkAware grid, EntityPlayer player, ItemStack[][] recipe) {
        int i;
        INetwork network = grid.getNetwork();
        if (network != null && grid.getGridType() == GridType.CRAFTING && !network.getSecurityManager().hasPermission(Permission.EXTRACT, player)) {
            return;
        }
        for (i = 0; i < grid.getCraftingMatrix().func_70302_i_(); ++i) {
            ItemStack slot = grid.getCraftingMatrix().func_70301_a(i);
            if (slot.func_190926_b()) continue;
            if (grid.getGridType() == GridType.CRAFTING) {
                if (network != null) {
                    if (network.insertItem(slot, slot.func_190916_E(), Action.SIMULATE) != null) {
                        return;
                    }
                    network.insertItem(slot, slot.func_190916_E(), Action.PERFORM);
                    network.getItemStorageTracker().changed(player, slot.func_77946_l());
                } else if (!player.field_71071_by.func_70441_a(slot.func_77946_l())) {
                    return;
                }
            }
            grid.getCraftingMatrix().func_70299_a(i, ItemStack.field_190927_a);
        }
        block1: for (i = 0; i < grid.getCraftingMatrix().func_70302_i_(); ++i) {
            if (recipe[i] == null) continue;
            ItemStack[] possibilities = recipe[i];
            if (grid.getGridType() == GridType.CRAFTING) {
                boolean found = false;
                if (network != null) {
                    ItemStack[] itemStackArray = possibilities;
                    int n = itemStackArray.length;
                    for (int j = 0; j < n; ++j) {
                        ItemStack possibility;
                        ItemStack took = network.extractItem(possibility, 1, 2 | ((possibility = itemStackArray[j]).func_77973_b().func_77645_m() ? 0 : 1), Action.PERFORM);
                        if (took == null) continue;
                        grid.getCraftingMatrix().func_70299_a(i, StackUtils.nullToEmpty(took));
                        network.getItemStorageTracker().changed(player, took.func_77946_l());
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                for (ItemStack possibility : possibilities) {
                    for (int j = 0; j < player.field_71071_by.func_70302_i_(); ++j) {
                        if (!API.instance().getComparer().isEqual(possibility, player.field_71071_by.func_70301_a(j), 2 | (possibility.func_77973_b().func_77645_m() ? 0 : 1))) continue;
                        grid.getCraftingMatrix().func_70299_a(i, ItemHandlerHelper.copyStackWithSize((ItemStack)player.field_71071_by.func_70301_a(j), (int)1));
                        player.field_71071_by.func_70298_a(j, 1);
                        found = true;
                        break;
                    }
                    if (found) continue block1;
                }
                continue;
            }
            if (grid.getGridType() != GridType.PATTERN) continue;
            grid.getCraftingMatrix().func_70299_a(i, possibilities.length == 0 ? ItemStack.field_190927_a : possibilities[0]);
        }
    }

    public void clearMatrix() {
        int i;
        for (i = 0; i < this.processingMatrix.getSlots(); ++i) {
            this.processingMatrix.setStackInSlot(i, ItemStack.field_190927_a);
        }
        for (i = 0; i < this.processingMatrixFluids.getSlots(); ++i) {
            this.processingMatrixFluids.setFluid(i, null);
        }
        for (i = 0; i < this.matrix.func_70302_i_(); ++i) {
            this.matrix.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    @Override
    public void onClosed(EntityPlayer player) {
    }

    @Override
    public int getSlotId() {
        return -1;
    }

    @Override
    public void onCrafted(EntityPlayer player) {
        NetworkNodeGrid.onCrafted(this, this.world, player);
    }

    public static void onCrafted(IGridNetworkAware grid, World world, EntityPlayer player) {
        NonNullList remainder = CraftingManager.func_180303_b((InventoryCrafting)grid.getCraftingMatrix(), (World)world);
        INetwork network = grid.getNetwork();
        InventoryCrafting matrix = grid.getCraftingMatrix();
        for (int i = 0; i < grid.getCraftingMatrix().func_70302_i_(); ++i) {
            ItemStack slot = matrix.func_70301_a(i);
            if (i < remainder.size() && !((ItemStack)remainder.get(i)).func_190926_b()) {
                if (!slot.func_190926_b() && slot.func_190916_E() > 1) {
                    if (!player.field_71071_by.func_70441_a(((ItemStack)remainder.get(i)).func_77946_l())) {
                        ItemStack remainderStack;
                        ItemStack itemStack = remainderStack = network == null ? ((ItemStack)remainder.get(i)).func_77946_l() : network.insertItem(((ItemStack)remainder.get(i)).func_77946_l(), ((ItemStack)remainder.get(i)).func_190916_E(), Action.PERFORM);
                        if (remainderStack != null) {
                            InventoryHelper.func_180173_a((World)player.func_130014_f_(), (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)remainderStack);
                        }
                    }
                    matrix.func_70298_a(i, 1);
                    continue;
                }
                matrix.func_70299_a(i, ((ItemStack)remainder.get(i)).func_77946_l());
                continue;
            }
            if (slot.func_190926_b()) continue;
            if (slot.func_190916_E() == 1 && network != null) {
                ItemStack refill = StackUtils.nullToEmpty(network.extractItem(slot, 1, Action.PERFORM));
                matrix.func_70299_a(i, refill);
                if (refill.func_190926_b()) continue;
                network.getItemStorageTracker().changed(player, refill.func_77946_l());
                continue;
            }
            matrix.func_70298_a(i, 1);
        }
        grid.onCraftingMatrixChanged();
    }

    @Override
    public void onCraftedShift(EntityPlayer player) {
        NetworkNodeGrid.onCraftedShift(this, player);
    }

    public static void onCraftedShift(IGridNetworkAware grid, EntityPlayer player) {
        ArrayList<ItemStack> craftedItemsList = new ArrayList<ItemStack>();
        int craftedItems = 0;
        ItemStack crafted = grid.getCraftingResult().func_70301_a(0);
        do {
            grid.onCrafted(player);
            craftedItemsList.add(crafted.func_77946_l());
        } while (API.instance().getComparer().isEqual(crafted, grid.getCraftingResult().func_70301_a(0)) && (craftedItems += crafted.func_190916_E()) + crafted.func_190916_E() <= crafted.func_77976_d());
        INetwork network = grid.getNetwork();
        for (ItemStack craftedItem : craftedItemsList) {
            ItemStack remainder;
            if (player.field_71071_by.func_70441_a(craftedItem.func_77946_l()) || (remainder = network == null ? craftedItem : network.insertItem(craftedItem, craftedItem.func_190916_E(), Action.PERFORM)) == null) continue;
            InventoryHelper.func_180173_a((World)player.func_130014_f_(), (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)remainder);
        }
        FMLCommonHandler.instance().firePlayerCraftingEvent(player, ItemHandlerHelper.copyStackWithSize((ItemStack)crafted, (int)craftedItems), (IInventory)grid.getCraftingMatrix());
    }

    public void onCreatePattern() {
        if (this.canCreatePattern()) {
            if (this.patterns.getStackInSlot(1).func_190926_b()) {
                this.patterns.extractItem(0, 1, false);
            }
            ItemStack pattern = new ItemStack((Item)RSItems.PATTERN);
            ItemPattern.setVersion(pattern);
            ItemPattern.setOredict(pattern, this.oredictPattern);
            ItemPattern.setProcessing(pattern, this.processingPattern);
            if (this.processingPattern) {
                for (int i = 0; i < 18; ++i) {
                    FluidStack fluid;
                    if (!this.processingMatrix.getStackInSlot(i).func_190926_b()) {
                        if (i >= 9) {
                            ItemPattern.setOutputSlot(pattern, i - 9, this.processingMatrix.getStackInSlot(i));
                        } else {
                            ItemPattern.setInputSlot(pattern, i, this.processingMatrix.getStackInSlot(i));
                        }
                    }
                    if ((fluid = this.processingMatrixFluids.getFluid(i)) == null) continue;
                    if (i >= 9) {
                        ItemPattern.setFluidOutputSlot(pattern, i - 9, fluid);
                        continue;
                    }
                    ItemPattern.setFluidInputSlot(pattern, i, fluid);
                }
            } else {
                for (int i = 0; i < 9; ++i) {
                    ItemStack ingredient = this.matrix.func_70301_a(i);
                    if (ingredient.func_190926_b()) continue;
                    ItemPattern.setInputSlot(pattern, i, ingredient);
                }
            }
            this.patterns.setStackInSlot(1, pattern);
        }
    }

    private boolean isPatternAvailable() {
        return !this.patterns.getStackInSlot(0).func_190926_b() || !this.patterns.getStackInSlot(1).func_190926_b();
    }

    public boolean canCreatePattern() {
        if (!this.isPatternAvailable()) {
            return false;
        }
        if (this.isProcessingPattern()) {
            int i;
            int inputsFilled = 0;
            int outputsFilled = 0;
            for (i = 0; i < 9; ++i) {
                if (!this.processingMatrix.getStackInSlot(i).func_190926_b()) {
                    ++inputsFilled;
                }
                if (this.processingMatrixFluids.getFluid(i) == null) continue;
                ++inputsFilled;
            }
            for (i = 9; i < 18; ++i) {
                if (!this.processingMatrix.getStackInSlot(i).func_190926_b()) {
                    ++outputsFilled;
                }
                if (this.processingMatrixFluids.getFluid(i) == null) continue;
                ++outputsFilled;
            }
            return inputsFilled > 0 && outputsFilled > 0;
        }
        return !this.result.func_70301_a(0).func_190926_b() && this.isPatternAvailable();
    }

    @Override
    public int getViewType() {
        return this.world.field_72995_K ? TileGrid.VIEW_TYPE.getValue() : this.viewType;
    }

    @Override
    public int getSortingDirection() {
        return this.world.field_72995_K ? TileGrid.SORTING_DIRECTION.getValue() : this.sortingDirection;
    }

    @Override
    public int getSortingType() {
        return this.world.field_72995_K ? TileGrid.SORTING_TYPE.getValue() : this.sortingType;
    }

    @Override
    public int getSearchBoxMode() {
        return this.world.field_72995_K ? TileGrid.SEARCH_BOX_MODE.getValue() : this.searchBoxMode;
    }

    @Override
    public int getSize() {
        return this.world.field_72995_K ? TileGrid.SIZE.getValue() : this.size;
    }

    @Override
    public int getTabSelected() {
        return this.world.field_72995_K ? TileGrid.TAB_SELECTED.getValue() : this.tabSelected;
    }

    @Override
    public int getTabPage() {
        return this.world.field_72995_K ? TileGrid.TAB_PAGE.getValue() : Math.min(this.tabPage, this.getTotalTabPages());
    }

    @Override
    public int getTotalTabPages() {
        return (int)Math.floor((float)Math.max(0, this.tabs.size() - 1) / 5.0f);
    }

    @Override
    public void onViewTypeChanged(int type) {
        TileDataManager.setParameter(TileGrid.VIEW_TYPE, type);
    }

    @Override
    public void onSortingTypeChanged(int type) {
        TileDataManager.setParameter(TileGrid.SORTING_TYPE, type);
    }

    @Override
    public void onSortingDirectionChanged(int direction) {
        TileDataManager.setParameter(TileGrid.SORTING_DIRECTION, direction);
    }

    @Override
    public void onSearchBoxModeChanged(int searchBoxMode) {
        TileDataManager.setParameter(TileGrid.SEARCH_BOX_MODE, searchBoxMode);
    }

    @Override
    public void onSizeChanged(int size) {
        TileDataManager.setParameter(TileGrid.SIZE, size);
    }

    @Override
    public void onTabSelectionChanged(int tab) {
        TileDataManager.setParameter(TileGrid.TAB_SELECTED, tab);
    }

    @Override
    public void onTabPageChanged(int page) {
        if (page >= 0 && page <= this.getTotalTabPages()) {
            TileDataManager.setParameter(TileGrid.TAB_PAGE, page);
        }
    }

    @Override
    public int getType() {
        return this.world.field_72995_K ? TileGrid.PROCESSING_TYPE.getValue() : this.processingType;
    }

    @Override
    public void setType(int type) {
        this.processingType = type;
        this.markDirty();
    }

    @Override
    public IItemHandlerModifiable getItemFilters() {
        return this.processingMatrix;
    }

    @Override
    public FluidInventory getFluidFilters() {
        return this.processingMatrixFluids;
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IInventory)this.matrix, 0, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.patterns, 1, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.filter, 2, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.processingMatrix, 3, tag);
        if (tag.func_74764_b(NBT_PROCESSING_MATRIX_FLUIDS)) {
            this.processingMatrixFluids.readFromNbt(tag.func_74775_l(NBT_PROCESSING_MATRIX_FLUIDS));
        }
        if (tag.func_74764_b(NBT_TAB_SELECTED)) {
            this.tabSelected = tag.func_74762_e(NBT_TAB_SELECTED);
        }
        if (tag.func_74764_b(NBT_TAB_PAGE)) {
            this.tabPage = tag.func_74762_e(NBT_TAB_PAGE);
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IInventory)this.matrix, 0, tag);
        StackUtils.writeItems((IItemHandler)this.patterns, 1, tag);
        StackUtils.writeItems((IItemHandler)this.filter, 2, tag);
        StackUtils.writeItems((IItemHandler)this.processingMatrix, 3, tag);
        tag.func_74782_a(NBT_PROCESSING_MATRIX_FLUIDS, (NBTBase)this.processingMatrixFluids.writeToNbt());
        tag.func_74768_a(NBT_TAB_SELECTED, this.tabSelected);
        tag.func_74768_a(NBT_TAB_PAGE, this.tabPage);
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_VIEW_TYPE, this.viewType);
        tag.func_74768_a(NBT_SORTING_DIRECTION, this.sortingDirection);
        tag.func_74768_a(NBT_SORTING_TYPE, this.sortingType);
        tag.func_74768_a(NBT_SEARCH_BOX_MODE, this.searchBoxMode);
        tag.func_74768_a(NBT_SIZE, this.size);
        tag.func_74757_a(NBT_OREDICT_PATTERN, this.oredictPattern);
        tag.func_74757_a(NBT_PROCESSING_PATTERN, this.processingPattern);
        tag.func_74768_a(NBT_PROCESSING_TYPE, this.processingType);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_VIEW_TYPE)) {
            this.viewType = tag.func_74762_e(NBT_VIEW_TYPE);
        }
        if (tag.func_74764_b(NBT_SORTING_DIRECTION)) {
            this.sortingDirection = tag.func_74762_e(NBT_SORTING_DIRECTION);
        }
        if (tag.func_74764_b(NBT_SORTING_TYPE)) {
            this.sortingType = tag.func_74762_e(NBT_SORTING_TYPE);
        }
        if (tag.func_74764_b(NBT_SEARCH_BOX_MODE)) {
            this.searchBoxMode = tag.func_74762_e(NBT_SEARCH_BOX_MODE);
        }
        if (tag.func_74764_b(NBT_SIZE)) {
            this.size = tag.func_74762_e(NBT_SIZE);
        }
        if (tag.func_74764_b(NBT_OREDICT_PATTERN)) {
            this.oredictPattern = tag.func_74767_n(NBT_OREDICT_PATTERN);
        }
        if (tag.func_74764_b(NBT_PROCESSING_PATTERN)) {
            this.processingPattern = tag.func_74767_n(NBT_PROCESSING_PATTERN);
        }
        if (tag.func_74764_b(NBT_PROCESSING_TYPE)) {
            this.processingType = tag.func_74762_e(NBT_PROCESSING_TYPE);
        }
    }

    @Override
    public IItemHandler getDrops() {
        switch (this.getGridType()) {
            case CRAFTING: {
                return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.filter, new InvWrapper((IInventory)this.matrix)});
            }
            case PATTERN: {
                return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.filter, this.patterns});
            }
        }
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.filter});
    }
}

