/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.gui.BaseContainerType;
import com.supermartijn642.core.item.BaseBlockItem;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.network.PacketChannel;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.core.registry.RegistryEntryAcceptor;
import com.supermartijn642.trashcans.TrashCanBlock;
import com.supermartijn642.trashcans.TrashCanBlockEntity;
import com.supermartijn642.trashcans.TrashCansClient;
import com.supermartijn642.trashcans.compat.Compatibility;
import com.supermartijn642.trashcans.filter.FluidFilterManager;
import com.supermartijn642.trashcans.filter.LiquidTrashCanFilters;
import com.supermartijn642.trashcans.generators.TrashCansAdvancementGenerator;
import com.supermartijn642.trashcans.generators.TrashCansBlockStateGenerator;
import com.supermartijn642.trashcans.generators.TrashCansLanguageGenerator;
import com.supermartijn642.trashcans.generators.TrashCansLootTableGenerator;
import com.supermartijn642.trashcans.generators.TrashCansModelGenerator;
import com.supermartijn642.trashcans.generators.TrashCansRecipeGenerator;
import com.supermartijn642.trashcans.generators.TrashCansTagGenerator;
import com.supermartijn642.trashcans.packet.PacketChangeEnergyLimit;
import com.supermartijn642.trashcans.packet.PacketChangeItemFilter;
import com.supermartijn642.trashcans.packet.PacketChangeLiquidFilter;
import com.supermartijn642.trashcans.packet.PacketToggleEnergyLimit;
import com.supermartijn642.trashcans.packet.PacketToggleItemWhitelist;
import com.supermartijn642.trashcans.packet.PacketToggleLiquidWhitelist;
import com.supermartijn642.trashcans.screen.EnergyTrashCanContainer;
import com.supermartijn642.trashcans.screen.ItemTrashCanContainer;
import com.supermartijn642.trashcans.screen.LiquidTrashCanContainer;
import com.supermartijn642.trashcans.screen.TrashCanContainer;
import com.supermartijn642.trashcans.screen.UltimateTrashCanContainer;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;

@Mod(modid="trashcans", name="Trash Cans", version="1.0.16", dependencies="required-after:supermartijn642corelib@@core_library_dependency@")
public class TrashCans {
    public static final PacketChannel CHANNEL = PacketChannel.create((String)"trashcans");
    @RegistryEntryAcceptor(namespace="trashcans", identifier="item_trash_can", registry=RegistryEntryAcceptor.Registry.BLOCKS)
    public static BaseBlock item_trash_can;
    @RegistryEntryAcceptor(namespace="trashcans", identifier="liquid_trash_can", registry=RegistryEntryAcceptor.Registry.BLOCKS)
    public static BaseBlock liquid_trash_can;
    @RegistryEntryAcceptor(namespace="trashcans", identifier="energy_trash_can", registry=RegistryEntryAcceptor.Registry.BLOCKS)
    public static BaseBlock energy_trash_can;
    @RegistryEntryAcceptor(namespace="trashcans", identifier="ultimate_trash_can", registry=RegistryEntryAcceptor.Registry.BLOCKS)
    public static BaseBlock ultimate_trash_can;
    @RegistryEntryAcceptor(namespace="trashcans", identifier="itemtrashcan", registry=RegistryEntryAcceptor.Registry.BLOCK_ENTITY_TYPES)
    public static BaseBlockEntityType<TrashCanBlockEntity> item_trash_can_tile;
    @RegistryEntryAcceptor(namespace="trashcans", identifier="liquidtrashcan", registry=RegistryEntryAcceptor.Registry.BLOCK_ENTITY_TYPES)
    public static BaseBlockEntityType<TrashCanBlockEntity> liquid_trash_can_tile;
    @RegistryEntryAcceptor(namespace="trashcans", identifier="energytrashcan", registry=RegistryEntryAcceptor.Registry.BLOCK_ENTITY_TYPES)
    public static BaseBlockEntityType<TrashCanBlockEntity> energy_trash_can_tile;
    @RegistryEntryAcceptor(namespace="trashcans", identifier="ultimatetrashcan", registry=RegistryEntryAcceptor.Registry.BLOCK_ENTITY_TYPES)
    public static BaseBlockEntityType<TrashCanBlockEntity> ultimate_trash_can_tile;
    @RegistryEntryAcceptor(namespace="trashcans", identifier="item_trash_can_container", registry=RegistryEntryAcceptor.Registry.MENU_TYPES)
    public static BaseContainerType<TrashCanContainer> item_trash_can_container;
    @RegistryEntryAcceptor(namespace="trashcans", identifier="liquid_trash_can_container", registry=RegistryEntryAcceptor.Registry.MENU_TYPES)
    public static BaseContainerType<TrashCanContainer> liquid_trash_can_container;
    @RegistryEntryAcceptor(namespace="trashcans", identifier="energy_trash_can_container", registry=RegistryEntryAcceptor.Registry.MENU_TYPES)
    public static BaseContainerType<TrashCanContainer> energy_trash_can_container;
    @RegistryEntryAcceptor(namespace="trashcans", identifier="ultimate_trash_can_container", registry=RegistryEntryAcceptor.Registry.MENU_TYPES)
    public static BaseContainerType<TrashCanContainer> ultimate_trash_can_container;

    public TrashCans() {
        CHANNEL.registerMessage(PacketToggleItemWhitelist.class, PacketToggleItemWhitelist::new, true);
        CHANNEL.registerMessage(PacketToggleLiquidWhitelist.class, PacketToggleLiquidWhitelist::new, true);
        CHANNEL.registerMessage(PacketToggleEnergyLimit.class, PacketToggleEnergyLimit::new, true);
        CHANNEL.registerMessage(PacketChangeEnergyLimit.class, PacketChangeEnergyLimit::new, true);
        CHANNEL.registerMessage(PacketChangeItemFilter.class, PacketChangeItemFilter::new, true);
        CHANNEL.registerMessage(PacketChangeLiquidFilter.class, PacketChangeLiquidFilter::new, true);
        TrashCans.register();
        if (CommonUtils.getEnvironmentSide().isClient()) {
            TrashCansClient.registerScreens();
        }
        TrashCans.registerGenerators();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        LiquidTrashCanFilters.register(new FluidFilterManager(), "fluid");
        Compatibility.init();
    }

    private static void register() {
        RegistrationHandler handler = RegistrationHandler.get((String)"trashcans");
        handler.registerBlock("item_trash_can", () -> new TrashCanBlock(() -> item_trash_can_tile, ItemTrashCanContainer::new));
        handler.registerBlock("liquid_trash_can", () -> new TrashCanBlock(() -> liquid_trash_can_tile, LiquidTrashCanContainer::new));
        handler.registerBlock("energy_trash_can", () -> new TrashCanBlock(() -> energy_trash_can_tile, EnergyTrashCanContainer::new));
        handler.registerBlock("ultimate_trash_can", () -> new TrashCanBlock(() -> ultimate_trash_can_tile, UltimateTrashCanContainer::new));
        handler.registerBlockEntityType("itemtrashcan", () -> BaseBlockEntityType.create(() -> new TrashCanBlockEntity(item_trash_can_tile, true, false, false), (Block[])new Block[]{item_trash_can}));
        handler.registerBlockEntityType("liquidtrashcan", () -> BaseBlockEntityType.create(() -> new TrashCanBlockEntity(liquid_trash_can_tile, false, true, false), (Block[])new Block[]{liquid_trash_can}));
        handler.registerBlockEntityType("energytrashcan", () -> BaseBlockEntityType.create(() -> new TrashCanBlockEntity(energy_trash_can_tile, false, false, true), (Block[])new Block[]{energy_trash_can}));
        handler.registerBlockEntityType("ultimatetrashcan", () -> BaseBlockEntityType.create(() -> new TrashCanBlockEntity(ultimate_trash_can_tile, true, true, true), (Block[])new Block[]{ultimate_trash_can}));
        handler.registerItem("item_trash_can", () -> new BaseBlockItem((Block)item_trash_can, ItemProperties.create().group(CreativeItemGroup.getDecoration())));
        handler.registerItem("liquid_trash_can", () -> new BaseBlockItem((Block)liquid_trash_can, ItemProperties.create().group(CreativeItemGroup.getDecoration())));
        handler.registerItem("energy_trash_can", () -> new BaseBlockItem((Block)energy_trash_can, ItemProperties.create().group(CreativeItemGroup.getDecoration())));
        handler.registerItem("ultimate_trash_can", () -> new BaseBlockItem((Block)ultimate_trash_can, ItemProperties.create().group(CreativeItemGroup.getDecoration())));
        handler.registerMenuType("item_trash_can_container", BaseContainerType.create((container, buffer) -> buffer.func_179255_a(container.getBlockEntityPos()), (player, buffer) -> new ItemTrashCanContainer((EntityPlayer)player, buffer.func_179259_c())));
        handler.registerMenuType("liquid_trash_can_container", BaseContainerType.create((container, buffer) -> buffer.func_179255_a(container.getBlockEntityPos()), (player, buffer) -> new LiquidTrashCanContainer((EntityPlayer)player, buffer.func_179259_c())));
        handler.registerMenuType("energy_trash_can_container", BaseContainerType.create((container, buffer) -> buffer.func_179255_a(container.getBlockEntityPos()), (player, buffer) -> new EnergyTrashCanContainer((EntityPlayer)player, buffer.func_179259_c())));
        handler.registerMenuType("ultimate_trash_can_container", BaseContainerType.create((container, buffer) -> buffer.func_179255_a(container.getBlockEntityPos()), (player, buffer) -> new UltimateTrashCanContainer((EntityPlayer)player, buffer.func_179259_c())));
    }

    private static void registerGenerators() {
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)"trashcans");
        handler.addGenerator(TrashCansAdvancementGenerator::new);
        handler.addGenerator(TrashCansModelGenerator::new);
        handler.addGenerator(TrashCansBlockStateGenerator::new);
        handler.addGenerator(TrashCansLanguageGenerator::new);
        handler.addGenerator(TrashCansLootTableGenerator::new);
        handler.addGenerator(TrashCansRecipeGenerator::new);
        handler.addGenerator(TrashCansTagGenerator::new);
    }
}

