/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.applesprout;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilOreDictionary;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAppleCrop
extends BlockCrops
implements IHasRecipe,
IContent {
    private static int GROWTH_TICKRATE = 500;
    private static final double BONEMEAL_CHANCE = 0.35;
    private static final AxisAlignedBB[] GROWING_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.25, 0.9, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.8, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.7, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.5, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.4, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.3, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.2, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.2, 0.25, 0.75, 1.0, 0.75)};
    private boolean enabled;

    public BlockAppleCrop() {
        this.func_149713_g(0);
    }

    @Override
    public String getContentName() {
        return "apple";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        String myTooltip = this.func_149739_a() + ".tooltip";
        tooltip.add(UtilChat.lang(myTooltip));
    }

    public void observedNeighborChange(IBlockState observerState, World world, BlockPos pos, Block changedBlock, BlockPos changedBlockPos) {
        if (!this.canStay(world, pos)) {
            world.func_175655_b(pos, true);
        } else {
            super.observedNeighborChange(observerState, world, pos, changedBlock, changedBlockPos);
        }
    }

    public int func_149738_a(World world) {
        return GROWTH_TICKRATE;
    }

    protected boolean func_185514_i(IBlockState state) {
        return true;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        if (!this.canStay(world, pos)) {
            return false;
        }
        return this.func_176196_c(world, pos);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!this.canStay(world, pos)) {
            world.func_175655_b(pos, true);
        } else {
            this.func_176474_b(world, rand, pos, state);
        }
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return (double)world.field_73012_v.nextFloat() < 0.35;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        int age;
        if (!this.canStay(world, pos)) {
            world.func_175655_b(pos, true);
        } else if (!world.field_72995_K && (age = ((Integer)state.func_177229_b((IProperty)field_176488_a)).intValue()) < this.func_185526_g()) {
            world.func_180501_a(pos, this.getStateForAge(age + 1), 3);
            world.func_175684_a(new BlockPos((Vec3i)pos), (Block)this, this.func_149738_a(world));
        }
    }

    private IBlockState getStateForAge(int age) {
        return this.func_176223_P().func_177226_a((IProperty)field_176488_a, (Comparable)Integer.valueOf(age));
    }

    protected Item func_149866_i() {
        return Item.func_150898_a((Block)this);
    }

    protected Item func_149865_P() {
        return Items.field_151034_e;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return GROWING_AABB[(Integer)state.func_177229_b((IProperty)field_176488_a)];
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Block)this, 2), "as", "sa", Character.valueOf('a'), new ItemStack(Items.field_151034_e), Character.valueOf('s'), "stickWood");
    }

    private boolean canStay(World world, BlockPos pos) {
        Block blockAbove = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        return UtilOreDictionary.doesMatchOreDict(new ItemStack(blockAbove), "treeLeaves");
    }

    @Override
    public void register() {
        BlockRegistry.registerBlock((Block)this, this.getContentName(), GuideCategory.BLOCK);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        String category = "cyclicmagic.content";
        this.enabled = config.getBoolean(this.getContentName(), category, true, " Set false to delete - requires restart");
        GROWTH_TICKRATE = config.getInt("AppleGrowthTicks", "cyclicmagic.blocks", 500, 1, 99999, "Ticks for apple sprout to grow, 1 will grow almost instantly");
    }
}

