/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.sprinkler;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.core.BaseTESR;
import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.block.sprinkler.BlockSprinkler;
import com.lothrazar.cyclicmagic.block.sprinkler.TileSprinkler;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class SprinklerTESR<T extends TileSprinkler>
extends BaseTESR<T> {
    public SprinklerTESR(Block block) {
        super(block);
    }

    public void render(TileSprinkler te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (!BlockSprinkler.sprinklerAnimationsAllowed) {
            return;
        }
        GlStateManager.func_179123_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179101_C();
        try {
            this.renderAnimation(te);
        }
        catch (Exception e) {
            ModCyclic.logger.error("sprinkler animation crash", e);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
    }

    protected void renderAnimation(TileEntityBaseMachineInvo te) throws Exception {
        GlStateManager.func_179094_E();
        if (te.isRunning()) {
            GlStateManager.func_179137_b((double)0.5, (double)0.0, (double)0.5);
            long angle = System.currentTimeMillis() / 10L % 360L;
            GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
        }
        RenderHelper.func_74518_a();
        this.func_147499_a(TextureMap.field_110575_b);
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        World world = te.func_145831_w();
        GlStateManager.func_179109_b((float)(-te.func_174877_v().func_177958_n()), (float)(-te.func_174877_v().func_177956_o()), (float)(-te.func_174877_v().func_177952_p()));
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176600_a);
        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().func_175602_ab() != null && Minecraft.func_71410_x().func_175602_ab().func_175019_b() != null) {
            Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178267_a((IBlockAccess)world, this.getBakedModel(), world.func_180495_p(te.func_174877_v()), te.func_174877_v(), Tessellator.func_178181_a().func_178180_c(), false);
        }
        tessellator.func_78381_a();
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    protected IBakedModel getBakedModel() {
        if (this.bakedModel == null && this.resource != null) {
            try {
                this.model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("cyclicmagic", this.resource));
            }
            catch (Exception e) {
                ModCyclic.logger.error("Error trying to obtain baked model", e);
                return null;
            }
            this.bakedModel = this.model.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176599_b, (Function)new Function<ResourceLocation, TextureAtlasSprite>(){

                @Override
                public TextureAtlasSprite apply(ResourceLocation location) {
                    return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                }
            });
        }
        return this.bakedModel;
    }
}

