/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.fishing;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.entity.EntityThrowableDispensable;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.item.core.BaseItemProjectile;
import com.lothrazar.cyclicmagic.item.fishing.EntityFishingBolt;
import com.lothrazar.cyclicmagic.registry.EntityProjectileRegistry;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilPlayer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class ItemProjectileFishing
extends BaseItemProjectile
implements IHasRecipe,
IContent {
    private boolean enabled;

    @Override
    public EntityThrowableDispensable getThrownEntity(World world, ItemStack held, double x, double y, double z) {
        return new EntityFishingBolt(world, x, y, z);
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapelessRecipe(new ItemStack((Item)this, 32), "enderpearl", "string", "gunpowder");
    }

    @Override
    public void onItemThrow(ItemStack held, World world, EntityPlayer player, EnumHand hand) {
        this.doThrow(world, player, hand, new EntityFishingBolt(world, (EntityLivingBase)player));
        UtilPlayer.decrStackSize(player, hand);
    }

    @Override
    public SoundEvent getSound() {
        return SoundEvents.field_187511_aA;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("EnderFishing", "cyclicmagic.content", true, this.getContentName() + " Set false to delete - requires restart");
    }

    @Override
    public String getContentName() {
        return "ender_fishing";
    }

    @Override
    public void register() {
        ItemRegistry.register(this, this.getContentName(), GuideCategory.ITEMTHROW);
        EntityProjectileRegistry.registerModEntity(EntityFishingBolt.class, "fishingbolt", 1004);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }
}

