/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import com.mojang.realmsclient.gui.ChatFormatting;
import de.maxhenkel.car.blocks.tileentity.TileEntityFuelStation;
import de.maxhenkel.car.entity.car.base.EntityCarFuelBase;
import de.maxhenkel.car.gui.ContainerFuelStation;
import de.maxhenkel.car.gui.GuiBase;
import de.maxhenkel.tools.ItemTools;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.FluidStack;

public class GuiFuelStation
extends GuiBase {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("car", "textures/gui/gui_fuelstation.png");
    private TileEntityFuelStation fuelStation;
    private IInventory inventoryPlayer;
    private static final int TITLE_COLOR = Color.WHITE.getRGB();
    private static final int FONT_COLOR = Color.DARK_GRAY.getRGB();
    private static final ChatFormatting INFO_COLOR = ChatFormatting.WHITE;
    protected GuiButton buttonStart;
    protected GuiButton buttonStop;

    public GuiFuelStation(TileEntityFuelStation fuelStation, IInventory inventoryPlayer) {
        super(new ContainerFuelStation(fuelStation, inventoryPlayer));
        this.fuelStation = fuelStation;
        this.inventoryPlayer = inventoryPlayer;
        this.field_146999_f = 176;
        this.field_147000_g = 217;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.buttonStart = this.func_189646_b(new GuiButton(0, this.field_146294_l / 2 - 20, this.field_147009_r + 100, 40, 20, new TextComponentTranslation("button.start", new Object[0]).func_150254_d()));
        this.buttonStop = this.func_189646_b(new GuiButton(1, this.field_147003_i + this.field_146999_f - 40 - 7, this.field_147009_r + 100, 40, 20, new TextComponentTranslation("button.stop", new Object[0]).func_150254_d()));
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURE);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        this.buttonStart.field_146124_l = !this.fuelStation.isFueling();
        this.buttonStop.field_146124_l = this.fuelStation.isFueling();
        this.func_73732_a(this.field_146289_q, new TextComponentTranslation("gui.fuelstation", new Object[0]).func_150254_d(), this.field_146294_l / 2, this.field_147009_r + 5, TITLE_COLOR);
        EntityCarFuelBase car = this.fuelStation.getCarInFront();
        this.drawCarName(car);
        this.drawCarFuel(car);
        this.drawRefueled();
        this.drawBuffer();
        this.field_146289_q.func_78276_b(this.inventoryPlayer.func_145748_c_().func_150260_c(), this.field_147003_i + 8, this.field_147009_r + this.field_147000_g - 93, FONT_COLOR);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        ItemStack stack = this.fuelStation.getTradingInventory().func_70301_a(0);
        if (ItemTools.isStackEmpty(stack)) {
            return;
        }
        if (mouseX >= this.field_147003_i + 18 && mouseX <= this.field_147003_i + 33 && mouseY >= this.field_147009_r + 99 && mouseY <= this.field_147009_r + 114) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(new TextComponentTranslation("tooltip.trade", new Object[]{stack.func_190916_E(), stack.func_82833_r(), this.fuelStation.func_174887_a_(2)}).func_150254_d());
            this.func_146283_a(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    private void drawCarName(EntityCarFuelBase car) {
        String carText = car == null ? new TextComponentTranslation("fuelstation.nocar", new Object[0]).func_150254_d() : new TextComponentTranslation("fuelstation.carinfo", new Object[]{INFO_COLOR + car.getCarName().func_150254_d()}).func_150254_d();
        this.field_146289_q.func_78276_b(carText, this.field_147003_i + 63, this.field_147009_r + 20, FONT_COLOR);
    }

    private void drawCarFuel(EntityCarFuelBase car) {
        if (car == null) {
            String empty = new TextComponentTranslation("fuelstation.fuel_empty", new Object[0]).func_150254_d();
            this.field_146289_q.func_78276_b(empty, this.field_147003_i + 63, this.field_147009_r + 30, FONT_COLOR);
            return;
        }
        String fuelText = new TextComponentTranslation("fuelstation.car_fuel_amount", new Object[]{INFO_COLOR + String.valueOf(car.getFuelAmount()), INFO_COLOR + String.valueOf(car.getMaxFuel())}).func_150254_d();
        this.field_146289_q.func_78276_b(fuelText, this.field_147003_i + 63, this.field_147009_r + 30, FONT_COLOR);
        if (car.getFluid() == null) {
            return;
        }
        String typeText = new TextComponentTranslation("fuelstation.car_fuel_type", new Object[]{INFO_COLOR + car.getFluid().getLocalizedName(new FluidStack(car.getFluid(), 1))}).func_150254_d();
        this.field_146289_q.func_78276_b(typeText, this.field_147003_i + 63, this.field_147009_r + 40, FONT_COLOR);
    }

    private void drawRefueled() {
        String refueledText = new TextComponentTranslation("fuelstation.refueled", new Object[]{INFO_COLOR + String.valueOf(this.fuelStation.func_174887_a_(0))}).func_150254_d();
        this.field_146289_q.func_78276_b(refueledText, this.field_147003_i + 63, this.field_147009_r + 60, FONT_COLOR);
    }

    private void drawBuffer() {
        FluidStack stack = this.fuelStation.getStorage();
        if (stack == null) {
            String bufferText = new TextComponentTranslation("fuelstation.fuel_empty", new Object[0]).func_150254_d();
            this.field_146289_q.func_78276_b(bufferText, this.field_147003_i + 63, this.field_147009_r + 70, FONT_COLOR);
            return;
        }
        int amount = this.fuelStation.func_174887_a_(1);
        String amountText = new TextComponentTranslation("fuelstation.fuel_buffer_amount", new Object[]{INFO_COLOR + String.valueOf(amount), INFO_COLOR + String.valueOf(this.fuelStation.maxStorageAmount)}).func_150254_d();
        this.field_146289_q.func_78276_b(amountText, this.field_147003_i + 63, this.field_147009_r + 70, FONT_COLOR);
        String fluidName = stack.getLocalizedName();
        String bufferText = new TextComponentTranslation("fuelstation.fuel_buffer_type", new Object[]{INFO_COLOR + fluidName}).func_150254_d();
        this.field_146289_q.func_78276_b(bufferText, this.field_147003_i + 63, this.field_147009_r + 80, FONT_COLOR);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.equals(this.buttonStart)) {
            this.fuelStation.setFueling(true);
            this.fuelStation.sendStartFuelPacket(true);
        } else if (button.equals(this.buttonStop)) {
            this.fuelStation.setFueling(false);
            this.fuelStation.sendStartFuelPacket(false);
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

