/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.block;

import com.google.common.collect.Lists;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockPistonStructureHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.interfaces.IRecipe;
import zmaster587.libVulpes.recipe.RecipesMachine;

public class BlockSmallPlatePress
extends BlockPistonBase {
    public BlockSmallPlatePress() {
        super(false);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K && world.func_175625_s(pos) == null) {
            this.checkForMove(world, pos, state);
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)field_176320_b, (Comparable)Boolean.FALSE);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, @Nonnull ItemStack stack) {
        if (!world.field_72995_K) {
            this.checkForMove(world, pos, state);
        }
    }

    private boolean shouldBeExtended(World worldIn, BlockPos pos, EnumFacing facing) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (enumfacing == facing || !worldIn.func_175709_b(pos.func_177972_a(enumfacing), enumfacing)) continue;
            return true;
        }
        if (worldIn.func_175709_b(pos, EnumFacing.DOWN)) {
            return true;
        }
        BlockPos blockpos = pos.func_177984_a();
        for (EnumFacing enumfacing1 : EnumFacing.values()) {
            if (enumfacing1 == EnumFacing.DOWN || !worldIn.func_175709_b(blockpos.func_177972_a(enumfacing1), enumfacing1)) continue;
            return true;
        }
        return false;
    }

    private void checkForMove(World worldIn, BlockPos pos, IBlockState state) {
        ItemStack stack;
        EnumFacing enumfacing = EnumFacing.DOWN;
        boolean flag = this.shouldBeExtended(worldIn, pos, enumfacing);
        if (flag && !(stack = this.getRecipe(worldIn, pos, state)).func_190926_b() && !((Boolean)state.func_177229_b((IProperty)field_176320_b)).booleanValue()) {
            worldIn.func_175698_g(pos.func_177977_b());
            if (!worldIn.field_72995_K) {
                worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() - 0.5, (double)pos.func_177952_p() + 0.5, stack));
            }
            if (new BlockPistonStructureHelper(worldIn, pos, enumfacing, true).func_177253_a()) {
                worldIn.func_175641_c(pos, (Block)this, 0, enumfacing.func_176745_a());
            }
        } else if (!flag && ((Boolean)state.func_177229_b((IProperty)field_176320_b)).booleanValue()) {
            worldIn.func_175641_c(pos, (Block)this, 1, enumfacing.func_176745_a());
        }
    }

    @ParametersAreNonnullByDefault
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!world.field_72995_K) {
            this.checkForMove(world, pos, state);
        }
    }

    @Nonnull
    private ItemStack getRecipe(World world, BlockPos pos, IBlockState state) {
        if (world.func_175623_d(pos.func_177982_a(0, -1, 0))) {
            return ItemStack.field_190927_a;
        }
        IBlockState state2 = world.func_180495_p(pos.func_177982_a(0, -1, 0));
        Block block = state2.func_177230_c();
        Item item = Item.func_150898_a((Block)block);
        if (item.equals(Items.field_190931_a)) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackInWorld = new ItemStack(item, 1, block.func_176201_c(state2));
        List recipes = RecipesMachine.getInstance().getRecipes(((Object)((Object)this)).getClass());
        ItemStack stack = ItemStack.field_190927_a;
        block0: for (IRecipe recipe : recipes) {
            for (ItemStack stack2 : (List)recipe.getIngredients().get(0)) {
                if (!stack2.func_77969_a(stackInWorld)) continue;
                stack = (ItemStack)recipe.getOutput().get(0);
                continue block0;
            }
        }
        if (world.func_180495_p(pos.func_177982_a(0, -2, 0)).func_177230_c() == Blocks.field_150343_Z) {
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private boolean doMove(World worldIn, BlockPos pos, EnumFacing direction, boolean extending) {
        BlockPistonStructureHelper blockpistonstructurehelper;
        if (!extending) {
            worldIn.func_175698_g(pos.func_177972_a(direction));
        }
        if (!(blockpistonstructurehelper = new BlockPistonStructureHelper(worldIn, pos, direction, extending)).func_177253_a()) {
            return false;
        }
        List list = blockpistonstructurehelper.func_177254_c();
        ArrayList list1 = Lists.newArrayList();
        for (BlockPos blockPos : list) {
            list1.add(worldIn.func_180495_p(blockPos).func_185899_b((IBlockAccess)worldIn, blockPos));
        }
        List list2 = blockpistonstructurehelper.func_177252_d();
        int k = list.size() + list2.size();
        IBlockState[] aiblockstate = new IBlockState[k];
        EnumFacing enumfacing = extending ? direction : direction.func_176734_d();
        for (int j = list2.size() - 1; j >= 0; --j) {
            BlockPos blockpos1 = (BlockPos)list2.get(j);
            IBlockState iblockstate = worldIn.func_180495_p(blockpos1);
            float chance = iblockstate.func_177230_c() instanceof BlockSnow ? -1.0f : 1.0f;
            iblockstate.func_177230_c().func_180653_a(worldIn, blockpos1, iblockstate, chance, 0);
            worldIn.func_175698_g(blockpos1);
            aiblockstate[--k] = iblockstate;
        }
        for (int l = list.size() - 1; l >= 0; --l) {
            BlockPos blockpos3 = (BlockPos)list.get(l);
            IBlockState iblockstate2 = worldIn.func_180495_p(blockpos3);
            worldIn.func_180501_a(blockpos3, Blocks.field_150350_a.func_176223_P(), 2);
            blockpos3 = blockpos3.func_177972_a(enumfacing);
            worldIn.func_180501_a(blockpos3, Blocks.field_180384_M.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)direction), 4);
            worldIn.func_175690_a(blockpos3, BlockPistonMoving.func_185588_a((IBlockState)((IBlockState)list1.get(l)), (EnumFacing)direction, (boolean)extending, (boolean)false));
            aiblockstate[--k] = iblockstate2;
        }
        BlockPos blockpos2 = pos.func_177972_a(direction);
        if (extending) {
            BlockPistonExtension.EnumPistonType blockpistonextension$enumpistontype = BlockPistonExtension.EnumPistonType.DEFAULT;
            IBlockState iblockstate3 = Blocks.field_150332_K.func_176223_P().func_177226_a((IProperty)BlockPistonExtension.field_176387_N, (Comparable)direction).func_177226_a((IProperty)BlockPistonExtension.field_176325_b, (Comparable)blockpistonextension$enumpistontype);
            IBlockState iblockstate1 = Blocks.field_180384_M.func_176223_P().func_177226_a((IProperty)BlockPistonMoving.field_176426_a, (Comparable)direction).func_177226_a((IProperty)BlockPistonMoving.field_176425_b, (Comparable)BlockPistonExtension.EnumPistonType.DEFAULT);
            worldIn.func_180501_a(blockpos2, iblockstate1, 4);
            worldIn.func_175690_a(blockpos2, BlockPistonMoving.func_185588_a((IBlockState)iblockstate3, (EnumFacing)direction, (boolean)true, (boolean)false));
        }
        for (int i1 = list2.size() - 1; i1 >= 0; --i1) {
            worldIn.func_175685_c((BlockPos)list2.get(i1), aiblockstate[k++].func_177230_c(), true);
        }
        for (int j1 = list.size() - 1; j1 >= 0; --j1) {
            worldIn.func_175685_c((BlockPos)list.get(j1), aiblockstate[k++].func_177230_c(), true);
        }
        if (extending) {
            worldIn.func_175685_c(blockpos2, (Block)Blocks.field_150332_K, true);
            worldIn.func_175685_c(pos, (Block)this, true);
        }
        return true;
    }

    public boolean func_189539_a(IBlockState state, World worldIn, @Nonnull BlockPos pos, int id, int param) {
        EnumFacing enumfacing = EnumFacing.DOWN;
        if (!worldIn.field_72995_K) {
            boolean flag = this.shouldBeExtended(worldIn, pos, enumfacing);
            if (flag && id == 1) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)field_176320_b, (Comparable)Boolean.TRUE), 2);
                return false;
            }
            if (!flag && id == 0) {
                return false;
            }
        }
        if (id == 0) {
            if (!this.doMove(worldIn, pos, enumfacing, true)) {
                return false;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)field_176320_b, (Comparable)Boolean.TRUE), 2);
            worldIn.func_184133_a(null, pos, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.25f + 0.6f);
        } else if (id == 1) {
            worldIn.func_180501_a(pos, Blocks.field_180384_M.func_176223_P().func_177226_a((IProperty)BlockPistonMoving.field_176426_a, (Comparable)enumfacing).func_177226_a((IProperty)BlockPistonMoving.field_176425_b, (Comparable)BlockPistonExtension.EnumPistonType.DEFAULT), 3);
            worldIn.func_175690_a(pos, BlockPistonMoving.func_185588_a((IBlockState)this.func_176203_a(param), (EnumFacing)enumfacing, (boolean)false, (boolean)true));
            worldIn.func_184133_a(null, pos, SoundEvents.field_187712_dQ, SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.15f + 0.6f);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(@Nonnull ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, player, tooltip, advanced);
        tooltip.add(ChatFormatting.DARK_GRAY + "" + ChatFormatting.ITALIC + LibVulpes.proxy.getLocalizedString("machine.tooltip.smallplatepress"));
    }
}

