/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.model.smartmodel;

import cassiokf.industrialrenewal.model.smartmodel.composite.BaseCoreSidesComposite;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;

public class TurbinePillarIModel
implements IModel {
    public static final ResourceLocation TEXTURE_SHEET = new ResourceLocation("industrialrenewal:blocks/energy_meter_128");
    public static final ModelResourceLocation MODEL_CORE = new ModelResourceLocation("industrialrenewal:turbine_pillar/pillar_energy_core");
    public static final ModelResourceLocation MODEL_UP = new ModelResourceLocation("industrialrenewal:turbine_pillar/con_up");
    public static final ModelResourceLocation MODEL_DOWN = new ModelResourceLocation("industrialrenewal:turbine_pillar/con_down");
    public static final ModelResourceLocation MODEL_NORTH = new ModelResourceLocation("industrialrenewal:energy_connector/con_out_north");
    public static final ModelResourceLocation MODEL_SOUTH = new ModelResourceLocation("industrialrenewal:energy_connector/con_out_south");
    public static final ModelResourceLocation MODEL_WEST = new ModelResourceLocation("industrialrenewal:energy_connector/con_out_west");
    public static final ModelResourceLocation MODEL_EAST = new ModelResourceLocation("industrialrenewal:energy_connector/con_out_east");

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.copyOf((Object[])new ResourceLocation[]{TEXTURE_SHEET});
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        try {
            IModel subComponent = ModelLoaderRegistry.getModel((ResourceLocation)MODEL_CORE);
            IBakedModel bakedModelCore = subComponent.bake(state, format, bakedTextureGetter);
            subComponent = ModelLoaderRegistry.getModel((ResourceLocation)MODEL_UP);
            IBakedModel bakedModelUp = subComponent.bake(state, format, bakedTextureGetter);
            subComponent = ModelLoaderRegistry.getModel((ResourceLocation)MODEL_DOWN);
            IBakedModel bakedModelDown = subComponent.bake(state, format, bakedTextureGetter);
            subComponent = ModelLoaderRegistry.getModel((ResourceLocation)MODEL_WEST);
            IBakedModel bakedModelWest = subComponent.bake(state, format, bakedTextureGetter);
            subComponent = ModelLoaderRegistry.getModel((ResourceLocation)MODEL_EAST);
            IBakedModel bakedModelEast = subComponent.bake(state, format, bakedTextureGetter);
            subComponent = ModelLoaderRegistry.getModel((ResourceLocation)MODEL_NORTH);
            IBakedModel bakedModelNorth = subComponent.bake(state, format, bakedTextureGetter);
            subComponent = ModelLoaderRegistry.getModel((ResourceLocation)MODEL_SOUTH);
            IBakedModel bakedModelSouth = subComponent.bake(state, format, bakedTextureGetter);
            return new BaseCoreSidesComposite(bakedModelCore, bakedModelDown, bakedModelUp, bakedModelWest, bakedModelEast, bakedModelNorth, bakedModelSouth);
        }
        catch (Exception exception) {
            System.err.println("bake() failed due to exception:" + exception);
            return ModelLoaderRegistry.getMissingModel().bake(state, format, bakedTextureGetter);
        }
    }
}

