/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.config;

import java.text.DecimalFormat;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiSliderButton
extends GuiButton {
    private float sliderValue = 1.0f;
    private final String translationKey;
    public boolean dragging;
    private final float min;
    private final float max;
    private final float steps;
    private final Supplier<Double> current;
    private final Consumer<Double> update;

    public GuiSliderButton(String translationKey, float min, float max, float steps, Supplier<Double> current, Consumer<Double> update) {
        super(0, 0, 0, 150, 20, "");
        this.translationKey = translationKey;
        this.min = min;
        this.max = max;
        this.steps = steps;
        this.current = current;
        this.update = update;
        this.sliderValue = (float)((current.get() - (double)min) / (double)(max - min));
        this.field_146126_j = I18n.func_135052_a((String)translationKey, (Object[])new Object[0]) + ": " + this.getRounded(current.get());
    }

    protected int func_146114_a(boolean p_getHoverState_1_) {
        return 0;
    }

    protected void func_146119_b(Minecraft p_mouseDragged_1_, int p_mouseDragged_2_, int p_mouseDragged_3_) {
        if (!this.field_146125_m) {
            return;
        }
        if (this.dragging) {
            this.sliderValue = ((float)p_mouseDragged_2_ - (float)this.field_146128_h + 4.0f) / ((float)this.field_146120_f - 8.0f);
            this.sliderValue = MathHelper.func_76131_a((float)this.sliderValue, (float)0.0f, (float)1.0f);
            float lvt_4_1_ = this.min + this.sliderValue * (this.max - this.min);
            lvt_4_1_ = (int)(lvt_4_1_ / this.steps);
            this.update.accept(Double.valueOf(lvt_4_1_ *= this.steps));
            this.sliderValue = (float)((this.current.get() - (double)this.min) / (double)(this.max - this.min));
            this.field_146126_j = I18n.func_135052_a((String)this.translationKey, (Object[])new Object[0]) + ": " + this.getRounded(this.current.get());
        }
        p_mouseDragged_1_.func_110434_K().func_110577_a(field_146122_a);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (float)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, 20);
        this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (float)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66, 4, 20);
    }

    public boolean func_146116_c(Minecraft p_mousePressed_1_, int p_mousePressed_2_, int p_mousePressed_3_) {
        if (super.func_146116_c(p_mousePressed_1_, p_mousePressed_2_, p_mousePressed_3_)) {
            this.sliderValue = ((float)p_mousePressed_2_ - (float)this.field_146128_h + 4.0f) / ((float)this.field_146120_f - 8.0f);
            this.sliderValue = MathHelper.func_76131_a((float)this.sliderValue, (float)0.0f, (float)1.0f);
            float lvt_4_1_ = this.min + this.sliderValue * (this.max - this.min);
            this.update.accept(Double.valueOf(lvt_4_1_));
            this.sliderValue = (float)((double)this.max / this.current.get());
            this.field_146126_j = I18n.func_135052_a((String)this.translationKey, (Object[])new Object[0]) + ": " + this.getRounded(this.current.get());
            this.dragging = true;
            return true;
        }
        return false;
    }

    public void func_146118_a(int p_mouseReleased_1_, int p_mouseReleased_2_) {
        this.dragging = false;
    }

    public String getRounded(double d) {
        DecimalFormat f = new DecimalFormat("##.00");
        return f.format(d);
    }
}

