/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.renderlayers;

import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.SkinUtil;
import dev.tr7zw.skinlayers.accessor.PlayerEntityModelAccessor;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import dev.tr7zw.skinlayers.render.CustomizableModelPart;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.player.EnumPlayerModelParts;

public class BodyLayerFeatureRenderer
implements LayerRenderer<AbstractClientPlayer> {
    private RenderPlayer playerRenderer;
    private final boolean thinArms;
    private static final Minecraft mc = Minecraft.func_71410_x();
    private final List<Layer> bodyLayers = new ArrayList<Layer>();

    public BodyLayerFeatureRenderer(RenderPlayer playerRenderer) {
        this.playerRenderer = playerRenderer;
        this.thinArms = ((PlayerEntityModelAccessor)playerRenderer).hasThinArms();
        this.bodyLayers.add(new Layer(0, false, EnumPlayerModelParts.LEFT_PANTS_LEG, Shape.LEGS, () -> playerRenderer.func_177087_b().field_178722_k, () -> SkinLayersModBase.config.enableLeftPants));
        this.bodyLayers.add(new Layer(1, false, EnumPlayerModelParts.RIGHT_PANTS_LEG, Shape.LEGS, () -> playerRenderer.func_177087_b().field_178721_j, () -> SkinLayersModBase.config.enableRightPants));
        this.bodyLayers.add(new Layer(2, false, EnumPlayerModelParts.LEFT_SLEEVE, this.thinArms ? Shape.ARMS_SLIM : Shape.ARMS, () -> playerRenderer.func_177087_b().field_178724_i, () -> SkinLayersModBase.config.enableLeftSleeve));
        this.bodyLayers.add(new Layer(3, true, EnumPlayerModelParts.RIGHT_SLEEVE, this.thinArms ? Shape.ARMS_SLIM : Shape.ARMS, () -> playerRenderer.func_177087_b().field_178723_h, () -> SkinLayersModBase.config.enableRightSleeve));
        this.bodyLayers.add(new Layer(4, false, EnumPlayerModelParts.JACKET, Shape.BODY, () -> playerRenderer.func_177087_b().field_78115_e, () -> SkinLayersModBase.config.enableJacket));
    }

    public void doRenderLayer(AbstractClientPlayer player, float paramFloat1, float paramFloat2, float paramFloat3, float deltaTick, float paramFloat5, float paramFloat6, float paramFloat7) {
        if (!player.func_152123_o() || player.func_82150_aj()) {
            return;
        }
        if (BodyLayerFeatureRenderer.mc.field_71441_e == null) {
            return;
        }
        if (BodyLayerFeatureRenderer.mc.field_71439_g.func_174791_d().func_72436_e(player.func_174791_d()) > (double)(SkinLayersModBase.config.renderDistanceLOD * SkinLayersModBase.config.renderDistanceLOD)) {
            return;
        }
        PlayerSettings settings = (PlayerSettings)player;
        if (settings.getSkinLayers() == null && !this.setupModel(player, settings)) {
            return;
        }
        this.renderLayers(player, settings.getSkinLayers(), deltaTick);
    }

    private boolean setupModel(AbstractClientPlayer abstractClientPlayerEntity, PlayerSettings settings) {
        if (!SkinUtil.hasCustomSkin(abstractClientPlayerEntity)) {
            return false;
        }
        SkinUtil.setup3dLayers(abstractClientPlayerEntity, settings, this.thinArms, null);
        return true;
    }

    public void renderLayers(AbstractClientPlayer abstractClientPlayer, CustomizableModelPart[] layers, float deltaTick) {
        if (layers == null) {
            return;
        }
        float pixelScaling = SkinLayersModBase.config.baseVoxelSize;
        float heightScaling = 1.035f;
        float widthScaling = SkinLayersModBase.config.baseVoxelSize;
        boolean redTint = abstractClientPlayer.field_70737_aN > 0 || abstractClientPlayer.field_70725_aQ > 0;
        for (Layer layer : this.bodyLayers) {
            if (!abstractClientPlayer.func_175148_a(layer.modelPart) || layer.vanillaGetter.get().field_78807_k || !layer.configGetter.get().booleanValue()) continue;
            GlStateManager.func_179094_E();
            if (abstractClientPlayer.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            }
            layer.vanillaGetter.get().func_78794_c(0.0625f);
            if (layer.shape == Shape.ARMS) {
                layers[layer.layersId].x = 15.968f;
            } else if (layer.shape == Shape.ARMS_SLIM) {
                layers[layer.layersId].x = 7.984f;
            }
            widthScaling = layer.shape == Shape.BODY ? SkinLayersModBase.config.bodyVoxelWidthSize : SkinLayersModBase.config.baseVoxelSize;
            if (layer.mirrored) {
                layers[layer.layersId].x *= -1.0f;
            }
            GlStateManager.func_179139_a((double)0.0625, (double)0.0625, (double)0.0625);
            GlStateManager.func_179152_a((float)widthScaling, (float)heightScaling, (float)pixelScaling);
            layers[layer.layersId].y = layer.shape.yOffsetMagicValue;
            layers[layer.layersId].render(redTint);
            GlStateManager.func_179121_F();
        }
    }

    public boolean func_177142_b() {
        return false;
    }

    private static enum Shape {
        HEAD(0.0f),
        BODY(0.6f),
        LEGS(-0.2f),
        ARMS(0.4f),
        ARMS_SLIM(0.4f);

        private final float yOffsetMagicValue;

        private Shape(float yOffsetMagicValue) {
            this.yOffsetMagicValue = yOffsetMagicValue;
        }
    }

    class Layer {
        int layersId;
        boolean mirrored;
        EnumPlayerModelParts modelPart;
        Shape shape;
        Supplier<ModelRenderer> vanillaGetter;
        Supplier<Boolean> configGetter;

        public Layer(int layersId, boolean mirrored, EnumPlayerModelParts modelPart, Shape shape, Supplier<ModelRenderer> vanillaGetter, Supplier<Boolean> configGetter) {
            this.layersId = layersId;
            this.mirrored = mirrored;
            this.modelPart = modelPart;
            this.shape = shape;
            this.vanillaGetter = vanillaGetter;
            this.configGetter = configGetter;
        }
    }
}

