/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.core.block.EntityHoldingBlock;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.trashcans.screen.TrashCanContainer;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TrashCanBlock
extends BaseBlock
implements EntityHoldingBlock {
    private static final BlockShape SHAPE = BlockShape.or((BlockShape)BlockShape.create((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.75, (double)0.8125), (BlockShape[])new BlockShape[]{BlockShape.create((double)0.125, (double)0.75, (double)0.125, (double)0.875, (double)0.8125, (double)0.875), BlockShape.create((double)0.1875, (double)0.78125, (double)0.1875, (double)0.8125, (double)0.84375, (double)0.8125)});
    private final Supplier<BaseBlockEntityType<?>> blockEntityType;
    private final BiFunction<EntityPlayer, BlockPos, TrashCanContainer> containerProvider;

    public TrashCanBlock(Supplier<BaseBlockEntityType<?>> blockEntityType, BiFunction<EntityPlayer, BlockPos, TrashCanContainer> containerProvider) {
        super(false, BlockProperties.create((Material)Material.field_151573_f, (MapColor)MapColor.field_151670_w).destroyTime(1.5f).explosionResistance(6.0f).requiresCorrectTool());
        this.blockEntityType = blockEntityType;
        this.containerProvider = containerProvider;
    }

    protected BaseBlock.InteractionFeedback interact(IBlockState state, World level, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing hitSide, Vec3d hitLocation) {
        if (!level.field_72995_K) {
            CommonUtils.openContainer((BaseContainer)((BaseContainer)this.containerProvider.apply(player, pos)));
        }
        return BaseBlock.InteractionFeedback.SUCCESS;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SHAPE.simplify();
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        SHAPE.forEachBox(box -> TrashCanBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, (List)collidingBoxes, (AxisAlignedBB)box));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.CENTER : BlockFaceShape.UNDEFINED;
    }

    public TileEntity createNewBlockEntity() {
        return this.blockEntityType.get().createBlockEntity();
    }

    protected void appendItemInformation(ItemStack stack, IBlockAccess level, Consumer<ITextComponent> info, boolean advanced) {
        info.accept(TextComponents.translation((String)("trashcans." + Registries.BLOCKS.getIdentifier((Object)this).func_110623_a() + ".info")).color(TextFormatting.GRAY).get());
    }
}

