/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.compat.jei;

import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.trashcans.TrashCanBlockEntity;
import com.supermartijn642.trashcans.TrashCans;
import com.supermartijn642.trashcans.compat.Compatibility;
import com.supermartijn642.trashcans.filter.ItemFilter;
import com.supermartijn642.trashcans.filter.LiquidTrashCanFilters;
import com.supermartijn642.trashcans.packet.PacketChangeItemFilter;
import com.supermartijn642.trashcans.packet.PacketChangeLiquidFilter;
import com.supermartijn642.trashcans.screen.ItemTrashCanScreen;
import com.supermartijn642.trashcans.screen.LiquidTrashCanScreen;
import com.supermartijn642.trashcans.screen.TrashCanContainer;
import com.supermartijn642.trashcans.screen.TrashCanScreen;
import com.supermartijn642.trashcans.screen.TrashCanWidgetContainerScreen;
import com.supermartijn642.trashcans.screen.UltimateTrashCanScreen;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class GhostIngredientHandler
implements IGhostIngredientHandler<TrashCanWidgetContainerScreen> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(TrashCanWidgetContainerScreen screen, I ingredient, boolean doStart) {
        int slot;
        TrashCanScreen<?> widget = screen.getWidget();
        TrashCanContainer container = screen.getContainer();
        ArrayList<Slot> itemFilterSlots = new ArrayList<Slot>();
        ArrayList<Slot> fluidFilterSlots = new ArrayList<Slot>();
        if (widget instanceof ItemTrashCanScreen) {
            for (slot = 1; slot <= 9; ++slot) {
                itemFilterSlots.add(container.func_75139_a(slot));
            }
        } else if (widget instanceof LiquidTrashCanScreen) {
            for (slot = 1; slot <= 9; ++slot) {
                fluidFilterSlots.add(container.func_75139_a(slot));
            }
        } else if (widget instanceof UltimateTrashCanScreen) {
            for (slot = 3; slot <= 11; ++slot) {
                itemFilterSlots.add(container.func_75139_a(slot));
            }
            for (slot = 12; slot <= 20; ++slot) {
                fluidFilterSlots.add(container.func_75139_a(slot));
            }
        }
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        if (ingredient instanceof ItemStack) {
            for (int i = 0; i < itemFilterSlots.size(); ++i) {
                int index = i;
                Slot slot2 = (Slot)itemFilterSlots.get(i);
                Rectangle bounds = new Rectangle(screen.getGuiLeft() + slot2.field_75223_e, screen.getGuiTop() + slot2.field_75221_f, 17, 17);
                IGhostIngredientHandler.Target<Object> target = GhostIngredientHandler.createTarget(bounds, input -> {
                    TrashCanBlockEntity entity = container.getBlockEntity();
                    if (entity != null) {
                        entity.itemFilter.set(index, (ItemStack)input);
                        TrashCans.CHANNEL.sendToServer((BasePacket)new PacketChangeItemFilter(container.getBlockEntityPos(), index, (ItemStack)input));
                    }
                });
                targets.add(target);
            }
        }
        ItemStack ingredientStack = ItemStack.field_190927_a;
        if (ingredient instanceof ItemStack) {
            ingredientStack = (ItemStack)ingredient;
        } else if (ingredient instanceof FluidStack) {
            ingredientStack = FluidUtil.getFilledBucket((FluidStack)((FluidStack)ingredient));
        } else if (Compatibility.MEKANISM.isGasStack(ingredient)) {
            ingredientStack = Compatibility.MEKANISM.getChemicalTankForGasStack(ingredient);
        }
        ItemFilter filter = LiquidTrashCanFilters.createFilter(ingredientStack);
        if (filter != null) {
            for (int i = 0; i < fluidFilterSlots.size(); ++i) {
                int index = i;
                Slot slot3 = (Slot)fluidFilterSlots.get(i);
                Rectangle bounds = new Rectangle(screen.getGuiLeft() + slot3.field_75223_e, screen.getGuiTop() + slot3.field_75221_f, 17, 17);
                IGhostIngredientHandler.Target<Object> target = GhostIngredientHandler.createTarget(bounds, input -> {
                    TrashCanBlockEntity entity = container.getBlockEntity();
                    if (entity != null) {
                        entity.liquidFilter.set(index, filter);
                        TrashCans.CHANNEL.sendToServer((BasePacket)new PacketChangeLiquidFilter(container.getBlockEntityPos(), index, filter));
                    }
                });
                targets.add(target);
            }
        }
        return targets;
    }

    private static <I> IGhostIngredientHandler.Target<I> createTarget(final Rectangle bounds, final Consumer<I> acceptor) {
        return new IGhostIngredientHandler.Target<I>(){

            public Rectangle getArea() {
                return bounds;
            }

            public void accept(I ingredient) {
                acceptor.accept(ingredient);
            }
        };
    }

    public void onComplete() {
    }
}

