/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.compat.mekanism;

import com.supermartijn642.trashcans.compat.Compatibility;
import com.supermartijn642.trashcans.filter.IFilterManager;
import com.supermartijn642.trashcans.filter.ItemFilter;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class GasFilterManager
implements IFilterManager {
    @Override
    public ItemFilter createFilter(ItemStack stack) {
        return new GasFilter(stack);
    }

    @Override
    public ItemFilter readFilter(NBTTagCompound compound) {
        return new GasFilter(compound);
    }

    private static class GasFilter
    extends ItemFilter {
        GasStack stack;

        public GasFilter(ItemStack stack) {
            this.stack = GasFilter.getGas(stack);
            if (this.stack != null) {
                this.stack = this.stack.copy();
            }
        }

        public GasFilter(NBTTagCompound compound) {
            this.stack = GasStack.readFromNBT((NBTTagCompound)compound);
        }

        @Override
        public boolean matches(Object stack) {
            GasStack fluid = stack instanceof GasStack ? (GasStack)stack : (stack instanceof ItemStack ? GasFilter.getGas((ItemStack)stack) : null);
            return fluid != null && fluid.isGasEqual(this.stack);
        }

        @Override
        public ItemStack getRepresentingItem() {
            return Compatibility.MEKANISM.getChemicalTankForGasStack(this.stack);
        }

        @Override
        public NBTTagCompound write() {
            return this.stack.write(new NBTTagCompound());
        }

        @Override
        public boolean isValid() {
            return this.stack != null && this.stack.amount > 0;
        }

        private static GasStack getGas(ItemStack stack) {
            GasStack gasStack = stack.func_77973_b() instanceof IGasItem ? ((IGasItem)stack.func_77973_b()).getGas(stack) : null;
            return gasStack != null && gasStack.amount > 0 ? gasStack : null;
        }
    }
}

