/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.volume;

import de.maxhenkel.voicechat.gui.widgets.DebouncedSlider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class AdjustVolumeSlider
extends DebouncedSlider {
    protected static final ITextComponent MUTED = new TextComponentTranslation("message.voicechat.muted", new Object[0]);
    protected static final float MAXIMUM = 4.0f;
    protected final VolumeConfigEntry volumeConfigEntry;

    public AdjustVolumeSlider(int id, int xIn, int yIn, int widthIn, int heightIn, VolumeConfigEntry volumeConfigEntry) {
        super(id, xIn, yIn, widthIn, heightIn, volumeConfigEntry.get() / 4.0);
        this.volumeConfigEntry = volumeConfigEntry;
        this.updateMessage();
    }

    @Override
    protected void updateMessage() {
        if (this.value <= 0.0) {
            this.field_146126_j = MUTED.func_150261_e();
            return;
        }
        long amp = Math.round(this.value * 4.0 * 100.0 - 100.0);
        this.field_146126_j = new TextComponentTranslation("message.voicechat.volume_amplification", new Object[]{((float)amp > 0.0f ? "+" : "") + amp + "%"}).func_150261_e();
    }

    @Override
    public void applyDebounced() {
        this.volumeConfigEntry.save(this.value * 4.0);
    }

    public static interface VolumeConfigEntry {
        public void save(double var1);

        public double get();
    }
}

